/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.engine.render.renderers;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import panoramakit.engine.render.CompositeImageRenderer;
import panoramakit.mod.PanoramaKit;

public class BackgroundRenderer
extends CompositeImageRenderer {
    private final Logger L;
    private int resolution;
    private File folderPath;
    private float orientation;

    public BackgroundRenderer(int resolution, File folderPath, float orientation) {
        super(resolution, resolution);
        this.L = PanoramaKit.instance.L;
        this.resolution = resolution;
        this.folderPath = folderPath;
        this.orientation = orientation;
    }

    @Override
    public void assembleImage() throws IOException {
        float yaw;
        long startTime = System.currentTimeMillis();
        BufferedImage image = new BufferedImage(this.resolution, this.resolution, 2);
        int i = 0;
        while (i < 4) {
            yaw = this.orientation + (float)((i - 1) * 90);
            this.rotatePlayer(yaw + 90.0f, 0.0f, 0.0f);
            int[] screenshot = this.captureScreenshot();
            image.setRGB(0, 0, this.resolution, this.resolution, screenshot, 0, this.resolution);
            this.saveBackgroundImage(image, i);
            ++i;
        }
        i = 0;
        while (i <= 2) {
            yaw = this.orientation;
            float pitch = (i - 1) * 90;
            this.rotatePlayer(yaw, pitch, 0.0f);
            int[] screenshot = this.captureScreenshot();
            image.setRGB(0, 0, this.resolution, this.resolution, screenshot, 0, this.resolution);
            this.saveBackgroundImage(image, 4 + i / 2);
            i += 2;
        }
        this.L.info("Background render: " + (System.currentTimeMillis() - startTime) + "ms");
    }

    public void saveBackgroundImage(BufferedImage image, int pieceNumber) throws IOException {
        File file = new File(this.folderPath, "panorama_" + pieceNumber + ".png");
        if (!file.exists()) {
            file.mkdirs();
            file.createNewFile();
        }
        ImageIO.write((RenderedImage)image, "png", file);
    }
}

