/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.engine.render;

import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import panoramakit.engine.accessor.EntityRendererAccessor;

public class TiledScreenshot {
    private final Minecraft mc = Minecraft.func_71410_x();
    private EntityRendererAccessor era = new EntityRendererAccessor();
    private int fullWidth;
    private int fullHeight;
    private int tileWidth;
    private int tileHeight;
    private IntBuffer captureBuffer;
    private int[] screenshot;
    private double camZoom;
    private float partialTicks = 0.0f;

    public TiledScreenshot(int screenshotWidth, int screenshotHeight, int tileWidth, int tileHeight) {
        this.fullWidth = screenshotWidth;
        this.fullHeight = screenshotHeight;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.captureBuffer = BufferUtils.createIntBuffer((int)(tileWidth * tileHeight));
        this.screenshot = new int[this.fullWidth * this.fullHeight];
        this.camZoom = (double)this.fullHeight / (double)tileHeight;
        if (this.camZoom == 1.0) {
            this.camZoom = 1.000000000001;
        }
    }

    public void capture() {
        if (this.mc.field_71443_c != this.tileWidth || this.mc.field_71440_d != this.tileHeight) {
            throw new IllegalStateException("Display size changed");
        }
        int tileOfsX = 0;
        while (tileOfsX < this.fullWidth) {
            int tileOfsY = 0;
            while (tileOfsY < this.fullHeight) {
                if (this.era != null) {
                    double camOfsX = this.fullWidth - this.tileWidth - tileOfsX * 2;
                    double camOfsY = this.fullHeight - this.tileHeight - tileOfsY * 2;
                    this.era.setCameraZoom(this.camZoom);
                    this.era.setCameraOffsetX(camOfsX /= (double)this.tileWidth);
                    this.era.setCameraOffsetY(camOfsY /= (double)this.tileHeight);
                }
                this.mc.field_71460_t.func_78480_b(this.partialTicks);
                this.captureBuffer.clear();
                GL11.glPixelStorei((int)3333, (int)1);
                GL11.glPixelStorei((int)3317, (int)1);
                GL11.glReadPixels((int)0, (int)0, (int)this.tileWidth, (int)this.tileHeight, (int)32993, (int)33639, (IntBuffer)this.captureBuffer);
                int captureWidth = this.tileWidth;
                int captureHeight = this.tileHeight;
                if (captureWidth > this.fullWidth - tileOfsX) {
                    captureWidth = this.fullWidth - tileOfsX;
                }
                if (captureHeight > this.fullHeight - tileOfsY) {
                    captureHeight = this.fullHeight - tileOfsY;
                }
                int i = 0;
                while (i < captureHeight) {
                    int bufferPosition = (captureHeight - i - 1) * this.tileWidth + (this.tileHeight - captureHeight) * this.tileWidth;
                    int arrayOffset = tileOfsX + tileOfsY * this.fullWidth + i * this.fullWidth;
                    this.captureBuffer.position(bufferPosition);
                    this.captureBuffer.get(this.screenshot, arrayOffset, captureWidth);
                    ++i;
                }
                tileOfsY += this.tileHeight;
            }
            tileOfsX += this.tileWidth;
        }
        int x = 0;
        while (x < this.fullWidth) {
            int y = 0;
            while (y < this.fullHeight) {
                this.screenshot[x + y * this.fullWidth] = this.screenshot[x + y * this.fullWidth] | 0xFF000000;
                ++y;
            }
            ++x;
        }
    }

    public int[] getScreenshot() {
        return this.screenshot;
    }
}

