/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.engine.accessor;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;

public class EntityRendererAccessor {
    private static final Logger L = Logger.getLogger(EntityRendererAccessor.class.getName());
    private static final int FIELD_SMOOTH_CAM_FILTER_X;
    private static final int FIELD_SMOOTH_CAM_FILTER_Y;
    private static final int FIELD_CAM_ZOOM;
    private static final int FIELD_CAM_XOFS;
    private static final int FIELD_CAM_YOFS;
    private static final int FIELD_PREV_FRAME_TIME;
    private static final int FIELD_CAM_ROLL;
    private static final int FIELD_PREV_CAM_ROLL;
    private final Minecraft mc = Minecraft.func_71410_x();

    static {
        Field[] fields = EntityRenderer.class.getDeclaredFields();
        int fieldOfs = -1;
        int i = 0;
        while (i < fields.length - 3) {
            if (fields[i].getType() == Double.TYPE && fields[i + 1].getType() == Double.TYPE && fields[i + 2].getType() == Double.TYPE && fields[i + 3].getType() == Long.TYPE) {
                fieldOfs = i;
                break;
            }
            ++i;
        }
        if (fieldOfs == -1) {
            L.severe("Couldn't find fields for EntityRenderer!");
            FIELD_SMOOTH_CAM_FILTER_X = 24;
            FIELD_SMOOTH_CAM_FILTER_Y = 25;
            FIELD_CAM_ZOOM = 39;
            FIELD_CAM_XOFS = 40;
            FIELD_CAM_YOFS = 41;
            FIELD_PREV_FRAME_TIME = 42;
            FIELD_CAM_ROLL = 28;
            FIELD_PREV_CAM_ROLL = 27;
        } else {
            FIELD_SMOOTH_CAM_FILTER_X = fieldOfs - 15;
            FIELD_SMOOTH_CAM_FILTER_Y = fieldOfs - 14;
            FIELD_CAM_ZOOM = fieldOfs;
            FIELD_CAM_XOFS = fieldOfs + 1;
            FIELD_CAM_YOFS = fieldOfs + 2;
            FIELD_PREV_FRAME_TIME = fieldOfs + 3;
            FIELD_CAM_ROLL = fieldOfs - 11;
            FIELD_PREV_CAM_ROLL = fieldOfs - 10;
        }
    }

    public void setCameraRoll(float cameraRoll) {
        try {
            ReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)this.mc.field_71460_t, (Object)Float.valueOf(cameraRoll), (int)FIELD_CAM_ROLL);
            ReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)this.mc.field_71460_t, (Object)Float.valueOf(cameraRoll), (int)FIELD_PREV_CAM_ROLL);
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, null, ex);
        }
    }

    public float getCameraRoll() {
        try {
            return ((Float)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)this.mc.field_71460_t, (int)FIELD_CAM_ROLL)).floatValue();
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, null, ex);
            return 0.0f;
        }
    }

    public void setCameraZoom(double zoom) {
        try {
            ReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)this.mc.field_71460_t, (Object)zoom, (int)FIELD_CAM_ZOOM);
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, null, ex);
        }
    }

    public double getCameraZoom() {
        try {
            return (Double)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)this.mc.field_71460_t, (int)FIELD_CAM_ZOOM);
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, null, ex);
            return 0.0;
        }
    }

    public void setCameraOffsetX(double offset) {
        try {
            ReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)this.mc.field_71460_t, (Object)offset, (int)FIELD_CAM_XOFS);
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, null, ex);
        }
    }

    public double getCameraOffsetX() {
        try {
            return (Double)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)this.mc.field_71460_t, (int)FIELD_CAM_XOFS);
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, null, ex);
            return 0.0;
        }
    }

    public void setCameraOffsetY(double offset) {
        try {
            ReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)this.mc.field_71460_t, (Object)offset, (int)FIELD_CAM_YOFS);
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, null, ex);
        }
    }

    public double getCameraOffsetY() {
        try {
            return (Double)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)this.mc.field_71460_t, (int)FIELD_CAM_YOFS);
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, null, ex);
            return 0.0;
        }
    }

    public void setPreviousFrameTime(long time) {
        try {
            ReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)this.mc.field_71460_t, (Object)time, (int)FIELD_PREV_FRAME_TIME);
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, null, ex);
        }
    }

    public double getPreviousFrameTime() {
        try {
            return (Double)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)this.mc.field_71460_t, (int)FIELD_PREV_FRAME_TIME);
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, null, ex);
            return 0.0;
        }
    }

    public void setSmoothCamFilterX(float value) {
        try {
            ReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)this.mc.field_71460_t, (Object)Float.valueOf(value), (int)FIELD_SMOOTH_CAM_FILTER_X);
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, null, ex);
        }
    }

    public float getSmoothCamFilterX() {
        try {
            return ((Float)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)this.mc.field_71460_t, (int)FIELD_SMOOTH_CAM_FILTER_X)).floatValue();
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, null, ex);
            return 0.0f;
        }
    }

    public void setSmoothCamFilterY(float value) {
        try {
            ReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)this.mc.field_71460_t, (Object)Float.valueOf(value), (int)FIELD_SMOOTH_CAM_FILTER_Y);
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, null, ex);
        }
    }

    public float getSmoothCamFilterY() {
        try {
            return ((Float)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)this.mc.field_71460_t, (int)FIELD_SMOOTH_CAM_FILTER_Y)).floatValue();
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, null, ex);
            return 0.0f;
        }
    }
}

