/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.converter.projections;

import panoramakit.converter.PositionMapper;
import panoramakit.converter.data.Position;
import panoramakit.converter.samplers.FlatSampler;

public class EquirectToStereographic
extends PositionMapper {
    public double relativeViewPlaneSize;
    public boolean customResolution;
    public int newWidth;
    public int newHeight;

    public EquirectToStereographic(PositionMapper preProjection, double fieldOfView, int newWidth, int newHeight) {
        super(preProjection, new FlatSampler());
        this.relativeViewPlaneSize = Math.tan(fieldOfView / 2.0 * (Math.PI / 180));
        this.customResolution = true;
        this.newWidth = newWidth;
        this.newHeight = newHeight;
    }

    public EquirectToStereographic(double fieldOfView, int newWidth, int newHeight) {
        this(null, fieldOfView, newWidth, newHeight);
    }

    public EquirectToStereographic(PositionMapper preProjection, double fieldOfView) {
        this(preProjection, fieldOfView, 0, 0);
        this.customResolution = false;
    }

    public EquirectToStereographic(double fieldOfView) {
        this(null, fieldOfView);
    }

    @Override
    public int getNewWidth(int width, int height) {
        if (this.customResolution) {
            return this.newWidth;
        }
        return width;
    }

    @Override
    public int getNewHeight(int width, int height) {
        if (this.customResolution) {
            return this.newHeight;
        }
        return height;
    }

    @Override
    public boolean testValidProportions() {
        if (this.inputWidth % 2 != 0) {
            return false;
        }
        return this.inputWidth / 2 == this.inputHeight / 1;
    }

    @Override
    public Position getProjectedPosition(double x, double y) {
        x += 0.5;
        y += 0.5;
        double polarAngle = Math.atan2(y -= (double)(this.outputHeight / 2), x -= (double)(this.outputWidth / 2));
        double distanceToCenter = Math.abs(x) > Math.abs(y) ? x / Math.cos(polarAngle) : y / Math.sin(polarAngle);
        double relativeDistanceToCenter = distanceToCenter / (double)(this.outputHeight / 2);
        double planarRadius = this.relativeViewPlaneSize * relativeDistanceToCenter;
        double domeVerticalAngle = Math.atan(planarRadius);
        double equirectangularYPos = 2.0 * domeVerticalAngle * ((double)this.inputHeight / Math.PI);
        double relativeX = (double)this.inputWidth * (-polarAngle / (Math.PI * 2));
        double xOut = relativeX + (double)(this.inputWidth / 2);
        double yOut = equirectangularYPos;
        if (yOut > (double)this.inputHeight) {
            yOut = this.inputHeight;
        }
        yOut = (double)this.inputHeight - yOut;
        xOut = (double)this.inputWidth - xOut;
        xOut = ((xOut - (double)(this.inputWidth / 4)) % (double)this.inputWidth + (double)this.inputWidth) % (double)this.inputWidth;
        x -= 0.5;
        y -= 0.5;
        return new Position(xOut, yOut);
    }
}

