/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.converter.projections;

import panoramakit.converter.PositionMapper;
import panoramakit.converter.data.Position;
import panoramakit.converter.samplers.FlatSampler;

public class EquirectToMollweide
extends PositionMapper {
    public EquirectToMollweide(PositionMapper preProjection) {
        super(preProjection, new FlatSampler());
    }

    public EquirectToMollweide() {
        this(null);
    }

    @Override
    public int getNewWidth(int width, int height) {
        return width;
    }

    @Override
    public int getNewHeight(int width, int height) {
        return height;
    }

    @Override
    public boolean testValidProportions() {
        if (this.inputWidth % 2 != 0) {
            return false;
        }
        return this.inputWidth / 2 == this.inputHeight / 1;
    }

    @Override
    public Position getProjectedPosition(double x, double y) {
        double relativeX = (x += 0.5) - (double)(this.outputWidth / 2);
        double relativeY = (y += 0.5) - (double)(this.outputHeight / 2);
        double scalelessY = 2.0 * relativeY / (double)this.outputHeight;
        double scale = Math.sqrt(1.0 - scalelessY * scalelessY);
        x = relativeX / scale + (double)(this.outputWidth / 2);
        y -= 0.5;
        if ((x -= 0.5) < 0.0 || x > (double)(this.outputWidth - 1)) {
            return null;
        }
        return new Position(x, y);
    }
}

