/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.converter.projections;

import panoramakit.converter.PositionMapper;
import panoramakit.converter.data.Position;
import panoramakit.converter.samplers.CubicSampler;

public class CubicToEquirect
extends PositionMapper {
    int resolution = -1;

    public CubicToEquirect(PositionMapper preProjection) {
        super(preProjection, new CubicSampler());
    }

    public CubicToEquirect() {
        this(null);
    }

    public CubicToEquirect(PositionMapper preProjection, int newResolution) {
        this(preProjection);
        this.resolution = newResolution;
    }

    public CubicToEquirect(int newResolution) {
        this(null, newResolution);
    }

    @Override
    public Position getProjectedPosition(double x, double y) {
        x += 0.5;
        y += 0.5;
        double inPieceSize = this.inputWidth / 4;
        double outPieceSize = this.outputWidth / 4;
        double radius = inPieceSize / 2.0;
        x -= outPieceSize / 2.0;
        x = (x + (double)this.inputWidth) % (double)this.inputWidth;
        int cardinalDirection = (int)Math.floor(x / outPieceSize) % 4;
        double xCenteredLocal = x % outPieceSize - outPieceSize / 2.0;
        double yCentered = y - outPieceSize;
        double horizontalAngle = xCenteredLocal * (Math.PI * 2 / (double)this.outputWidth);
        double verticalAngle = yCentered * (Math.PI * 2 / (double)this.outputWidth);
        double sinHorizontal = Math.sin(horizontalAngle);
        double cosHorizontal = Math.cos(horizontalAngle);
        double tanHorizontal = sinHorizontal / cosHorizontal;
        double tanVertical = Math.tan(verticalAngle);
        double x1 = tanHorizontal * radius;
        double y1 = tanVertical * radius / cosHorizontal;
        x1 = (x1 + inPieceSize / 2.0 + inPieceSize * (double)cardinalDirection) % (double)this.inputWidth;
        y1 += inPieceSize * 1.5;
        Position equator = new Position(x1 -= 0.5, y1 -= 0.5);
        if (inPieceSize <= (double)Math.round(equator.y) && (double)Math.round(equator.y) < inPieceSize * 2.0) {
            return equator;
        }
        int hemisphere = (int)(verticalAngle / Math.abs(verticalAngle));
        double distanceFromCenter = radius / Math.abs(tanVertical);
        double x2 = -cosHorizontal * distanceFromCenter;
        double y2 = -sinHorizontal * distanceFromCenter * (double)hemisphere;
        Position temp = CubicToEquirect.rotate(x2, y2, cardinalDirection * hemisphere);
        x2 = temp.x;
        y2 = temp.y;
        x2 += inPieceSize * 1.5;
        y2 = y2 + inPieceSize * 1.5 + (double)hemisphere * inPieceSize;
        Position polar = new Position(x2 -= 0.5, y2 -= 0.5);
        return polar;
    }

    public static Position rotate(double x, double y, int rotations) {
        rotations = (rotations + 4) % 4;
        int i = 0;
        while (i < rotations) {
            double temp = y;
            y = x;
            x = -temp;
            ++i;
        }
        return new Position(x, y);
    }

    @Override
    public boolean testValidProportions() {
        if (this.inputWidth % 4 != 0) {
            return false;
        }
        if (this.inputHeight % 3 != 0) {
            return false;
        }
        return this.inputWidth / 4 == this.inputHeight / 3;
    }

    @Override
    public int getNewWidth(int originalWidth, int originalHeight) {
        if (this.resolution == -1) {
            return originalWidth;
        }
        return this.resolution * 4;
    }

    @Override
    public int getNewHeight(int originalWidth, int originalHeight) {
        if (this.resolution == -1) {
            return 2 * originalHeight / 3;
        }
        return this.resolution * 2;
    }
}

