/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.converter.interpolators;

import panoramakit.converter.Interpolator;
import panoramakit.converter.data.ColorData;

public class BilinearInterpolator
extends Interpolator {
    public BilinearInterpolator() {
        super(2);
    }

    @Override
    public int getPixelValue(double xFraction, double yFraction, ColorData[][] pixels) {
        ColorData p00 = pixels[0][0];
        ColorData p01 = pixels[0][1];
        ColorData p10 = pixels[1][0];
        ColorData p11 = pixels[1][1];
        this.multiply(p00, (1.0 - xFraction) * (1.0 - yFraction));
        this.multiply(p01, (1.0 - xFraction) * yFraction);
        this.multiply(p10, xFraction * (1.0 - yFraction));
        this.multiply(p11, xFraction * yFraction);
        ColorData[] componentColorData = new ColorData[]{p00, p01, p10, p11};
        ColorData sum = this.getSum(componentColorData);
        return sum.getIntValue();
    }

    private void multiply(ColorData colorData, double intensity) {
        int i = 0;
        while (i < colorData.colorChannels.length) {
            colorData.colorChannels[i] = colorData.colorChannels[i] * intensity;
            ++i;
        }
    }

    private ColorData getSum(ColorData[] componentColorData) {
        double[] colorChannelSum = new double[4];
        ColorData[] colorDataArray = componentColorData;
        int n = componentColorData.length;
        int n2 = 0;
        while (n2 < n) {
            ColorData colorData = colorDataArray[n2];
            int i = 0;
            while (i < colorData.colorChannels.length) {
                int n3 = i;
                colorChannelSum[n3] = colorChannelSum[n3] + colorData.colorChannels[i];
                ++i;
            }
            ++n2;
        }
        return new ColorData(colorChannelSum);
    }
}

