/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.converter.data;

public class ColorData {
    public double[] colorChannels;

    public ColorData(int colorValue) {
        this.colorChannels = new double[]{colorValue >>> 24 & 0xFF, colorValue >>> 16 & 0xFF, colorValue >>> 8 & 0xFF, colorValue & 0xFF};
    }

    public ColorData(double[] colorChannels) {
        this.colorChannels = new double[4];
        System.arraycopy(colorChannels, 0, this.colorChannels, 0, colorChannels.length);
    }

    public int getIntValue() {
        int i = 0;
        while (i < this.colorChannels.length) {
            if (this.colorChannels[i] > 255.0) {
                this.colorChannels[i] = 255.0;
            }
            if (this.colorChannels[i] < 0.0) {
                this.colorChannels[i] = 0.0;
            }
            ++i;
        }
        int pixelValue = 0;
        pixelValue += (int)Math.round(this.colorChannels[0]) << 24;
        pixelValue += (int)Math.round(this.colorChannels[1]) << 16;
        pixelValue += (int)Math.round(this.colorChannels[2]) << 8;
        return pixelValue += (int)Math.round(this.colorChannels[3]);
    }
}

