/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.converter;

import panoramakit.converter.PixelSampler;
import panoramakit.converter.data.PixelCoordinate;
import panoramakit.converter.data.Position;

public abstract class PositionMapper {
    private PositionMapper preProjection;
    private PixelSampler sampler;
    public int inputHeight;
    public int inputWidth;
    public int outputHeight;
    public int outputWidth;

    public PositionMapper(PositionMapper preProjection, PixelSampler pixelSampler) {
        this.preProjection = preProjection;
        if (preProjection == null) {
            this.sampler = pixelSampler;
            if (this.sampler == null) {
                throw new RuntimeException("No pixel sampler available!");
            }
        }
    }

    public abstract int getNewWidth(int var1, int var2);

    public abstract int getNewHeight(int var1, int var2);

    public final void setResolution(int width, int height) {
        if (this.preProjection != null) {
            this.preProjection.setResolution(width, height);
            this.outputWidth = this.getNewWidth(this.preProjection.outputWidth, this.preProjection.outputHeight);
            this.outputHeight = this.getNewHeight(this.preProjection.outputWidth, this.preProjection.outputHeight);
            this.inputWidth = this.preProjection.outputWidth;
            this.inputHeight = this.preProjection.outputHeight;
        } else {
            this.outputWidth = this.getNewWidth(width, height);
            this.outputHeight = this.getNewHeight(width, height);
            this.inputWidth = width;
            this.inputHeight = height;
        }
    }

    public final int getWidth() {
        return this.outputWidth;
    }

    public final int getHeight() {
        return this.outputHeight;
    }

    public abstract boolean testValidProportions();

    public final boolean hasValidProportions() {
        boolean valid = this.testValidProportions();
        if (valid && this.preProjection != null) {
            valid = this.preProjection.hasValidProportions();
        }
        return valid;
    }

    public abstract Position getProjectedPosition(double var1, double var3);

    public final Position getPosition(double x, double y) {
        Position pos = this.getProjectedPosition(x, y);
        if (pos == null) {
            return pos;
        }
        if (this.preProjection == null) {
            return pos;
        }
        return this.preProjection.getPosition(pos.x, pos.y);
    }

    public final PixelCoordinate[][] getPixelCoordinates(Position position, int width, int height, int sampleSize) {
        if (this.preProjection == null) {
            return this.sampler.getSamplePixels(position, width, height, sampleSize);
        }
        return this.preProjection.getPixelCoordinates(position, width, height, sampleSize);
    }

    public final void setProjectionBounds() {
        if (this.preProjection != null) {
            this.preProjection.setProjectionBounds();
        } else {
            this.setBounds();
        }
    }

    public final void setBounds() {
        this.sampler.setAllBounds(this.inputWidth, this.inputHeight);
    }

    public final PixelSampler getPixelSampler() {
        if (this.preProjection == null) {
            return this.sampler;
        }
        return this.preProjection.getPixelSampler();
    }
}

