/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions;

import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.regions.EllipsoidRegionSelector;
import com.sk89q.worldedit.regions.RegionSelector;

public class SphereRegionSelector
extends EllipsoidRegionSelector {
    public SphereRegionSelector(LocalWorld world) {
        super(world);
    }

    public SphereRegionSelector() {
    }

    public SphereRegionSelector(RegionSelector oldSelector) {
        super(oldSelector);
        Vector radius = this.region.getRadius();
        double radiusScalar = Math.max(Math.max(radius.getX(), radius.getY()), radius.getZ());
        this.region.setRadius(new Vector(radiusScalar, radiusScalar, radiusScalar));
    }

    public SphereRegionSelector(LocalWorld world, Vector center, int radius) {
        super(world, center, new Vector(radius, radius, radius));
    }

    @Override
    public boolean selectSecondary(Vector pos) {
        Vector diff = pos.subtract(this.region.getCenter());
        Vector minRadius = Vector.getMaximum(diff, diff.multiply(-1.0));
        double minRadiusScalar = Math.max(Math.max(minRadius.getX(), minRadius.getY()), minRadius.getZ());
        this.region.extendRadius(new Vector(minRadiusScalar, minRadiusScalar, minRadiusScalar));
        return true;
    }

    @Override
    public void explainSecondarySelection(LocalPlayer player, LocalSession session, Vector pos) {
        if (this.isDefined()) {
            player.print("Radius set to " + this.region.getRadius().getX() + " (" + this.region.getArea() + ").");
        } else {
            player.print("Radius set to " + this.region.getRadius().getX() + ".");
        }
        session.describeCUI(player);
    }

    @Override
    public String getTypeName() {
        return "sphere";
    }
}

