/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.transform;

import cpw.mods.fml.common.FMLLog;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SMCLog {
    public static final String smclogName = "SMC";
    public static final Logger logger = new SMCLogger("SMC");
    public static final Level SMCINFO = new SMCLevel("INFO", 840);
    public static final Level SMCCONFIG = new SMCLevel("CONF", 830);
    public static final Level SMCFINE = new SMCLevel("FINE", 820);
    public static final Level SMCFINER = new SMCLevel("FINR", 810);
    public static final Level SMCFINEST = new SMCLevel("FINS", 800);

    public static void log(Level level, String format, Object ... args) {
        if (logger.isLoggable(level)) {
            logger.log(level, String.format(format, args));
        }
    }

    public static void severe(String format, Object ... args) {
        if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, String.format(format, args));
        }
    }

    public static void warning(String format, Object ... args) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, String.format(format, args));
        }
    }

    public static void info(String format, Object ... args) {
        if (logger.isLoggable(SMCINFO)) {
            logger.log(SMCINFO, String.format(format, args));
        }
    }

    public static void config(String format, Object ... args) {
        if (logger.isLoggable(SMCCONFIG)) {
            logger.log(SMCCONFIG, String.format(format, args));
        }
    }

    public static void fine(String format, Object ... args) {
        if (logger.isLoggable(SMCFINE)) {
            logger.log(SMCFINE, String.format(format, args));
        }
    }

    public static void finer(String format, Object ... args) {
        if (logger.isLoggable(SMCFINER)) {
            logger.log(SMCFINER, String.format(format, args));
        }
    }

    public static void finest(String format, Object ... args) {
        if (logger.isLoggable(SMCFINEST)) {
            logger.log(SMCFINEST, String.format(format, args));
        }
    }

    private static class SMCLevel
    extends Level {
        private SMCLevel(String name, int value) {
            super(name, value);
        }
    }

    private static class SMCLogger
    extends Logger {
        private SMCLogger(String name) {
            super(name, null);
            this.setParent(FMLLog.getLogger());
            this.setLevel(Level.ALL);
        }
    }
}

