/*
 * Decompiled with CFR 0.152.
 */
package piggypilot;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;
import piggypilot.FlyingPig;

public class PiggyPilot
extends JavaPlugin
implements Listener {
    Logger log = Logger.getLogger("Minecraft");
    String PREFIX = "[PiggyPilot v1.2.5] ";
    static HashMap<String, FlyingPig> flyingpigs = new HashMap();
    public static Economy economy = null;

    public void onEnable() {
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (this.getConfig().getBoolean("economy.enabled")) {
            Boolean success = this.setupEconomy();
            if (success.booleanValue()) {
                this.info("Vault hooked!");
            } else {
                this.info("WARNING! Plugin was not able to hook with vault! Please set 'economy.enabled' in the config to false!");
            }
        }
        if (this.getConfig().getBoolean("exhaust.enabled")) {
            this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    PiggyPilot.this.updateExhaust();
                }
            }, 20L, (long)this.getConfig().getInt("exhaust.exhaustspawninterval"));
        }
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                PiggyPilot.this.updatePigs();
            }
        }, 20L, (long)this.getConfig().getInt("fly.updatedelay"));
        if (this.getConfig().getBoolean("machinegun.enabled")) {
            this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    PiggyPilot.this.updateMachineGun();
                }
            }, 20L, (long)this.getConfig().getInt("machinegun.firespeed"));
        }
        this.info(" has been enabled");
    }

    private boolean setupEconomy() {
        RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            economy = (Economy)economyProvider.getProvider();
        }
        return economy != null;
    }

    public void onDisable() {
        this.info(" has been disabled");
    }

    public void info(String msg) {
        this.log.log(Level.INFO, String.valueOf(this.PREFIX) + msg);
    }

    public void updatePigs() {
        for (Map.Entry<String, FlyingPig> pairs : flyingpigs.entrySet()) {
            flyingpigs.get(pairs.getKey()).update();
        }
    }

    public void updateExhaust() {
        for (Map.Entry<String, FlyingPig> pairs : flyingpigs.entrySet()) {
            flyingpigs.get(pairs.getKey()).updateExhaust();
        }
    }

    public void updateMachineGun() {
        for (Map.Entry<String, FlyingPig> pairs : flyingpigs.entrySet()) {
            if (!PiggyPilot.flyingpigs.get((Object)pairs.getKey()).player.hasPermission("piggypilot.machinegun")) continue;
            flyingpigs.get(pairs.getKey()).updateMachineGun();
        }
    }

    @EventHandler
    public void PlayerInteract(PlayerInteractEvent event) {
        if (this.getConfig().getInt("fly.mode") == 1 && event.getPlayer().getVehicle() != null && event.getPlayer().getVehicle().getType() == EntityType.PIG && event.getPlayer().getItemInHand().getType() == Material.CARROT_STICK) {
            event.getPlayer().getVehicle().getLocation().setYaw(event.getPlayer().getLocation().getYaw());
            event.getPlayer().getVehicle().getLocation().setPitch(event.getPlayer().getLocation().getPitch());
            Vector vec = new Vector();
            vec.setX(event.getPlayer().getLocation().getDirection().getX() / (double)this.getConfig().getInt("fly.speed"));
            vec.setY(event.getPlayer().getLocation().getDirection().getY() / (double)this.getConfig().getInt("fly.speed"));
            vec.setZ(event.getPlayer().getLocation().getDirection().getZ() / (double)this.getConfig().getInt("fly.speed"));
            flyingpigs.get(event.getPlayer().getName()).setVector(vec, event.getPlayer().getLocation().getYaw(), event.getPlayer().getLocation().getPitch());
        }
        if (event.getPlayer().getVehicle() != null && event.getPlayer().getVehicle().getType() == EntityType.PIG) {
            PlayerInventory inventory = event.getPlayer().getInventory();
            ItemStack tntstack = new ItemStack(Material.TNT, 1);
            if (event.getPlayer().getItemInHand().getType() == Material.TNT && this.getConfig().getBoolean("tnt.enabled") && event.getPlayer().hasPermission("piggypilot.tnt")) {
                if (this.getConfig().getBoolean("economy.enabled") && economy.getBalance(event.getPlayer().getName()) >= this.getConfig().getDouble("economy.bombcost")) {
                    economy.withdrawPlayer(event.getPlayer().getName(), this.getConfig().getDouble("economy.bombcost"));
                    if (this.getConfig().getDouble("economy.bombcost") != 0.0) {
                        event.getPlayer().sendMessage(ChatColor.AQUA + "You have paid $" + this.getConfig().getDouble("economy.bombcost") + " to drop TNT from this pig.");
                    }
                    Location tntloc = new Location(event.getPlayer().getWorld(), event.getPlayer().getLocation().getX(), event.getPlayer().getLocation().getY(), event.getPlayer().getLocation().getZ());
                    event.getPlayer().getWorld().spawn(tntloc, TNTPrimed.class);
                    inventory.removeItem(new ItemStack[]{tntstack});
                } else {
                    if (this.getConfig().getBoolean("economy.enabled") && economy.getBalance(event.getPlayer().getName()) < this.getConfig().getDouble("economy.bombcost")) {
                        event.getPlayer().sendMessage(ChatColor.RED + "To drop a bomb costs $" + this.getConfig().getDouble("economy.bombcost") + ", you currently have only $" + economy.getBalance(event.getPlayer().getName()));
                        event.setCancelled(true);
                        return;
                    }
                    if (!this.getConfig().getBoolean("economy.enabled") && this.getConfig().getBoolean("tnt.enabled") && event.getPlayer().hasPermission("piggypilot.tnt")) {
                        Location tntloc = new Location(event.getPlayer().getWorld(), event.getPlayer().getLocation().getX(), event.getPlayer().getLocation().getY(), event.getPlayer().getLocation().getZ());
                        event.getPlayer().getWorld().spawn(tntloc, TNTPrimed.class);
                        inventory.removeItem(new ItemStack[]{tntstack});
                    }
                }
            }
        }
    }

    @EventHandler
    public void PlayerMove(PlayerMoveEvent event) {
        if (event.getPlayer().isInsideVehicle() && event.getPlayer().getVehicle().getType() == EntityType.PIG && this.getConfig().getInt("fly.mode") == 2) {
            try {
                Vector vec = new Vector();
                vec.setX(event.getPlayer().getLocation().getDirection().getX() / (double)this.getConfig().getInt("fly.speed"));
                vec.setY(event.getPlayer().getLocation().getDirection().getY() / (double)this.getConfig().getInt("fly.speed"));
                vec.setZ(event.getPlayer().getLocation().getDirection().getZ() / (double)this.getConfig().getInt("fly.speed"));
                flyingpigs.get(event.getPlayer().getName()).setVector(vec, event.getPlayer().getLocation().getYaw(), event.getPlayer().getLocation().getPitch());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @EventHandler
    public void EntityDamage(EntityDamageEvent event) {
        Player ply;
        Pig piggy;
        if (event.getEntity().getType() == EntityType.PIG && (piggy = (Pig)event.getEntity()).hasSaddle() && piggy.getPassenger() != null && event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            event.setCancelled(true);
        }
        if (event.getEntity().getType() == EntityType.PLAYER && (ply = (Player)event.getEntity()).isInsideVehicle() && ply.getVehicle().getType() == EntityType.PIG && event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void EntityDamage(EntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        if (event.getDamager() instanceof Player && event.getEntity().getType() == EntityType.PIG && event.getEntity().getPassenger() != null && event.getEntity().getPassenger().getType() == EntityType.PLAYER) {
            Player ply = (Player)event.getDamager();
            Player ply1 = (Player)event.getEntity().getPassenger();
            if (ply.getName().equalsIgnoreCase(ply1.getName())) {
                event.setCancelled(true);
            }
        }
        if (damager instanceof Arrow && event.getEntity().getType() == EntityType.PIG && event.getEntity().getPassenger() != null && event.getEntity().getPassenger().getType() == EntityType.PLAYER) {
            Arrow arrow = (Arrow)damager;
            Player ply = (Player)event.getEntity().getPassenger();
            if (arrow.getShooter() instanceof Player) {
                Player ply2 = (Player)arrow.getShooter();
                if (ply.getName().equalsIgnoreCase(ply2.getName())) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void EntityDeath(EntityDeathEvent event) {
        Pig piggy;
        if (event.getEntityType() == EntityType.PIG && (piggy = (Pig)event.getEntity()).getPassenger() != null && piggy.getPassenger().getType() == EntityType.PLAYER) {
            Player ply = (Player)piggy.getPassenger();
            flyingpigs.remove(ply.getName());
        }
    }

    @EventHandler
    public void VehicleEnterEvent(VehicleEnterEvent event) {
        if (event.getVehicle().getType() == EntityType.PIG) {
            Entity player = event.getEntered();
            Player ply = (Player)player;
            PlayerInventory inventory = ply.getInventory();
            if (!inventory.contains(Material.FISHING_ROD) && this.getConfig().getInt("flyType") == 1) {
                ply.sendMessage(ChatColor.RED + this.getConfig().getString("fly.NeedRodMessage"));
                event.setCancelled(true);
                return;
            }
            if (this.getConfig().getBoolean("economy.enabled") && economy.getBalance(ply.getName()) >= this.getConfig().getDouble("economy.flycost") && this.getConfig().getDouble("economy.flycost") != 0.0 && !ply.hasPermission("piggypilot.free")) {
                economy.withdrawPlayer(ply.getName(), this.getConfig().getDouble("economy.flycost"));
                ply.sendMessage(ChatColor.AQUA + "You have paid $" + this.getConfig().getDouble("economy.flycost") + " to fly on this pig.");
            } else if (ply.hasPermission("piggypilot.free") && this.getConfig().getString("economy.free") != "" && this.getConfig().getBoolean("economy.enabled")) {
                ply.sendMessage(ChatColor.AQUA + this.getConfig().getString("economy.free"));
            } else if (this.getConfig().getBoolean("economy.enabled") && economy.getBalance(ply.getName()) < this.getConfig().getDouble("economy.flycost")) {
                ply.sendMessage(ChatColor.RED + "To fly this pig costs $" + this.getConfig().getDouble("economy.flycost") + ", you only have $" + economy.getBalance(ply.getName()));
                event.setCancelled(true);
                return;
            }
            if (this.getConfig().getString("fly.BoardingMessage") != "") {
                ply.sendMessage(ChatColor.GOLD + this.getConfig().getString("fly.BoardingMessage"));
            }
            flyingpigs.put(ply.getName(), new FlyingPig(this, event.getVehicle(), ply.getName()));
        }
    }

    @EventHandler
    public void VehicleLeaveEvent(VehicleExitEvent event) {
        Player ply;
        if (event.getVehicle().getType() == EntityType.PIG && (ply = (Player)event.getExited()).hasPermission("piggypilot.fly")) {
            if (this.getConfig().getString("fly.ExitingMessage") != "") {
                ply.sendMessage(ChatColor.GOLD + this.getConfig().getString("fly.ExitingMessage"));
            }
            flyingpigs.remove(ply.getName());
        }
    }
}

