/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.worldandgenerationtweaks.loader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.launchwrapper.IClassTransformer;
import thebombzen.mods.worldandgenerationtweaks.loader.WAGTCorePlugin;

public class ASMClassTransformer
implements IClassTransformer {
    private JarFile wagtJarfile;

    public ASMClassTransformer() {
        URL[] urls;
        URLClassLoader urlcl = (URLClassLoader)WAGTCorePlugin.class.getClassLoader();
        for (URL url : urls = urlcl.getURLs()) {
            try {
                JarFile jarFile = new JarFile(new File(url.toURI()));
                if (jarFile.getEntry("thebombzen/mods/worldandgenerationtweaks/loader/ASMClassTransformer.class") == null) {
                    jarFile.close();
                    continue;
                }
                this.wagtJarfile = jarFile;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private byte[] getWAGTClass(String name) {
        if (this.wagtJarfile == null) {
            return null;
        }
        String fullName = name + ".class";
        JarEntry je = this.wagtJarfile.getJarEntry(fullName);
        if (je == null) {
            return null;
        }
        try {
            int n;
            InputStream in = this.wagtJarfile.getInputStream(je);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            while (-1 != (n = in.read(buf))) {
                baos.write(buf, 0, n);
            }
            baos.close();
            byte[] bytes = baos.toByteArray();
            if ((long)bytes.length != je.getSize()) {
                System.out.println("Invalid size for " + fullName + ": " + bytes.length + ", should be: " + je.getSize());
                return null;
            }
            return bytes;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public byte[] transform(String name, String newName, byte[] bytes) {
        if (name.length() > 3) {
            return bytes;
        }
        if (!name.toLowerCase().equals(name)) {
            return bytes;
        }
        byte[] newBytes = this.getWAGTClass(name);
        return newBytes != null ? newBytes : bytes;
    }
}

