/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.thebombzenapi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Properties;
import thebombzen.mods.thebombzenapi.ThebombzenAPI;
import thebombzen.mods.thebombzenapi.ThebombzenAPIBaseMod;
import thebombzen.mods.thebombzenapi.ThebombzenAPIConfigOption;

public abstract class ThebombzenAPIConfiguration<T extends Enum> {
    protected ThebombzenAPIBaseMod mod;
    protected Class<T> optionClass;
    protected Properties properties = new Properties();
    protected File propsFile;
    protected long storedConfigLastModified;

    public ThebombzenAPIConfiguration(ThebombzenAPIBaseMod baseMod, Class<T> optionClass) {
        this.mod = baseMod;
        this.optionClass = optionClass;
        this.propsFile = new File(new File(ThebombzenAPI.proxy.getMinecraftFolder(), "config"), this.mod.getClass().getSimpleName() + ".cfg");
    }

    public ThebombzenAPIConfigOption[] getAllOptions() {
        return (ThebombzenAPIConfigOption[])this.optionClass.getEnumConstants();
    }

    public String getProperty(ThebombzenAPIConfigOption option) {
        String value = this.properties.getProperty(option.toString());
        return value != null ? value : "";
    }

    public boolean getPropertyBoolean(ThebombzenAPIConfigOption option) {
        return Boolean.parseBoolean(this.getProperty(option));
    }

    protected File getPropertyFile() {
        return this.propsFile;
    }

    private void initializeDefaults() {
        for (ThebombzenAPIConfigOption option : this.getAllOptions()) {
            this.setPropertyWithoutSave(option, option.getDefaultValue());
        }
    }

    public void load() throws IOException {
        this.initializeDefaults();
        this.loadProperties();
        this.saveProperties();
    }

    protected void loadProperties() throws IOException {
        if (!this.propsFile.exists()) {
            this.propsFile.createNewFile();
        }
        FileInputStream is = new FileInputStream(this.getPropertyFile());
        this.properties.load(is);
        ((InputStream)is).close();
        for (ThebombzenAPIConfigOption option : this.getAllOptions()) {
            if (option.getDefaultToggleIndex() < 0) continue;
            this.mod.setToggleDefaultEnabled(option.getDefaultToggleIndex(), this.getPropertyBoolean(option));
        }
        this.storedConfigLastModified = this.getPropertyFile().lastModified();
    }

    public boolean reloadPropertiesFromFileIfChanged() throws IOException {
        if (this.shouldRefreshConfig()) {
            this.loadProperties();
            return true;
        }
        return false;
    }

    public void saveProperties() {
        try {
            PrintStream os = new PrintStream(new FileOutputStream(this.getPropertyFile()));
            this.properties.store(os, this.mod.getLongName() + " basic properties");
            Object[] options = this.getAllOptions();
            Arrays.sort(options);
            StringBuilder builder = new StringBuilder();
            for (Object option : options) {
                builder.append("# ").append(option.toString()).append(ThebombzenAPI.newLine);
                for (String info : option.getInfo()) {
                    builder.append("#     ").append(info).append(ThebombzenAPI.newLine);
                }
            }
            os.print(builder.toString());
            os.flush();
            os.close();
            this.storedConfigLastModified = this.getPropertyFile().lastModified();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setProperty(ThebombzenAPIConfigOption option, String value) {
        this.setPropertyWithoutSave(option, value);
        this.saveProperties();
    }

    protected void setPropertyWithoutSave(ThebombzenAPIConfigOption option, String value) {
        this.properties.setProperty(option.toString(), value);
    }

    protected boolean shouldRefreshConfig() {
        long configLastModified = this.getPropertyFile().lastModified();
        return this.storedConfigLastModified != configLastModified;
    }
}

