/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.thebombzenapi;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import thebombzen.mods.thebombzenapi.ThebombzenAPI;
import thebombzen.mods.thebombzenapi.ThebombzenAPIConfiguration;
import thebombzen.mods.thebombzenapi.client.ThebombzenAPIConfigScreen;

public abstract class ThebombzenAPIBaseMod {
    @SideOnly(value=Side.CLIENT)
    protected int[] toggleKeyCodes;
    @SideOnly(value=Side.CLIENT)
    protected boolean[] toggles;
    @SideOnly(value=Side.CLIENT)
    protected int[] activeKeyCodes;
    @SideOnly(value=Side.CLIENT)
    protected boolean[] defaultToggles;
    protected File modFolder;
    protected PrintStream debugLogger = null;
    protected StringBuilder debugBuilder = new StringBuilder();
    protected String prevDebugString = "";
    protected File debugFile;

    @SideOnly(value=Side.CLIENT)
    public abstract void activeKeyPressed(int var1);

    @SideOnly(value=Side.CLIENT)
    public abstract ThebombzenAPIConfigScreen createConfigScreen(awe var1);

    protected void finalize() throws Throwable {
        if (this.debugLogger != null) {
            this.debugLogger.close();
        }
    }

    protected void forceDebug(String string) {
        this.forceDebug("%s", string);
    }

    protected void forceDebug(String format, Object ... args) {
        String s = String.format(format, args);
        if (s.matches("=+")) {
            String total = this.debugBuilder.toString();
            this.debugBuilder = new StringBuilder();
            if (!total.equals(this.prevDebugString)) {
                this.debugLogger.print(total);
                this.debugLogger.flush();
                this.prevDebugString = total;
            }
        }
        this.debugBuilder.append(s).append(ThebombzenAPI.newLine);
    }

    @SideOnly(value=Side.CLIENT)
    public int getActiveKeyCode(int index) {
        if (this.getNumActiveKeys() <= 0) {
            throw new UnsupportedOperationException();
        }
        if (index < 0 || index >= this.getNumActiveKeys()) {
            throw new IndexOutOfBoundsException();
        }
        return this.activeKeyCodes[index];
    }

    @SideOnly(value=Side.CLIENT)
    public by getCompoundFromCurrentData() {
        by settings = new by();
        byte[] togglesByte = new byte[this.getNumToggleKeys()];
        for (int i = 0; i < this.getNumToggleKeys(); ++i) {
            togglesByte[i] = this.isToggleEnabled(i) ? (byte)1 : 0;
        }
        settings.a("toggles", togglesByte);
        by data = new by();
        data.a("Settings", settings);
        return data;
    }

    @SideOnly(value=Side.CLIENT)
    public by getCompoundFromDefaultData() {
        by settings = new by();
        byte[] togglesByte = new byte[this.getNumToggleKeys()];
        for (int i = 0; i < this.getNumToggleKeys(); ++i) {
            togglesByte[i] = this.isToggleDefaultEnabled(i) ? (byte)1 : 0;
        }
        settings.a("toggles", togglesByte);
        by data = new by();
        data.a("Settings", settings);
        return data;
    }

    public abstract ThebombzenAPIConfiguration<?> getConfiguration();

    @SideOnly(value=Side.CLIENT)
    public File getCorrectMemoryFile() {
        if (atv.w().f == null) {
            return null;
        }
        if (!atv.w().B()) {
            return new File(this.getModFolder(), "MEMORYSMP.dat");
        }
        return new File(((alq)atv.w().C().a(atv.w().h.ar).M()).b(), this.getLongName().toUpperCase() + "_MEMORY.dat");
    }

    public String getLatestVersion() {
        String latestVersion = null;
        try {
            URL versionURL = this.getVersionFileURL();
            BufferedReader br = new BufferedReader(new InputStreamReader(versionURL.openStream()));
            latestVersion = br.readLine();
            br.close();
        }
        catch (Throwable t) {
            latestVersion = this.getLongVersionString();
        }
        return latestVersion;
    }

    public abstract String getLongName();

    public abstract String getLongVersionString();

    public File getModFolder() {
        return this.modFolder;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract int getNumActiveKeys();

    @SideOnly(value=Side.CLIENT)
    public abstract int getNumToggleKeys();

    public abstract String getShortName();

    @SideOnly(value=Side.CLIENT)
    public int getToggleKeyCode(int index) {
        if (this.getNumToggleKeys() <= 0) {
            throw new UnsupportedOperationException();
        }
        if (index < 0 || index >= this.getNumToggleKeys()) {
            throw new IndexOutOfBoundsException();
        }
        return this.toggleKeyCodes[index];
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract String getToggleMessageString(int var1, boolean var2);

    public URL getVersionFileURL() {
        try {
            return new URL(this.getVersionFileURLString());
        }
        catch (MalformedURLException murle) {
            return null;
        }
    }

    protected abstract String getVersionFileURLString();

    @SideOnly(value=Side.CLIENT)
    public abstract boolean hasConfigScreen();

    @SideOnly(value=Side.CLIENT)
    public boolean isToggleDefaultEnabled(int index) {
        if (this.getNumToggleKeys() <= 0) {
            throw new UnsupportedOperationException();
        }
        if (index < 0 || index >= this.getNumToggleKeys()) {
            throw new IndexOutOfBoundsException();
        }
        return this.defaultToggles[index];
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isToggleEnabled(int index) {
        if (this.getNumToggleKeys() <= 0) {
            throw new UnsupportedOperationException();
        }
        if (index < 0 || index >= this.getNumToggleKeys()) {
            throw new IndexOutOfBoundsException();
        }
        return this.toggles[index];
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent fmlpie) {
        if (fmlpie.getSide().isClient()) {
            this.toggleKeyCodes = new int[this.getNumToggleKeys()];
            this.toggles = new boolean[this.getNumToggleKeys()];
            this.defaultToggles = new boolean[this.getNumToggleKeys()];
            this.activeKeyCodes = new int[this.getNumActiveKeys()];
        }
        ThebombzenAPI.registerMod(this);
        File mineFile = ThebombzenAPI.proxy.getMinecraftFolder();
        File modsFolder = new File(mineFile, "mods");
        this.modFolder = new File(modsFolder, this.getLongName());
        this.modFolder.mkdirs();
        this.debugFile = new File(this.modFolder, "DEBUG.txt");
        try {
            this.debugLogger = new PrintStream(new FileOutputStream(this.debugFile));
        }
        catch (FileNotFoundException fnfe) {
            this.debugLogger = null;
            this.throwException("Unable to open debug output file.", fnfe, false);
        }
        try {
            this.getConfiguration().load();
        }
        catch (IOException ioe) {
            this.throwException("Unable to open configuration!", ioe, true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void readFromCorrectMemoryFile() {
        File file = this.getCorrectMemoryFile();
        if (file != null) {
            by data = this.readFromMemoryFile(file);
            this.saveCompoundToCurrentData(data);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public by readFromMemoryFile(File file) {
        try {
            if (!file.isFile()) {
                this.writeToMemoryFile(file, this.getCompoundFromDefaultData());
                return this.getCompoundFromDefaultData();
            }
            FileInputStream in = new FileInputStream(file);
            by data = null;
            try {
                data = ci.a((InputStream)in);
            }
            catch (IOException ioe) {
                this.writeToMemoryFile(file, this.getCompoundFromCurrentData());
            }
            if (data != null) {
                return data;
            }
        }
        catch (IOException ioe) {
            this.throwException("Couldn't read from memory file.", ioe, false);
        }
        return this.getCompoundFromCurrentData();
    }

    @SideOnly(value=Side.CLIENT)
    public void saveCompoundToCurrentData(by data) {
        by settings = data.l("Settings");
        if (settings == null) {
            return;
        }
        byte[] togglesByte = settings.j("toggles");
        if (togglesByte.length == 0) {
            for (int i = 0; i < this.getNumToggleKeys(); ++i) {
                this.setToggleEnabled(i, this.isToggleDefaultEnabled(i), false);
            }
        } else {
            for (int i = 0; i < this.getNumToggleKeys(); ++i) {
                this.setToggleEnabled(i, togglesByte[i] != 0, false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setActiveKeyCode(int index, int keyCode) {
        if (this.getNumActiveKeys() <= 0) {
            throw new UnsupportedOperationException();
        }
        if (index < 0 || index >= this.getNumActiveKeys()) {
            throw new IndexOutOfBoundsException();
        }
        this.activeKeyCodes[index] = keyCode;
    }

    @SideOnly(value=Side.CLIENT)
    public void setToggleDefaultEnabled(int index, boolean enabled) {
        if (this.getNumToggleKeys() <= 0) {
            throw new UnsupportedOperationException();
        }
        if (index < 0 || index >= this.getNumToggleKeys()) {
            throw new IndexOutOfBoundsException();
        }
        this.defaultToggles[index] = enabled;
    }

    @SideOnly(value=Side.CLIENT)
    public void setToggleEnabled(int index, boolean enabled, boolean keyPress) {
        if (this.getNumToggleKeys() <= 0) {
            throw new UnsupportedOperationException();
        }
        if (index < 0 || index >= this.getNumToggleKeys()) {
            throw new IndexOutOfBoundsException();
        }
        this.toggles[index] = enabled;
        if (keyPress) {
            atv.w().h.a(cv.d((String)this.getToggleMessageString(index, enabled)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setToggleKeyCode(int index, int keyCode) {
        if (this.getNumToggleKeys() <= 0) {
            throw new UnsupportedOperationException();
        }
        if (index < 0 || index >= this.getNumToggleKeys()) {
            throw new IndexOutOfBoundsException();
        }
        this.toggleKeyCodes[index] = keyCode;
    }

    public void throwException(String info, Throwable exception, boolean fatal) {
        System.err.println(info);
        exception.printStackTrace();
        if (this.debugLogger != null) {
            this.debugLogger.println(info);
            exception.printStackTrace(this.debugLogger);
            this.debugLogger.flush();
        }
        if (fatal) {
            throw new RuntimeException(info, exception);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void writeToCorrectMemoryFile() {
        File file = this.getCorrectMemoryFile();
        if (file != null) {
            by data = this.getCompoundFromCurrentData();
            this.writeToMemoryFile(file, data);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void writeToMemoryFile(File file, by config) {
        try {
            file.delete();
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            ci.a((by)config, (OutputStream)fos);
        }
        catch (IOException ioe) {
            this.throwException("Couldn't write to memory file.", ioe, false);
        }
    }
}

