/*
 * Decompiled with CFR 0.152.
 */
package smoothbedrock.worldgeneration;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import smoothbedrock.SmoothBedrookConfig;

public class SmoothBedrockWorldGeneration
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!SmoothBedrookConfig.isActive() || world.field_73011_w.field_76577_b == WorldType.field_77138_c || !SmoothBedrookConfig.isValidDimension(world)) {
            return;
        }
        boolean isNether = world.field_73011_w.field_76574_g == -1;
        int blockId = 0;
        int blockMeta = 0;
        int posX = 0;
        int posZ = 0;
        int defaultBlockId = SmoothBedrookConfig.getDefaultBlockID(world, chunkX, chunkZ);
        int defaultBlockMeta = SmoothBedrookConfig.getDefaultBlockMetadata(world, chunkX, chunkZ);
        if (!SmoothBedrookConfig.isValidDimension(world)) {
            return;
        }
        boolean isDefaultStone = defaultBlockId == Block.field_71981_t.field_71990_ca;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int posY;
                posX = chunkX * 16 + x;
                posZ = chunkZ * 16 + z;
                if (isNether) {
                    for (posY = 128; posY > 121; --posY) {
                        if (!this.isBedrock(world, posX, posY, posZ)) continue;
                        world.func_72832_d(posX, posY, posZ, defaultBlockId, defaultBlockMeta, 2);
                    }
                }
                for (posY = 5; posY > 0; --posY) {
                    if (!this.isBedrock(world, posX, posY, posZ)) continue;
                    double rand = random.nextDouble();
                    if (isDefaultStone && SmoothBedrookConfig.spawnDiamonds() && rand < 1.0E-5) {
                        blockId = Block.field_72073_aw.field_71990_ca;
                        blockMeta = 0;
                    } else if (isDefaultStone && SmoothBedrookConfig.spawnRedstone() && rand < 2.0E-4) {
                        blockId = Block.field_72047_aN.field_71990_ca;
                        blockMeta = 0;
                    } else if (isDefaultStone && SmoothBedrookConfig.spawnLapis() && rand < 5.0E-4) {
                        blockId = Block.field_71947_N.field_71990_ca;
                        blockMeta = 0;
                    } else if (isDefaultStone && SmoothBedrookConfig.spawnLava() && rand < 0.05) {
                        blockId = Block.field_71938_D.field_71990_ca;
                        blockMeta = 0;
                    } else {
                        blockId = defaultBlockId;
                        blockMeta = defaultBlockMeta;
                    }
                    try {
                        world.func_72832_d(posX, posY, posZ, blockId, blockMeta, 2);
                        continue;
                    }
                    catch (Exception ex) {
                        world.func_72832_d(posX, posY, defaultBlockId, defaultBlockMeta, 0, 2);
                    }
                }
            }
        }
    }

    private boolean isBedrock(World world, int x, int y, int z) {
        return world.func_72798_a(x, y, z) == Block.field_71986_z.field_71990_ca;
    }
}

