/*
 * Decompiled with CFR 0.152.
 */
package smoothbedrock;

import java.util.Hashtable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public class SmoothBedrookConfig {
    private static boolean _isActive;
    private static boolean _spawnDiamonds;
    private static boolean _spawnLava;
    private static boolean _spawnRedstone;
    private static boolean _spawnLapis;
    private static boolean _usedForNether;
    private static boolean _usedForTwilighForest;
    private static boolean _usedForGalacticraft;
    private static Hashtable<Integer, Boolean> _dimensions;
    private static Hashtable<Integer, Integer> _dimensionDefaultBlock;
    private static Hashtable<Integer, Integer> _dimensionDefaultBlockMeta;

    public static boolean isActive() {
        return _isActive;
    }

    public static boolean spawnDiamonds() {
        return _spawnDiamonds;
    }

    public static boolean spawnLava() {
        return _spawnLava;
    }

    public static boolean spawnRedstone() {
        return _spawnRedstone;
    }

    public static boolean spawnLapis() {
        return _spawnLapis;
    }

    public static boolean usedForNether() {
        return _usedForNether;
    }

    public static boolean usedForTwilighForest() {
        return _usedForTwilighForest;
    }

    public static boolean usedForGalacticraft() {
        return _usedForGalacticraft;
    }

    public static void readConfig(Configuration config) {
        _dimensions = new Hashtable();
        _dimensionDefaultBlock = new Hashtable();
        _dimensionDefaultBlockMeta = new Hashtable();
        _dimensions.put(0, true);
        _dimensionDefaultBlock.put(0, Block.field_71981_t.field_71990_ca);
        _dimensionDefaultBlockMeta.put(0, 0);
        _dimensions.put(-1, SmoothBedrookConfig.usedForNether());
        _dimensionDefaultBlock.put(-1, Block.field_72012_bb.field_71990_ca);
        _dimensionDefaultBlockMeta.put(-1, 0);
        _dimensions.put(1, false);
        _dimensionDefaultBlock.put(1, 0);
        _dimensionDefaultBlockMeta.put(1, 0);
        _isActive = config.get("WorldGeneration", "isActive", true, "true, smooths out those annoying bumps of bedrock").getBoolean(true);
        _usedForNether = config.get("WorldGeneration", "usedForNether", true, "true, applies in the generation of the nether").getBoolean(true);
        _usedForTwilighForest = config.get("WorldGeneration", "usedForTwilighForest", true, "true, applies in the generation of twilight forest").getBoolean(true);
        _usedForGalacticraft = config.get("WorldGeneration", "usedForGalacticraft", true, "true, applies in the generation of Galacticcraft Dimensions").getBoolean(true);
        _spawnDiamonds = config.get("WorldGeneration", "spawnDiamonds", true, "true, if diamonds (very low chance) should be generated as bedrock alternative.").getBoolean(true);
        _spawnLava = config.get("WorldGeneration", "spawnLava", true, "true, if lava should be generated as bedrock alternative").getBoolean(true);
        _spawnRedstone = config.get("WorldGeneration", "spawnRedstone", true, "true, if redstone (low chance) should be generated as bedrock alternative.").getBoolean(true);
        _spawnLapis = config.get("WorldGeneration", "spawnLapis", true, "true, if lapis (low chance) should be generated as bedrock alternative.").getBoolean(true);
    }

    public static boolean isValidDimension(World world) {
        if (!_dimensions.containsKey(world.field_73011_w.field_76574_g)) {
            if (world.field_73011_w.func_80007_l().equalsIgnoreCase("Twilight Forest")) {
                _dimensions.put(world.field_73011_w.field_76574_g, SmoothBedrookConfig.usedForTwilighForest());
            } else if (world.field_73011_w.func_80007_l().equalsIgnoreCase("Moon") || world.field_73011_w.func_80007_l().equalsIgnoreCase("Mars")) {
                _dimensions.put(world.field_73011_w.field_76574_g, SmoothBedrookConfig.usedForGalacticraft());
            } else {
                _dimensions.put(world.field_73011_w.field_76574_g, false);
            }
        }
        return _dimensions.get(world.field_73011_w.field_76574_g);
    }

    public static int getDefaultBlockID(World world, int chunkX, int chunkZ) {
        if (!_dimensionDefaultBlock.containsKey(world.field_73011_w.field_76574_g)) {
            int posX = 0;
            int posZ = 0;
            Object namelist = null;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    posX = chunkX * 16 + x;
                    posZ = chunkZ * 16 + z;
                    for (int posY = 5; posY > 0; --posY) {
                        try {
                            ItemStack is = new ItemStack(Block.field_71973_m[world.func_72798_a(posX, posY, posZ)], 1, world.func_72805_g(posX, posY, posZ));
                            if (!SmoothBedrookConfig.isSearchedBlock(is.func_82833_r())) continue;
                            return SmoothBedrookConfig.setDimensionValues(world, posX, posZ, posY);
                        }
                        catch (Exception e) {
                            continue;
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                }
            }
            _dimensions.put(world.field_73011_w.field_76574_g, false);
            _dimensionDefaultBlock.put(world.field_73011_w.field_76574_g, 0);
            _dimensionDefaultBlockMeta.put(world.field_73011_w.field_76574_g, 0);
        }
        return _dimensionDefaultBlock.get(world.field_73011_w.field_76574_g);
    }

    private static boolean isSearchedBlock(String name) {
        return name.contains("Stone");
    }

    private static int setDimensionValues(World world, int posX, int posZ, int posY) {
        _dimensionDefaultBlock.put(world.field_73011_w.field_76574_g, world.func_72798_a(posX, posY, posZ));
        _dimensionDefaultBlockMeta.put(world.field_73011_w.field_76574_g, world.func_72805_g(posX, posY, posZ));
        return _dimensionDefaultBlock.get(world.field_73011_w.field_76574_g);
    }

    public static int getDefaultBlockMetadata(World world, int chunkX, int chunkZ) {
        if (!_dimensionDefaultBlockMeta.containsKey(world.field_73011_w.field_76574_g)) {
            SmoothBedrookConfig.getDefaultBlockID(world, chunkX, chunkZ);
        }
        return _dimensionDefaultBlockMeta.get(world.field_73011_w.field_76574_g);
    }
}

