/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Util;

import CustomOreGen.Util.IGeometryBuilder;
import java.util.Hashtable;
import java.util.Map;

public class WireframeShapes {
    private static float[][] _cubePoints = new float[][]{{1.0f, -1.0f, 1.0f}, {-1.0f, -1.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {-1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, -1.0f}, {-1.0f, 1.0f, -1.0f}, {1.0f, -1.0f, -1.0f}, {-1.0f, -1.0f, -1.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}};
    private static Map _circlePointCache;

    public static void addUnitWireCube(IGeometryBuilder builder) {
        builder.setVertexMode(IGeometryBuilder.PrimitiveType.QUAD, 1, 2);
        builder.addVertex(_cubePoints[0], _cubePoints[8], null, null);
        builder.addVertex(_cubePoints[1], _cubePoints[9], null, null);
        builder.addVertex(_cubePoints[2], _cubePoints[10], null, null);
        builder.addVertex(_cubePoints[3], _cubePoints[11], null, null);
        builder.addVertex(_cubePoints[4], _cubePoints[12], null, null);
        builder.addVertex(_cubePoints[5], _cubePoints[13], null, null);
        builder.addVertex(_cubePoints[6], _cubePoints[14], null, null);
        builder.addVertex(_cubePoints[7], _cubePoints[15], null, null);
        builder.setVertexMode(IGeometryBuilder.PrimitiveType.QUAD, 1, 2);
        builder.addVertexRef(6);
        builder.addVertexRef(5);
        builder.addVertexRef(10);
        builder.addVertexRef(5);
        builder.addVertexRef(11);
        builder.addVertexRef(6);
        builder.addVertexRef(11);
        builder.addVertexRef(10);
    }

    public static void addUnitWireSphere(IGeometryBuilder builder, int segments, int stacks) {
        if (segments >= 2 && stacks >= 2) {
            int s;
            int offset;
            builder.setVertexMode(IGeometryBuilder.PrimitiveType.QUAD, segments + 1, segments + 2, 1);
            float[][] xycoords = WireframeShapes.getCirclePoints(segments, null);
            float[][] zcoords = WireframeShapes.getCirclePoints(2 * stacks, null);
            float[] pos = new float[3];
            for (offset = 1; offset < stacks; ++offset) {
                for (s = 0; s < segments; ++s) {
                    pos[0] = zcoords[offset][1] * xycoords[s][0];
                    pos[1] = zcoords[offset][1] * xycoords[s][1];
                    pos[2] = zcoords[offset][0];
                    builder.addVertex(pos, pos, null, null);
                }
                builder.addVertexRef(segments);
            }
            builder.setVertexMode(IGeometryBuilder.PrimitiveType.TRIANGLE, 1);
            pos[1] = 0.0f;
            pos[0] = 0.0f;
            pos[2] = 1.0f;
            offset = (segments + 1) * (stacks - 2) + 1;
            builder.addVertexRef(offset);
            for (s = 1; s <= segments; ++s) {
                if (s == 1) {
                    builder.addVertex(pos, pos, null, null);
                } else {
                    builder.addVertexRef(2);
                }
                builder.addVertexRef(offset + 3 * s);
            }
            builder.setVertexMode(IGeometryBuilder.PrimitiveType.TRIANGLE, 1);
            pos[1] = 0.0f;
            pos[0] = 0.0f;
            pos[2] = -1.0f;
            offset = 3 * segments + 2;
            builder.addVertexRef(offset);
            for (s = 1; s <= segments; ++s) {
                if (s == 1) {
                    builder.addVertex(pos, pos, null, null);
                } else {
                    builder.addVertexRef(2);
                }
                builder.addVertexRef(offset + s);
            }
        }
    }

    public static void addUnitMercatorSphere(IGeometryBuilder builder, int segments, int stacks) {
        if (segments >= 2 && stacks >= 2) {
            builder.setVertexMode(IGeometryBuilder.PrimitiveType.QUAD, segments + 1, segments + 2, 1);
            float[][] xycoords = WireframeShapes.getCirclePoints(segments, null);
            float[][] zcoords = WireframeShapes.getCirclePoints(2 * stacks, null);
            float[] pos = new float[3];
            float[] tex = new float[2];
            for (int t = 0; t <= stacks; ++t) {
                double tmp = Math.log((1.0f + zcoords[t][0]) / zcoords[t][1]);
                tex[1] = (float)Math.max(0.0, Math.min(1.0, tmp / 4.8725 + 0.5));
                for (int s = 0; s < segments; ++s) {
                    pos[0] = zcoords[t][1] * xycoords[s][0];
                    pos[1] = zcoords[t][1] * xycoords[s][1];
                    pos[2] = zcoords[t][0];
                    tex[0] = (float)s / (float)segments;
                    builder.addVertex(pos, pos, null, tex);
                }
                pos[0] = zcoords[t][1] * xycoords[0][0];
                pos[1] = zcoords[t][1] * xycoords[0][1];
                pos[2] = zcoords[t][0];
                tex[0] = 1.0f;
                builder.addVertex(pos, pos, null, tex);
            }
        }
    }

    public static void addUnitCircle(IGeometryBuilder builder, int segments) {
        if (segments >= 2) {
            float[][] pts = WireframeShapes.getCirclePoints(segments, null);
            builder.setVertexMode(IGeometryBuilder.PrimitiveType.LINE, 1);
            for (int s = 0; s < segments; ++s) {
                builder.addVertex(pts[s], pts[s], null, null);
            }
            builder.addVertexRef(segments);
        }
    }

    public static float[][] getCirclePoints(int segments, float[][] output) {
        if (output == null) {
            output = (float[][])_circlePointCache.get(segments);
            if (output != null) {
                return output;
            }
            output = new float[segments][3];
            _circlePointCache.put(segments, output);
        }
        float da = (float)Math.PI * 2 / (float)segments;
        float angle = 0.0f;
        for (int s = 0; s < segments; ++s) {
            output[s][0] = (float)Math.cos(angle);
            output[s][1] = (float)Math.sin(angle);
            output[s][2] = 0.0f;
            angle += da;
        }
        return output;
    }

    static {
        for (int i = 0; i < 24; ++i) {
            WireframeShapes._cubePoints[8 + i % 8][i / 8] = _cubePoints[i % 8][i / 8] * (float)Math.sqrt(3.0);
        }
        _circlePointCache = new Hashtable();
    }
}

