/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CIStringMap<V>
implements Map<String, V> {
    protected final Map<String, V> backingMap;
    protected final Map<String, String> keyMap;

    public CIStringMap(Map<String, V> backingMap) {
        this.backingMap = backingMap;
        this.keyMap = new HashMap<String, String>();
        for (Map.Entry<String, V> entry : backingMap.entrySet()) {
            String key = entry.getKey();
            String ukey = this.uniformKey(key);
            if (this.keyMap.containsKey(ukey)) {
                throw new IllegalArgumentException("Backing set contains duplicate key '" + key + "'");
            }
            this.keyMap.put(ukey, key);
        }
    }

    public CIStringMap() {
        this.backingMap = new HashMap<String, V>();
        this.keyMap = new HashMap<String, String>();
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        String ukey;
        if (key != null && (key = this.keyMap.get(ukey = this.uniformKey((String)key))) == null) {
            return false;
        }
        return this.backingMap.containsKey(key);
    }

    public String getCanonicalKey(String key) {
        String ukey = this.uniformKey(key);
        return this.keyMap.get(ukey);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backingMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        String ukey;
        if (key != null && (key = this.keyMap.get(ukey = this.uniformKey((String)key))) == null) {
            return null;
        }
        return this.backingMap.get(key);
    }

    @Override
    public V put(String key, V value) {
        if (key != null) {
            String ukey = this.uniformKey(key);
            String oldKey = this.keyMap.get(ukey);
            this.keyMap.put(ukey, key);
            if (oldKey != null) {
                V oldValue = this.backingMap.remove(oldKey);
                this.backingMap.put(key, value);
                return oldValue;
            }
        }
        return this.backingMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        String ukey;
        if (key != null && (key = this.keyMap.remove(ukey = this.uniformKey((String)key))) == null) {
            return null;
        }
        return this.backingMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        for (Map.Entry<String, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.keyMap.clear();
        this.backingMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.backingMap.values();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this.backingMap.entrySet();
    }

    @Override
    public int hashCode() {
        return this.backingMap.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof CIStringMap ? this.backingMap.equals(((CIStringMap)obj).backingMap) : false;
    }

    public String toString() {
        return this.backingMap.toString();
    }

    protected String uniformKey(String rawKey) {
        return rawKey == null ? null : rawKey.toLowerCase();
    }
}

