/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Server;

import CustomOreGen.Config.ConfigParser;
import CustomOreGen.Server.IOreDistribution;
import CustomOreGen.Util.CIStringMap;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;

public class DistributionSettingMap {
    private final Map<String, Object[]> _settingMap = new CIStringMap<Object[]>(new LinkedHashMap());

    public DistributionSettingMap(Class distributionType) {
        for (Field field : distributionType.getFields()) {
            DistributionSetting s = field.getAnnotation(DistributionSetting.class);
            if (s == null) continue;
            this._settingMap.put(s.name(), new Object[]{field, s});
        }
    }

    public Map<String, String> getDescriptions() {
        CIStringMap<String> descriptions = new CIStringMap<String>(new LinkedHashMap());
        for (Map.Entry<String, Object[]> entry : this._settingMap.entrySet()) {
            DistributionSetting s = (DistributionSetting)entry.getValue()[1];
            descriptions.put(s.name(), s.info());
        }
        return descriptions;
    }

    public String getDescription(String settingName) {
        Object[] entry = this._settingMap.get(settingName);
        return entry == null ? null : ((DistributionSetting)entry[1]).info();
    }

    public Object get(IOreDistribution dist, String settingName) {
        if (dist == null) {
            return null;
        }
        Object[] entry = this._settingMap.get(settingName);
        if (entry == null) {
            return null;
        }
        Field field = (Field)entry[0];
        if (field == null) {
            return null;
        }
        try {
            return field.get(dist);
        }
        catch (IllegalAccessException var6) {
            return null;
        }
        catch (ClassCastException var7) {
            return null;
        }
    }

    public void set(IOreDistribution dist, String settingName, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (dist != null) {
            Object[] entry = this._settingMap.get(settingName);
            if (entry == null) {
                throw new IllegalArgumentException("Setting '" + settingName + "' is not supported by distribution '" + dist + "'");
            }
            Field field = (Field)entry[0];
            DistributionSetting annotation = (DistributionSetting)entry[1];
            if (value != null && value instanceof String) {
                value = ConfigParser.parseString(field.getType(), (String)value);
            }
            if (Modifier.isFinal(field.getModifiers())) {
                try {
                    Object ex = field.get(dist);
                    if (!Copyable.class.isAssignableFrom(field.getType())) {
                        throw new IllegalStateException("Setting is final and does not support copying");
                    }
                    if (ex == null || value == null) {
                        throw new IllegalStateException("Setting is final and null");
                    }
                    ((Copyable)ex).copyFrom(value);
                }
                catch (Exception var8) {
                    throw new IllegalArgumentException("Failed to copy setting '" + annotation.name() + "' for distribution '" + dist + "'", var8);
                }
            } else {
                field.set(dist, value);
            }
        }
    }

    public void inheritAll(IOreDistribution source, IOreDistribution destination) {
        for (Map.Entry<String, Object[]> entry : this._settingMap.entrySet()) {
            Field field = (Field)entry.getValue()[0];
            DistributionSetting annotation = (DistributionSetting)entry.getValue()[1];
            try {
                if (!annotation.inherited()) continue;
                Object ex = field.get(source);
                if (Modifier.isFinal(field.getModifiers())) {
                    Object dstVal = field.get(destination);
                    if (!Copyable.class.isAssignableFrom(field.getType())) {
                        throw new IllegalStateException("Setting is final and does not support copying");
                    }
                    if (ex == null || dstVal == null) {
                        throw new IllegalStateException("Setting is null");
                    }
                    ((Copyable)dstVal).copyFrom(ex);
                    continue;
                }
                field.set(destination, ex);
            }
            catch (Exception var9) {}
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface DistributionSetting {
        public String name();

        public String info() default "";

        public boolean inherited() default true;
    }

    public static interface Copyable<T> {
        public void copyFrom(T var1);
    }
}

