/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen;

import CustomOreGen.Client.ClientState;
import CustomOreGen.CustomOreGenBase;
import CustomOreGen.CustomPacketPayload;
import CustomOreGen.GeometryData;
import CustomOreGen.GeometryRequestData;
import CustomOreGen.MystcraftSymbolData;
import CustomOreGen.Server.ServerState;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.Serializable;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.NetClientHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetServerHandler;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.network.packet.Packet3Chat;
import net.minecraft.server.MinecraftServer;
import net.minecraft.src.BaseMod;
import net.minecraft.src.ModLoader;
import net.minecraft.world.World;

public class mod_CustomOreGen
extends BaseMod {
    public String getVersion() {
        return "1.0.6";
    }

    public String getPriorities() {
        return "after:*;";
    }

    public void load() {
        if (!CustomOreGenBase.hasFML()) {
            CustomOreGenBase.log = ModLoader.getLogger();
        }
        if (!CustomOreGenBase.hasFML()) {
            ModLoader.setInGameHook((BaseMod)this, (boolean)true, (boolean)false);
        }
        CustomPacketPayload.registerChannels(this);
    }

    public void modsLoaded() {
        CustomOreGenBase.onModPostLoad();
        boolean found = false;
        String failMods = null;
        for (BaseMod mod : ModLoader.getLoadedMods()) {
            if (mod == this) {
                found = true;
                continue;
            }
            if (!found || mod == null) continue;
            failMods = (failMods == null ? "" : failMods + ", ") + mod.getName();
        }
        if (failMods == null) {
            CustomOreGenBase.log.finer("Confirmed that CustomOreGen has precedence during world generation");
        } else {
            CustomOreGenBase.log.warning("The following mods force ModLoader to load them *after* CustomOreGen: " + failMods + ".  Distributions may not behave as expected if they (1) target custom biomes from or (2) replace ores placed by these mods.");
        }
    }

    public void generateSurface(World world, Random rand, int blockX, int blockZ) {
        if (!CustomOreGenBase.hasFML()) {
            ServerState.checkIfServerChanged(MinecraftServer.func_71276_C(), world.func_72912_H());
            ServerState.onPopulateChunk(world, rand, blockX / 16, blockZ / 16);
        }
    }

    public void generateNether(World world, Random rand, int blockX, int blockZ) {
        this.generateSurface(world, rand, blockX, blockZ);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onTickInGame(float partialTick, Minecraft minecraft) {
        if (CustomOreGenBase.hasFML()) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_71356_B()) {
            ServerState.checkIfServerChanged(MinecraftServer.func_71276_C(), null);
        }
        if (mc.field_71441_e != null && ClientState.hasWorldChanged((World)mc.field_71441_e)) {
            ClientState.onWorldChanged((World)mc.field_71441_e);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void clientCustomPayload(NetClientHandler handler, Packet250CustomPayload packet) {
        CustomPacketPayload payload;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && ClientState.hasWorldChanged((World)mc.field_71441_e)) {
            ClientState.onWorldChanged((World)mc.field_71441_e);
        }
        if ((payload = CustomPacketPayload.decodePacket(packet)) != null) {
            switch (payload.type) {
                case DebuggingGeometryData: {
                    ClientState.addDebuggingGeometry((GeometryData)payload.data);
                    break;
                }
                case DebuggingGeometryRenderMode: {
                    String strMode = (String)((Object)payload.data);
                    if ("_DISABLE_".equals(strMode)) {
                        ClientState.dgEnabled = false;
                        return;
                    }
                    if (!CustomOreGenBase.hasForge()) {
                        handler.func_72481_a(new Packet3Chat("{text: \"\u00a7cWarning: Minecraft Forge must be installed to view wireframes.\"}"));
                        return;
                    }
                    if (strMode != null) {
                        ClientState.WireframeRenderMode idx = null;
                        for (ClientState.WireframeRenderMode mode : ClientState.WireframeRenderMode.values()) {
                            if (!mode.name().equalsIgnoreCase(strMode)) continue;
                            idx = mode;
                            break;
                        }
                        if (idx != null) {
                            ClientState.dgRenderingMode = idx;
                        } else {
                            handler.func_72481_a(new Packet3Chat("{text: \"\u00a7cError: Invalid wireframe mode '" + strMode + "'\"}"));
                        }
                    } else {
                        int var11 = ClientState.dgRenderingMode == null ? 0 : ClientState.dgRenderingMode.ordinal();
                        var11 = (var11 + 1) % ClientState.WireframeRenderMode.values().length;
                        ClientState.dgRenderingMode = ClientState.WireframeRenderMode.values()[var11];
                    }
                    handler.func_72481_a(new Packet3Chat("{text: \"COG Client wireframe mode: " + ClientState.dgRenderingMode.name() + "\"}"));
                    break;
                }
                case DebuggingGeometryReset: {
                    ClientState.clearDebuggingGeometry();
                    break;
                }
                case MystcraftSymbolData: {
                    if (mc.func_71356_B()) break;
                    ClientState.addMystcraftSymbol((MystcraftSymbolData)payload.data);
                    break;
                }
                case CommandResponse: {
                    mc.field_71456_v.func_73827_b().func_73765_a((String)((Object)payload.data));
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled client packet type " + (Object)((Object)payload.type));
                }
            }
        }
    }

    public void serverCustomPayload(NetServerHandler handler, Packet250CustomPayload packet) {
        World handlerWorld = handler.field_72574_e == null ? null : handler.field_72574_e.field_70170_p;
        ServerState.checkIfServerChanged(MinecraftServer.func_71276_C(), handlerWorld == null ? null : handlerWorld.func_72912_H());
        CustomPacketPayload payload = CustomPacketPayload.decodePacket(packet);
        if (payload != null) {
            switch (payload.type) {
                case DebuggingGeometryRequest: {
                    GeometryData geometryData = null;
                    if (handler.getPlayer().field_71133_b.func_71203_ab().func_72353_e(handler.getPlayer().field_71092_bJ)) {
                        geometryData = ServerState.getDebuggingGeometryData((GeometryRequestData)payload.data);
                    }
                    if (geometryData == null) {
                        new CustomPacketPayload(CustomPacketPayload.PayloadType.DebuggingGeometryRenderMode, (Serializable)((Object)"_DISABLE_")).sendToClient(handler);
                        break;
                    }
                    new CustomPacketPayload(CustomPacketPayload.PayloadType.DebuggingGeometryData, geometryData).sendToClient(handler);
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled server packet type " + (Object)((Object)payload.type));
                }
            }
        }
    }

    public void onClientLogin(EntityPlayer player) {
        World handlerWorld = player == null ? null : player.field_70170_p;
        ServerState.checkIfServerChanged(MinecraftServer.func_71276_C(), handlerWorld == null ? null : handlerWorld.func_72912_H());
        if (player != null) {
            ServerState.onClientLogin((EntityPlayerMP)player);
        }
    }
}

