/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Server;

import CustomOreGen.Config.ConfigParser;
import CustomOreGen.Config.PropertyIO;
import CustomOreGen.CustomOreGenBase;
import CustomOreGen.ForgeInterface;
import CustomOreGen.MystcraftInterface;
import CustomOreGen.MystcraftSymbolData;
import CustomOreGen.Server.ChoiceOption;
import CustomOreGen.Server.ConfigOption;
import CustomOreGen.Server.IOreDistribution;
import CustomOreGen.Server.NumericOption;
import CustomOreGen.Util.BiomeDescriptor;
import CustomOreGen.Util.CIStringMap;
import CustomOreGen.Util.MapCollection;
import cpw.mods.fml.common.Loader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraft.world.gen.ChunkProviderFlat;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.ChunkProviderHell;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.xml.sax.SAXException;

public class WorldConfig {
    public static Collection<ConfigOption>[] loadedOptionOverrides = new Collection[3];
    public final World world;
    public final WorldInfo worldInfo;
    public final File globalConfigDir;
    public final File worldBaseDir;
    public final File dimensionDir;
    public int deferredPopulationRange = 0;
    public boolean debuggingMode = false;
    public boolean vanillaOreGen = false;
    private Collection<IOreDistribution> oreDistributions = new LinkedList<IOreDistribution>();
    private Map<String, ConfigOption> configOptions = new CIStringMap<ConfigOption>(new LinkedHashMap());
    private Map<String, String> loadedOptions = new CIStringMap<String>(new LinkedHashMap());
    private Map<String, Integer> worldProperties = new CIStringMap<Integer>(new LinkedHashMap());
    private Map cogSymbolData = new CIStringMap(new LinkedHashMap());
    private Collection<BiomeDescriptor> biomeSets = new LinkedList<BiomeDescriptor>();

    public static WorldConfig createEmptyConfig() {
        try {
            return new WorldConfig(null, null, null, null, null);
        }
        catch (Exception var1) {
            throw new RuntimeException(var1);
        }
    }

    public WorldConfig() throws IOException, ParserConfigurationException, SAXException {
        this(Loader.instance().getConfigDir(), null, null, null, null);
    }

    public WorldConfig(WorldInfo worldInfo, File worldBaseDir) throws IOException, ParserConfigurationException, SAXException {
        this(Loader.instance().getConfigDir(), worldInfo, worldBaseDir, null, null);
    }

    public WorldConfig(World world) throws IOException, ParserConfigurationException, SAXException {
        this(Loader.instance().getConfigDir(), null, null, world, null);
    }

    private WorldConfig(File globalConfigDir, WorldInfo worldInfo, File worldBaseDir, World world, File dimensionDir) throws IOException, ParserConfigurationException, SAXException {
        if (world != null) {
            worldBaseDir = world.func_72860_G() != null && world.func_72860_G() instanceof SaveHandler ? ((SaveHandler)world.func_72860_G()).func_75765_b() : null;
            String dimensionBasename = "DIM" + world.field_73011_w.field_76574_g;
            if (CustomOreGenBase.hasForge() && world.field_73011_w.field_76574_g != 0) {
                dimensionBasename = ForgeInterface.getWorldDimensionFolder(world);
            }
            dimensionDir = worldBaseDir == null ? new File(dimensionBasename) : new File(worldBaseDir, dimensionBasename);
            worldInfo = world.func_72912_H();
        }
        if (dimensionDir == null && worldBaseDir != null && !(dimensionDir = new File(worldBaseDir, "DIM0")).exists()) {
            dimensionDir.mkdir();
        }
        this.world = world;
        this.worldInfo = worldInfo;
        WorldConfig.populateWorldProperties(this.worldProperties, world, worldInfo);
        this.worldBaseDir = worldBaseDir;
        this.dimensionDir = dimensionDir;
        this.globalConfigDir = globalConfigDir;
        if (dimensionDir != null) {
            CustomOreGenBase.log.finer("Loading config data for dimension '" + dimensionDir + "' ...");
        } else {
            if (globalConfigDir == null) {
                return;
            }
            CustomOreGenBase.log.finer("Loading global config '" + globalConfigDir + "' ...");
        }
        Object configFile = null;
        File[] configFileList = new File[3];
        int configFileDepth = this.buildFileList("CustomOreGen_Config.xml", configFileList, true);
        if (configFileDepth < 0) {
            if (dimensionDir != null) {
                CustomOreGenBase.log.warning("No config file found for dimension '" + dimensionDir + "' at any scope!");
            } else {
                CustomOreGenBase.log.finer("No global config file found.");
            }
        } else {
            ConfigOption var21;
            File var16 = configFileList[configFileDepth];
            File[] optionsFileList = new File[3];
            this.buildFileList("CustomOreGen_Options.txt", optionsFileList, false);
            File optionsFile = optionsFileList[2];
            for (int defpopOption = configFileDepth; defpopOption < optionsFileList.length; ++defpopOption) {
                this.loadOptions(optionsFileList[defpopOption], loadedOptionOverrides[defpopOption], this.loadedOptions);
            }
            new ConfigParser(this).parseFile(var16);
            if (optionsFile != null && !optionsFile.exists()) {
                this.putOptions(this.configOptions.values(), this.loadedOptions);
                this.saveOptions(optionsFile, this.loadedOptions);
            }
            if (optionsFileList[1] != null && !optionsFileList[1].exists()) {
                LinkedHashMap<String, String> saveLevelOptions = new LinkedHashMap<String, String>();
                this.loadOptions(optionsFileList[0], loadedOptionOverrides[0], saveLevelOptions);
                this.saveOptions(optionsFileList[1], saveLevelOptions);
            }
            if ((var21 = this.configOptions.get("deferredPopulationRange")) != null && var21 instanceof NumericOption) {
                Double var18 = (Double)var21.getValue();
                this.deferredPopulationRange = var18 != null && var18 > 0.0 ? (int)Math.ceil(var18) : 0;
            } else {
                CustomOreGenBase.log.warning("Numeric Option '" + var21 + "' not found in config file - defaulting to '" + this.deferredPopulationRange + "'.");
            }
            ConfigOption var20 = this.configOptions.get("debugMode");
            if (var20 != null && var20 instanceof ChoiceOption) {
                String var22 = (String)var20.getValue();
                this.debuggingMode = var22 == null ? false : var22.equalsIgnoreCase("on") || var22.equalsIgnoreCase("true");
            } else {
                CustomOreGenBase.log.warning("Choice Option '" + var20 + "' not found in config file - defaulting to '" + this.debuggingMode + "'.");
            }
            ConfigOption vangen = this.configOptions.get("vanillaOreGen");
            if (vangen != null && vangen instanceof ChoiceOption) {
                String value = (String)vangen.getValue();
                this.vanillaOreGen = value == null ? false : value.equalsIgnoreCase("on") || value.equalsIgnoreCase("true");
            } else {
                CustomOreGenBase.log.warning("Choice Option '" + vangen + "' not found in config file - defaulting to '" + this.vanillaOreGen + "'.");
            }
        }
    }

    private void loadOptions(File file, Collection<ConfigOption> overrides, Map<String, String> map) throws FileNotFoundException, IOException {
        if (file != null && file.exists()) {
            PropertyIO.load(map, new FileInputStream(file));
        }
        if (overrides != null) {
            this.putOptions(overrides, map);
        }
    }

    private void putOptions(Collection<ConfigOption> options, Map<String, String> map) {
        for (ConfigOption option : options) {
            if (option.getValue() == null) continue;
            map.put(option.getName(), option.getValue().toString());
        }
    }

    private void saveOptions(File optionsFile, Map<String, String> options) throws IOException {
        optionsFile.createNewFile();
        String header = "Custom Ore Generation: First Revival 1.0.6 Config Options";
        PropertyIO.save(options, new FileOutputStream(optionsFile), header);
    }

    private int buildFileList(String fileName, File[] files, boolean mustExist) {
        if (files == null) {
            files = new File[3];
        }
        if (this.globalConfigDir != null) {
            files[0] = new File(this.globalConfigDir, fileName);
        }
        if (this.worldBaseDir != null) {
            files[1] = new File(this.worldBaseDir, fileName);
        }
        if (this.dimensionDir != null) {
            files[2] = new File(this.dimensionDir, fileName);
        }
        for (int i = files.length - 1; i >= 0; --i) {
            if (files[i] == null || mustExist && !files[i].exists()) continue;
            return i;
        }
        return -1;
    }

    private static void populateWorldProperties(Map properties, World world, WorldInfo worldInfo) {
        properties.put("world", worldInfo == null ? "" : worldInfo.func_76065_j());
        properties.put("world.seed", worldInfo == null ? 0L : worldInfo.func_76063_b());
        properties.put("world.version", worldInfo == null ? 0 : worldInfo.func_76088_k());
        properties.put("world.isHardcore", worldInfo == null ? false : worldInfo.func_76093_s());
        properties.put("world.hasFeatures", worldInfo == null ? false : worldInfo.func_76089_r());
        properties.put("world.hasCheats", worldInfo == null ? false : worldInfo.func_76086_u());
        properties.put("world.gameMode", worldInfo == null ? "" : worldInfo.func_76077_q().func_77149_b());
        properties.put("world.gameMode.id", worldInfo == null ? 0 : worldInfo.func_76077_q().func_77148_a());
        properties.put("world.type", worldInfo == null ? "" : worldInfo.func_76067_t().func_77127_a());
        properties.put("world.type.version", worldInfo == null ? 0 : worldInfo.func_76067_t().func_77131_c());
        String genName = "RandomLevelSource";
        String genClass = "ChunkProviderGenerate";
        if (world != null) {
            IChunkProvider chunkProvider = world.field_73011_w.func_76555_c();
            genName = chunkProvider.func_73148_d();
            genClass = chunkProvider.getClass().getSimpleName();
            if (chunkProvider instanceof ChunkProviderGenerate) {
                genClass = "ChunkProviderGenerate";
            } else if (chunkProvider instanceof ChunkProviderFlat) {
                genClass = "ChunkProviderFlat";
            } else if (chunkProvider instanceof ChunkProviderHell) {
                genClass = "ChunkProviderHell";
            } else if (chunkProvider instanceof ChunkProviderEnd) {
                genName = "EndRandomLevelSource";
                genClass = "ChunkProviderEnd";
            }
        }
        properties.put("dimension.generator", genName);
        properties.put("dimension.generator.class", genClass);
        properties.put("dimension", world == null ? "" : world.field_73011_w.func_80007_l());
        properties.put("dimension.id", world == null ? 0 : world.field_73011_w.field_76574_g);
        properties.put("dimension.isSurface", world == null ? false : world.field_73011_w.func_76569_d());
        properties.put("dimension.groundLevel", world == null ? 0 : world.field_73011_w.func_76557_i());
        properties.put("dimension.height", world == null ? 0 : world.func_72800_K());
        properties.put("age", Boolean.FALSE);
        if (CustomOreGenBase.hasMystcraft()) {
            MystcraftInterface.populateAgePropertyMap(world, properties);
        }
    }

    public Collection<IOreDistribution> getOreDistributions() {
        return this.oreDistributions;
    }

    public Collection<IOreDistribution> getOreDistributions(String namePattern) {
        LinkedList<IOreDistribution> matches = new LinkedList<IOreDistribution>();
        if (namePattern != null) {
            Pattern pattern = Pattern.compile(namePattern, 2);
            Matcher matcher = pattern.matcher("");
            for (IOreDistribution dist : this.oreDistributions) {
                matcher.reset(dist.toString());
                if (!matcher.matches()) continue;
                matches.add(dist);
            }
        }
        return Collections.unmodifiableCollection(matches);
    }

    public ConfigOption getConfigOption(String optionName) {
        return this.configOptions.get(optionName);
    }

    public Collection<ConfigOption> getConfigOptions() {
        return new MapCollection<String, ConfigOption>(this.configOptions){

            @Override
            protected String getKey(ConfigOption v) {
                return v.getName();
            }
        };
    }

    public Collection<ConfigOption> getConfigOptions(String namePattern) {
        LinkedList<ConfigOption> matches = new LinkedList<ConfigOption>();
        if (namePattern != null) {
            Pattern pattern = Pattern.compile(namePattern, 2);
            Matcher matcher = pattern.matcher("");
            for (ConfigOption option : this.configOptions.values()) {
                matcher.reset(option.getName());
                if (!matcher.matches()) continue;
                matches.add(option);
            }
        }
        return Collections.unmodifiableCollection(matches);
    }

    public String loadConfigOption(String optionName) {
        return this.loadedOptions.get(optionName);
    }

    public Object getWorldProperty(String propertyName) {
        return this.worldProperties.get(propertyName);
    }

    public MystcraftSymbolData getMystcraftSymbol(String symbolName) {
        return (MystcraftSymbolData)this.cogSymbolData.get(symbolName);
    }

    public Collection getMystcraftSymbols() {
        return new MapCollection<String, MystcraftSymbolData>(this.cogSymbolData){

            @Override
            protected String getKey(MystcraftSymbolData v) {
                return v.symbolName;
            }

            @Override
            public boolean add(MystcraftSymbolData v) {
                String key = "age." + v.symbolName;
                Integer count = (Integer)WorldConfig.this.worldProperties.get(key);
                if (count == null) {
                    WorldConfig.this.worldProperties.put("age." + v.symbolName, 0);
                } else {
                    v.count = count;
                }
                return super.add(v);
            }
        };
    }

    public Collection<BiomeDescriptor> getBiomeSets() {
        return this.biomeSets;
    }

    public Collection<BiomeDescriptor> getBiomeSets(String namePattern) {
        LinkedList<BiomeDescriptor> matches = new LinkedList<BiomeDescriptor>();
        if (namePattern != null) {
            Pattern pattern = Pattern.compile(namePattern, 2);
            Matcher matcher = pattern.matcher("");
            for (BiomeDescriptor desc : this.biomeSets) {
                matcher.reset(desc.getName());
                if (!matcher.matches()) continue;
                matches.add(desc);
            }
        }
        return Collections.unmodifiableCollection(matches);
    }
}

