/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Config;

import CustomOreGen.Config.ParserException;
import CustomOreGen.Config.ValidatorNode;
import CustomOreGen.Util.BiomeDescriptor;
import org.w3c.dom.Node;

public class ValidatorBiomeDescriptor
extends ValidatorNode {
    public String biome = null;
    public float weight = 1.0f;
    public BiomeDescriptor.Climate climate = new BiomeDescriptor.Climate();

    protected ValidatorBiomeDescriptor(ValidatorNode parent, Node node) {
        super(parent, node);
    }

    @Override
    protected boolean validateChildren() throws ParserException {
        super.validateChildren();
        this.biome = this.validateRequiredAttribute(String.class, "Name", true);
        this.weight = this.validateNamedAttribute(Float.class, "Weight", Float.valueOf(this.weight), true).floatValue();
        float minTemperature = this.validateNamedAttribute(Float.class, "MinTemperature", Float.valueOf(this.climate.minTemperature), true).floatValue();
        float maxTemperature = this.validateNamedAttribute(Float.class, "MaxTemperature", Float.valueOf(this.climate.maxTemperature), true).floatValue();
        float minRainfall = this.validateNamedAttribute(Float.class, "MinRainfall", Float.valueOf(this.climate.minRainfall), true).floatValue();
        float maxRainfall = this.validateNamedAttribute(Float.class, "MaxRainfall", Float.valueOf(this.climate.maxRainfall), true).floatValue();
        this.climate = new BiomeDescriptor.Climate(minTemperature, maxTemperature, minRainfall, maxRainfall);
        return true;
    }

    public static class Factory
    implements ValidatorNode.IValidatorFactory<ValidatorBiomeDescriptor> {
        @Override
        public ValidatorBiomeDescriptor createValidator(ValidatorNode parent, Node node) {
            return new ValidatorBiomeDescriptor(parent, node);
        }
    }
}

