/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen;

import CustomOreGen.Client.ClientState;
import CustomOreGen.CustomOreGenBase;
import CustomOreGen.Server.ServerState;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ForgeInterface {
    public static ForgeInterface createAndRegister() {
        CustomOreGenBase.log.finer("Registering Forge interface ...");
        ForgeInterface inst = new ForgeInterface();
        MinecraftForge.EVENT_BUS.register((Object)inst);
        MinecraftForge.ORE_GEN_BUS.register((Object)inst);
        return inst;
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        ClientState.onRenderWorld((Entity)Minecraft.func_71410_x().field_71451_h, event.partialTicks);
    }

    @ForgeSubscribe
    public void onLoadWorld(WorldEvent.Load event) {
        if (event.world instanceof WorldServer) {
            ServerState.checkIfServerChanged(MinecraftServer.func_71276_C(), event.world.func_72912_H());
            ServerState.getWorldConfig(event.world);
        } else if (event.world instanceof WorldClient && ClientState.hasWorldChanged(event.world)) {
            ClientState.onWorldChanged(event.world);
        }
    }

    @ForgeSubscribe
    public void onGenerateMinable(OreGenEvent.GenerateMinable event) {
        ServerState.checkIfServerChanged(MinecraftServer.func_71276_C(), event.world.func_72912_H());
        boolean vanillaOreGen = ServerState.getWorldConfig((World)event.world).vanillaOreGen;
        boolean isCustom = event.type == OreGenEvent.GenerateMinable.EventType.CUSTOM;
        event.setResult(vanillaOreGen || isCustom ? Event.Result.ALLOW : Event.Result.DENY);
    }

    public static String getWorldDimensionFolder(World world) {
        return world.field_73011_w.getSaveFolder();
    }
}

