/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen;

import CustomOreGen.CustomOreGenBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import net.minecraft.network.NetServerHandler;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.src.BaseMod;
import net.minecraft.src.ModLoader;

public class CustomPacketPayload {
    public final PayloadType type;
    public final Serializable data;
    private static Map _xpacketMap = new HashMap();
    private static AtomicInteger _xpacketNextID = new AtomicInteger(0);
    private static final String CHANNEL = "CustomOreGen";
    private static final String XCHANNEL = "CustomOreGenX";
    private static final int MAX_SIZE = 32000;

    public CustomPacketPayload(PayloadType type, Serializable data) {
        this.type = type;
        this.data = data;
    }

    public void sendToServer() {
        for (Packet250CustomPayload packet : this.createPackets()) {
            ModLoader.sendPacket((Packet)packet);
        }
    }

    public void sendToClient(NetServerHandler handler) {
        for (Packet250CustomPayload packet : this.createPackets()) {
            ModLoader.serverSendPacket((NetServerHandler)handler, (Packet)packet);
        }
    }

    public void sendToAllClients() {
        for (Packet250CustomPayload packet : this.createPackets()) {
            MinecraftServer.func_71276_C().func_71203_ab().func_72384_a((Packet)packet);
        }
    }

    private Packet250CustomPayload[] createPackets() {
        byte[] var11;
        Object payloadData = null;
        boolean compressed = false;
        try {
            AutoCompressionStream packetCount = new AutoCompressionStream(1024);
            ObjectOutputStream packets = new ObjectOutputStream(packetCount);
            packets.writeByte((byte)this.type.ordinal());
            packets.writeObject(this.data);
            packets.close();
            packetCount.close();
            var11 = packetCount.toByteArray();
            compressed = packetCount.isCompressed();
        }
        catch (IOException var10) {
            throw new RuntimeException(var10);
        }
        if (!compressed) {
            return new Packet250CustomPayload[]{new Packet250CustomPayload(CHANNEL, var11)};
        }
        int var12 = (var11.length + 32000 - 1) / 32000;
        Packet250CustomPayload[] var13 = new Packet250CustomPayload[var12];
        int id = _xpacketNextID.incrementAndGet();
        int offset = 0;
        for (int i = 1; i <= var12; ++i) {
            int dataLen = Math.min(32000, var11.length - offset);
            byte[] piece = new byte[8 + dataLen];
            piece[0] = (byte)id;
            piece[1] = (byte)(id >> 8);
            piece[2] = (byte)(id >> 16);
            piece[3] = (byte)(id >> 24);
            piece[4] = (byte)var12;
            piece[5] = (byte)(var12 >> 8);
            piece[6] = (byte)i;
            piece[7] = (byte)(i >> 8);
            System.arraycopy(var11, offset, piece, 8, dataLen);
            offset += dataLen;
            var13[i - 1] = new Packet250CustomPayload(XCHANNEL, piece);
        }
        return var13;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CustomPacketPayload decodePacket(Packet250CustomPayload packet) {
        try {
            InputStream ex = null;
            if (packet.field_73630_a.equals(XCHANNEL)) {
                int objStream = packet.field_73629_c[0] & 0xFF;
                objStream |= (packet.field_73629_c[1] & 0xFF) << 8;
                objStream |= (packet.field_73629_c[2] & 0xFF) << 16;
                objStream |= (packet.field_73629_c[3] & 0xFF) << 24;
                int type = packet.field_73629_c[4] & 0xFF;
                int data = packet.field_73629_c[6] & 0xFF;
                data |= (packet.field_73629_c[7] & 0xFF) << 8;
                if ((type |= (packet.field_73629_c[5] & 0xFF) << 8) > 1) {
                    Map var5 = _xpacketMap;
                    Map map = _xpacketMap;
                    synchronized (map) {
                        ByteArrayOutputStream partialData = (ByteArrayOutputStream)_xpacketMap.get(objStream);
                        if (partialData == null) {
                            partialData = new ByteArrayOutputStream(32000 * (type + 1));
                            _xpacketMap.put(objStream, partialData);
                        }
                        if (partialData.size() != (data - 1) * 32000) {
                            throw new RuntimeException("Packet # " + data + "/" + type + " in group " + objStream + " does not match next position in buffer " + (partialData.size() / 32000 + 1));
                        }
                        partialData.write(packet.field_73629_c, 8, packet.field_73629_c.length - 8);
                        if (data < type) {
                            return null;
                        }
                        _xpacketMap.remove(objStream);
                        partialData.close();
                        ex = new InflaterInputStream(new ByteArrayInputStream(partialData.toByteArray()));
                    }
                } else {
                    ex = new InflaterInputStream(new ByteArrayInputStream(packet.field_73629_c, 8, packet.field_73629_c.length - 8));
                }
            } else {
                if (!packet.field_73630_a.equals(CHANNEL)) {
                    CustomOreGenBase.log.warning("Invalid custom packet channel: '" + packet.field_73630_a + "'");
                    return null;
                }
                ex = new ByteArrayInputStream(packet.field_73629_c);
            }
            TranslatingObjectInputStream objStream1 = new TranslatingObjectInputStream(ex);
            PayloadType type1 = PayloadType.values()[objStream1.readByte()];
            Serializable data1 = (Serializable)objStream1.readObject();
            objStream1.close();
            return new CustomPacketPayload(type1, data1);
        }
        catch (Exception var9) {
            CustomOreGenBase.log.warning("Error while decoding custom packet payload: " + var9.getMessage());
            return null;
        }
    }

    public static void registerChannels(BaseMod mod) {
        ModLoader.registerPacketChannel((BaseMod)mod, (String)CHANNEL);
        ModLoader.registerPacketChannel((BaseMod)mod, (String)XCHANNEL);
    }

    private static class TranslatingObjectInputStream
    extends ObjectInputStream {
        public TranslatingObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                return super.resolveClass(desc);
            }
            catch (ClassNotFoundException var3) {
                return desc.getName().startsWith("net.minecraft.src.") ? CustomOreGenBase.class.getClassLoader().loadClass(desc.getName().substring(18)) : CustomOreGenBase.class.getClassLoader().loadClass("net.minecraft.src." + desc.getName());
            }
        }
    }

    public static enum PayloadType {
        DebuggingGeometryRequest,
        DebuggingGeometryReset,
        DebuggingGeometryData,
        DebuggingGeometryRenderMode,
        MystcraftSymbolData,
        CommandResponse;

    }

    private class AutoCompressionStream
    extends OutputStream {
        private int compressionThreshold;
        private ByteArrayOutputStream backingStream;
        private DeflaterOutputStream compressionStream;

        public AutoCompressionStream(int threshold) {
            this.compressionThreshold = threshold;
            this.backingStream = new ByteArrayOutputStream();
            this.compressionStream = null;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.compressionStream != null) {
                this.compressionStream.write(b);
            } else if (this.backingStream.size() < this.compressionThreshold) {
                this.backingStream.write(b);
            } else {
                byte[] data = this.backingStream.toByteArray();
                this.backingStream.reset();
                this.compressionStream = new DeflaterOutputStream((OutputStream)this.backingStream, new Deflater(9));
                this.compressionStream.write(data);
                this.compressionStream.write(b);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.compressionStream != null) {
                this.compressionStream.close();
            }
            this.backingStream.close();
        }

        @Override
        public void flush() throws IOException {
            if (this.compressionStream != null) {
                this.compressionStream.flush();
            }
            this.backingStream.flush();
        }

        public boolean isCompressed() {
            return this.compressionStream != null;
        }

        public byte[] toByteArray() throws IOException {
            this.flush();
            return this.backingStream.toByteArray();
        }
    }
}

