/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Config;

import CustomOreGen.Config.ParserException;
import CustomOreGen.Config.ValidatorNode;
import CustomOreGen.Config.ValidatorUnchecked;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ValidatorCondition
extends ValidatorNode {
    protected boolean invert = false;

    protected ValidatorCondition(ValidatorNode parent, Node node, boolean invert) {
        super(parent, node);
        this.invert = invert;
    }

    @Override
    protected boolean validateChildren() throws ParserException {
        Node resultBlock;
        Node trueBlock = null;
        Element falseBlock = null;
        for (Node condition = this.getNode().getFirstChild(); condition != null; condition = condition.getNextSibling()) {
            if (condition.getNodeType() != 1) continue;
            if (condition.getNodeName().equalsIgnoreCase("Then")) {
                trueBlock = (Element)condition;
                continue;
            }
            if (!condition.getNodeName().equalsIgnoreCase("Else")) continue;
            falseBlock = (Element)condition;
        }
        if (trueBlock == null) {
            if (falseBlock != null) {
                throw new ParserException("Cannot have Else without Then", falseBlock);
            }
            trueBlock = this.getNode().getOwnerDocument().createElement("Then");
            while (this.getNode().hasChildNodes()) {
                trueBlock.appendChild(this.getNode().getFirstChild());
            }
            this.getNode().appendChild(trueBlock);
        }
        trueBlock.setUserData("validated", true, null);
        if (falseBlock != null) {
            falseBlock.setUserData("validated", true, null);
        }
        super.validateChildren();
        boolean condition1 = this.evaluateCondition();
        if (this.invert) {
            condition1 = !condition1;
        }
        this.getNode().setUserData("validated", true, null);
        this.checkChildrenValid();
        Node node = resultBlock = condition1 ? trueBlock : falseBlock;
        if (resultBlock != null) {
            new ValidatorUnchecked(this, resultBlock).validate();
        }
        this.replaceWithNodeContents(resultBlock);
        return false;
    }

    protected abstract boolean evaluateCondition() throws ParserException;
}

