/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Config;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Date;
import java.util.Map;

public class PropertyIO {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void save(Map properties, OutputStream out, String headerComments) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        boolean escUnicode = true;
        if (headerComments != null) {
            PropertyIO.writeComments(bw, headerComments);
        }
        bw.write("#" + new Date().toString());
        bw.newLine();
        for (Map.Entry property : properties.entrySet()) {
            String key = PropertyIO.saveConvert((String)property.getKey(), true, escUnicode);
            String val = PropertyIO.saveConvert((String)property.getValue(), false, escUnicode);
            bw.write(key + "=" + val);
            bw.newLine();
        }
        bw.flush();
    }

    private static void writeComments(BufferedWriter bw, String comments) throws IOException {
        int current;
        bw.write("#");
        int len = comments.length();
        int last = 0;
        char[] uu = new char[]{'\\', 'u', '\u0000', '\u0000', '\u0000', '\u0000'};
        for (current = 0; current < len; ++current) {
            char c = comments.charAt(current);
            if (c <= '\u00ff' && c != '\n' && c != '\r') continue;
            if (last != current) {
                bw.write(comments.substring(last, current));
            }
            if (c > '\u00ff') {
                uu[2] = hexDigit[c >> 12 & 0xF];
                uu[3] = hexDigit[c >> 8 & 0xF];
                uu[4] = hexDigit[c >> 4 & 0xF];
                uu[5] = hexDigit[c & 0xF];
                bw.write(new String(uu));
            } else {
                bw.newLine();
                if (c == '\r' && current != len - 1 && comments.charAt(current + 1) == '\n') {
                    ++current;
                }
                if (current == len - 1 || comments.charAt(current + 1) != '#' && comments.charAt(current + 1) != '!') {
                    bw.write("#");
                }
            }
            last = current + 1;
        }
        if (last != current) {
            bw.write(comments.substring(last, current));
        }
        bw.newLine();
    }

    private static String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(hexDigit[aChar >> 12 & 0xF]);
                        outBuffer.append(hexDigit[aChar >> 8 & 0xF]);
                        outBuffer.append(hexDigit[aChar >> 4 & 0xF]);
                        outBuffer.append(hexDigit[aChar & 0xF]);
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public static void load(Map properties, InputStream inStream) throws IOException {
        int limit;
        LineReader lr = new LineReader(inStream);
        char[] convtBuf = new char[1024];
        while ((limit = lr.readLine()) >= 0) {
            char var12;
            int keyLen;
            boolean c = false;
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            for (keyLen = 0; keyLen < limit; ++keyLen) {
                var12 = lr.lineBuf[keyLen];
                if (!(var12 != '=' && var12 != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (var12 != ' ' && var12 != '\t' && var12 != '\f' || precedingBackslash) {
                    precedingBackslash = var12 == '\\' ? !precedingBackslash : false;
                    continue;
                }
                valueStart = keyLen + 1;
                break;
            }
            while (valueStart < limit) {
                var12 = lr.lineBuf[valueStart];
                if (var12 != ' ' && var12 != '\t' && var12 != '\f') {
                    if (hasSep || var12 != '=' && var12 != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            String key = PropertyIO.loadConvert(lr.lineBuf, 0, keyLen, convtBuf);
            String value = PropertyIO.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
            properties.put(key, value);
        }
    }

    private static String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int aChar = len * 2;
            if (aChar < 0) {
                aChar = Integer.MAX_VALUE;
            }
            convtBuf = new char[aChar];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int var10;
            if ((var10 = in[off++]) == 92) {
                if ((var10 = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        var10 = in[off++];
                        switch (var10) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + var10 - 48;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + var10 - 65;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + var10 - 97;
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (var10 == 116) {
                    var10 = 9;
                } else if (var10 == 114) {
                    var10 = 13;
                } else if (var10 == 110) {
                    var10 = 10;
                } else if (var10 == 102) {
                    var10 = 12;
                }
                out[outLen++] = var10;
                continue;
            }
            out[outLen++] = var10;
        }
        return new String(out, 0, outLen);
    }

    private static class LineReader {
        byte[] inByteBuf;
        char[] inCharBuf;
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        InputStream inStream;
        Reader reader;

        public LineReader(InputStream inStream) {
            this.inStream = inStream;
            this.inByteBuf = new byte[8192];
        }

        int readLine() throws IOException {
            int len = 0;
            boolean c = false;
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len != 0 && !isCommentLine) {
                            return len;
                        }
                        return -1;
                    }
                }
                char var11 = this.inStream != null ? (char)(0xFF & this.inByteBuf[this.inOff++]) : this.inCharBuf[this.inOff++];
                if (skipLF) {
                    skipLF = false;
                    if (var11 == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (var11 == ' ' || var11 == '\t' || var11 == '\f' || !appendedLineBegin && (var11 == '\r' || var11 == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (var11 == '#' || var11 == '!') {
                        isCommentLine = true;
                        continue;
                    }
                }
                if (var11 != '\n' && var11 != '\r') {
                    this.lineBuf[len++] = var11;
                    if (len == this.lineBuf.length) {
                        int newLength = this.lineBuf.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                        this.lineBuf = buf;
                    }
                    if (var11 == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (!isCommentLine && len != 0) {
                    if (this.inOff >= this.inLimit) {
                        this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                        this.inOff = 0;
                        if (this.inLimit <= 0) {
                            return len;
                        }
                    }
                    if (!precedingBackslash) {
                        return len;
                    }
                    --len;
                    skipWhiteSpace = true;
                    appendedLineBegin = true;
                    precedingBackslash = false;
                    if (var11 != '\r') continue;
                    skipLF = true;
                    continue;
                }
                isCommentLine = false;
                isNewLine = true;
                skipWhiteSpace = true;
                len = 0;
            }
        }
    }
}

