/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaks;
import invtweaks.InvTweaksConfig;
import invtweaks.InvTweaksConst;
import invtweaks.InvTweaksHandlerAutoRefill;
import invtweaks.InvTweaksHandlerShortcuts;
import invtweaks.InvTweaksItemTreeLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class InvTweaksConfigManager {
    private static final Logger log = InvTweaks.log;
    private Minecraft mc;
    private InvTweaksConfig config = null;
    private long storedConfigLastModified = 0L;
    private InvTweaksHandlerAutoRefill autoRefillHandler = null;
    private InvTweaksHandlerShortcuts shortcutsHandler = null;

    public InvTweaksConfigManager(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public boolean makeSureConfigurationIsLoaded() {
        try {
            if (this.config != null && this.config.refreshProperties()) {
                this.shortcutsHandler = new InvTweaksHandlerShortcuts(this.mc, this.config);
                InvTweaks.logInGameStatic("invtweaks.propsfile.loaded");
            }
        }
        catch (IOException iOException) {
            InvTweaks.logInGameErrorStatic("invtweaks.loadconfig.refresh.error", iOException);
        }
        long l = this.computeConfigLastModified();
        if (this.config != null) {
            if (this.storedConfigLastModified != l) {
                return this.loadConfig();
            }
            return true;
        }
        this.storedConfigLastModified = l;
        return this.loadConfig();
    }

    public InvTweaksConfig getConfig() {
        return this.config;
    }

    public InvTweaksHandlerAutoRefill getAutoRefillHandler() {
        return this.autoRefillHandler;
    }

    public InvTweaksHandlerShortcuts getShortcutsHandler() {
        return this.shortcutsHandler;
    }

    private long computeConfigLastModified() {
        return InvTweaksConst.CONFIG_RULES_FILE.lastModified() + InvTweaksConst.CONFIG_TREE_FILE.lastModified();
    }

    private boolean loadConfig() {
        File file = InvTweaksConst.MINECRAFT_CONFIG_DIR;
        if (!file.exists()) {
            file.mkdir();
        }
        try {
            if (!InvTweaksItemTreeLoader.isValidVersion(InvTweaksConst.CONFIG_TREE_FILE)) {
                this.backupFile(InvTweaksConst.CONFIG_TREE_FILE);
            }
        }
        catch (Exception exception) {
            log.warning("Failed to check item tree version: " + exception.getMessage());
        }
        if (InvTweaksConst.OLD_CONFIG_TREE_FILE.exists()) {
            if (InvTweaksConst.CONFIG_RULES_FILE.exists()) {
                this.backupFile(InvTweaksConst.CONFIG_TREE_FILE);
            }
            InvTweaksConst.OLD_CONFIG_TREE_FILE.renameTo(InvTweaksConst.CONFIG_TREE_FILE);
        } else if (InvTweaksConst.OLDER_CONFIG_RULES_FILE.exists()) {
            if (InvTweaksConst.CONFIG_RULES_FILE.exists()) {
                this.backupFile(InvTweaksConst.CONFIG_RULES_FILE);
            }
            InvTweaksConst.OLDER_CONFIG_RULES_FILE.renameTo(InvTweaksConst.CONFIG_RULES_FILE);
        }
        if (!InvTweaksConst.CONFIG_RULES_FILE.exists() && this.extractFile(InvTweaksConst.DEFAULT_CONFIG_FILE, InvTweaksConst.CONFIG_RULES_FILE)) {
            InvTweaks.logInGameStatic(InvTweaksConst.CONFIG_RULES_FILE + " " + StatCollector.func_74838_a((String)"invtweaks.loadconfig.invalidkeywords"));
        }
        if (!InvTweaksConst.CONFIG_TREE_FILE.exists() && this.extractFile(InvTweaksConst.DEFAULT_CONFIG_TREE_FILE, InvTweaksConst.CONFIG_TREE_FILE)) {
            InvTweaks.logInGameStatic(InvTweaksConst.CONFIG_TREE_FILE + " " + StatCollector.func_74838_a((String)"invtweaks.loadconfig.invalidkeywords"));
        }
        this.storedConfigLastModified = this.computeConfigLastModified();
        String string = null;
        Exception exception = null;
        try {
            if (this.config == null) {
                this.config = new InvTweaksConfig(InvTweaksConst.CONFIG_RULES_FILE, InvTweaksConst.CONFIG_TREE_FILE);
                this.autoRefillHandler = new InvTweaksHandlerAutoRefill(this.mc, this.config);
                this.shortcutsHandler = new InvTweaksHandlerShortcuts(this.mc, this.config);
            }
            this.config.load();
            this.shortcutsHandler.loadShortcuts();
            log.setLevel(this.config.getLogLevel());
            InvTweaks.logInGameStatic("invtweaks.loadconfig.done");
            this.showConfigErrors(this.config);
        }
        catch (FileNotFoundException fileNotFoundException) {
            string = "Config file not found";
        }
        catch (Exception exception2) {
            string = "Error while loading config";
            exception = exception2;
        }
        if (string != null) {
            InvTweaks.logInGameErrorStatic(string, exception);
            log.severe(string);
            this.config = null;
            return false;
        }
        return true;
    }

    private void backupFile(File file) {
        File file2 = new File(file.getName() + ".bak");
        if (file2.exists()) {
            file2.delete();
        }
        file.renameTo(file2);
    }

    private void backupFile(File file, String string) {
        File file2 = new File(string + ".bak");
        if (file2.exists()) {
            file2.delete();
        }
        file.renameTo(file2);
    }

    private boolean extractFile(ResourceLocation resourceLocation, File file) {
        try {
            InputStream inputStream = this.mc.func_110442_L().func_110536_a(resourceLocation).func_110527_b();
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            inputStream.close();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
                return true;
            }
            catch (IOException iOException) {
                InvTweaks.logInGameStatic("[16] The mod won't work, because " + file + " creation failed!");
                log.severe("Cannot create " + file + " file: " + iOException.getMessage());
                return false;
            }
        }
        catch (IOException iOException) {
            InvTweaks.logInGameStatic("[15] The mod won't work, because " + resourceLocation + " extraction failed!");
            log.severe("Cannot extract " + resourceLocation + " file: " + iOException.getMessage());
            return false;
        }
    }

    private void showConfigErrors(InvTweaksConfig invTweaksConfig) {
        Vector<String> vector = invTweaksConfig.getInvalidKeywords();
        if (vector.size() > 0) {
            String string = StatCollector.func_74838_a((String)"invtweaks.loadconfig.invalidkeywords") + ": ";
            for (String string2 : invTweaksConfig.getInvalidKeywords()) {
                string = string + string2 + " ";
            }
            InvTweaks.logInGameStatic(string);
        }
    }
}

