/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.gui;

import forestry.api.genetics.ISpeciesRoot;
import forestry.core.gui.ContainerItemInventory;
import forestry.core.gui.IGuiSelectable;
import forestry.core.gui.SlotCustom;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import forestry.storage.GuiHandlerStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ContainerNaturalistBackpack
extends ContainerItemInventory
implements IGuiSelectable {
    private final GuiHandlerStorage.PagedInventory inv;
    private ISpeciesRoot speciesRoot;

    public ContainerNaturalistBackpack(ISpeciesRoot speciesRoot, InventoryPlayer player, GuiHandlerStorage.PagedInventory inventory, int page, int pageSize) {
        super(inventory, player.field_70458_d);
        this.inv = inventory;
        this.speciesRoot = speciesRoot;
        for (int x = 0; x < 5; ++x) {
            for (int y = 0; y < 5; ++y) {
                this.addSlot(new SlotCustom((IInventory)inventory, y + page * pageSize + x * 5, 100 + y * 18, 21 + x * 18, speciesRoot));
            }
        }
        for (int i1 = 0; i1 < 3; ++i1) {
            for (int l1 = 0; l1 < 9; ++l1) {
                this.addSecuredSlot((IInventory)player, l1 + i1 * 9 + 9, 18 + l1 * 18, 120 + i1 * 18);
            }
        }
        for (int j1 = 0; j1 < 9; ++j1) {
            this.addSecuredSlot((IInventory)player, j1, 18 + j1 * 18, 178);
        }
    }

    @Override
    public void purgeBag(EntityPlayer player) {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack == null || this.speciesRoot.isMember(stack)) continue;
            Proxies.common.dropItemPlayer(player, stack);
            this.inventory.func_70299_a(i, null);
        }
    }

    @Override
    protected boolean isAcceptedItem(EntityPlayer player, ItemStack stack) {
        return false;
    }

    @Override
    public void handleSelectionChange(EntityPlayer player, PacketUpdate packet) {
        this.inv.flipPage(player, packet.payload.intPayload[0]);
    }

    @Override
    public void setSelection(PacketUpdate packet) {
    }
}

