/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.core.PluginInfo;
import forestry.api.recipes.RecipeManagers;
import forestry.core.GameMode;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.BlockBase;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.gadgets.MachineNBTDefinition;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.items.ItemForestryBlock;
import forestry.core.items.ItemNBTTile;
import forestry.core.proxy.Proxies;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.RecipeUtil;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.factory.GuiHandlerFactory;
import forestry.factory.gadgets.MachineBottler;
import forestry.factory.gadgets.MachineCarpenter;
import forestry.factory.gadgets.MachineCentrifuge;
import forestry.factory.gadgets.MachineFabricator;
import forestry.factory.gadgets.MachineFermenter;
import forestry.factory.gadgets.MachineMoistener;
import forestry.factory.gadgets.MachineRaintank;
import forestry.factory.gadgets.MachineSqueezer;
import forestry.factory.gadgets.MachineStill;
import forestry.factory.gadgets.MillRainmaker;
import forestry.factory.gadgets.TileWorktable;
import forestry.factory.recipes.CraftGuideIntegration;
import forestry.plugins.NativePlugin;
import forestry.plugins.PluginIC2;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@PluginInfo(pluginID="Factory", name="Factory", author="SirSengir", url="http://forestry.sengir.net/", description="Adds a wide variety of machines to craft, produce and process products.")
public class PluginFactory
extends NativePlugin {
    public static MachineDefinition definitionBottler;
    public static MachineDefinition definitionCarpenter;
    public static MachineDefinition definitionCentrifuge;
    public static MachineDefinition definitionFermenter;
    public static MachineDefinition definitionMoistener;
    public static MachineDefinition definitionSqueezer;
    public static MachineDefinition definitionStill;
    public static MachineDefinition definitionRainmaker;
    public static MachineDefinition definitionFabricator;
    public static MachineDefinition definitionRaintank;
    public static MachineDefinition definitionWorktable;

    @Override
    public boolean isAvailable() {
        return !Config.disableFactory;
    }

    @Override
    public void preInit() {
        super.preInit();
        RecipeManagers.craftingProviders = new ArrayList();
        RecipeManagers.bottlerManager = new MachineBottler.RecipeManager();
        RecipeManagers.craftingProviders.add(RecipeManagers.bottlerManager);
        RecipeManagers.carpenterManager = new MachineCarpenter.RecipeManager();
        RecipeManagers.craftingProviders.add(RecipeManagers.carpenterManager);
        RecipeManagers.centrifugeManager = new MachineCentrifuge.RecipeManager();
        RecipeManagers.craftingProviders.add(RecipeManagers.centrifugeManager);
        RecipeManagers.fabricatorManager = new MachineFabricator.RecipeManager();
        RecipeManagers.craftingProviders.add(RecipeManagers.fabricatorManager);
        RecipeManagers.fermenterManager = new MachineFermenter.RecipeManager();
        RecipeManagers.craftingProviders.add(RecipeManagers.fermenterManager);
        RecipeManagers.moistenerManager = new MachineMoistener.RecipeManager();
        RecipeManagers.craftingProviders.add(RecipeManagers.moistenerManager);
        RecipeManagers.squeezerManager = new MachineSqueezer.RecipeManager();
        RecipeManagers.craftingProviders.add(RecipeManagers.squeezerManager);
        RecipeManagers.stillManager = new MachineStill.RecipeManager();
        RecipeManagers.craftingProviders.add(RecipeManagers.stillManager);
        int blockIDTESR = Config.getOrCreateBlockIdProperty("machine", 1405);
        definitionBottler = new MachineDefinition(blockIDTESR, 0, "forestry.Bottler", MachineBottler.class, Proxies.render.getRenderDefaultMachine("textures/blocks/bottler_"), ShapedRecipeCustom.createShapedRecipe(new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), ForestryItem.canEmpty, Character.valueOf('Y'), ForestryItem.sturdyCasing}, new ItemStack(blockIDTESR, 1, 0)));
        definitionCarpenter = new MachineDefinition(blockIDTESR, 1, "forestry.Carpenter", MachineCarpenter.class, Proxies.render.getRenderDefaultMachine("textures/blocks/carpenter_"), ShapedRecipeCustom.createShapedRecipe(new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), "ingotBronze", Character.valueOf('Y'), ForestryItem.sturdyCasing}, new ItemStack(blockIDTESR, 1, 1)));
        definitionCentrifuge = new MachineDefinition(blockIDTESR, 2, "forestry.Centrifuge", MachineCentrifuge.class, Proxies.render.getRenderDefaultMachine("textures/blocks/centrifuge_"), ShapedRecipeCustom.createShapedRecipe(new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), "ingotCopper", Character.valueOf('Y'), new ItemStack(ForestryItem.sturdyCasing)}, new ItemStack(blockIDTESR, 1, 2)));
        definitionFermenter = new MachineDefinition(blockIDTESR, 3, "forestry.Fermenter", MachineFermenter.class, Proxies.render.getRenderDefaultMachine("textures/blocks/fermenter_"), ShapedRecipeCustom.createShapedRecipe(new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), "gearBronze", Character.valueOf('Y'), ForestryItem.sturdyCasing}, new ItemStack(blockIDTESR, 1, 3)));
        definitionMoistener = new MachineDefinition(blockIDTESR, 4, "forestry.Moistener", MachineMoistener.class, Proxies.render.getRenderDefaultMachine("textures/blocks/moistener_"), ShapedRecipeCustom.createShapedRecipe(new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), "gearCopper", Character.valueOf('Y'), ForestryItem.sturdyCasing}, new ItemStack(blockIDTESR, 1, 4)));
        definitionRainmaker = new MachineDefinition(blockIDTESR, 7, "forestry.Rainmaker", MillRainmaker.class, Proxies.render.getRenderMill("textures/blocks/rainmaker_"), ShapedRecipeCustom.createShapedRecipe(new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), "gearTin", Character.valueOf('Y'), ForestryItem.hardenedCasing}, new ItemStack(blockIDTESR, 1, 7)));
        definitionSqueezer = new MachineDefinition(blockIDTESR, 5, "forestry.Squeezer", MachineSqueezer.class, Proxies.render.getRenderDefaultMachine("textures/blocks/squeezer_"), ShapedRecipeCustom.createShapedRecipe(new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), "ingotTin", Character.valueOf('Y'), new ItemStack(ForestryItem.sturdyCasing)}, new ItemStack(blockIDTESR, 1, 5)));
        definitionStill = new MachineDefinition(blockIDTESR, 6, "forestry.Still", MachineStill.class, Proxies.render.getRenderDefaultMachine("textures/blocks/still_"), ShapedRecipeCustom.createShapedRecipe(new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), Item.field_77767_aC, Character.valueOf('Y'), ForestryItem.sturdyCasing}, new ItemStack(blockIDTESR, 1, 6)));
        ForestryBlock.factoryTESR = new BlockBase(blockIDTESR, Material.field_76243_f, new MachineDefinition[]{definitionBottler, definitionCarpenter, definitionCentrifuge, definitionFermenter, definitionMoistener, definitionSqueezer, definitionStill, definitionRainmaker}, true).func_71864_b("for.factory");
        Item.field_77698_e[ForestryBlock.factoryTESR.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.factoryTESR.field_71990_ca] = new ItemForestryBlock(ForestryBlock.factoryTESR.field_71990_ca - 256, "for.factory");
        int blockIDPlain = Config.getOrCreateBlockIdProperty("mill", 1406);
        definitionFabricator = new MachineDefinition(blockIDPlain, 0, "forestry.Fabricator", MachineFabricator.class, ShapedRecipeCustom.createShapedRecipe(new Object[]{"X#X", "#Y#", "XZX", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), Item.field_77717_p, Character.valueOf('Y'), ForestryItem.sturdyCasing, Character.valueOf('Z'), Block.field_72077_au}, new ItemStack(blockIDPlain, 1, 0))).setFaces(0, 1, 2, 3, 4, 4);
        definitionRaintank = new MachineDefinition(blockIDPlain, 1, "forestry.Raintank", MachineRaintank.class, ShapedRecipeCustom.createShapedRecipe(new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), Item.field_77703_o, Character.valueOf('Y'), ForestryItem.sturdyCasing}, new ItemStack(blockIDPlain, 1, 1))).setFaces(0, 1, 0, 0, 0, 0);
        definitionWorktable = new MachineNBTDefinition(blockIDPlain, 2, "forestry.Worktable", TileWorktable.class, ShapedRecipeCustom.createShapedRecipe(new Object[]{"B", "W", "C", Character.valueOf('B'), Item.field_77760_aL, Character.valueOf('W'), Block.field_72060_ay, Character.valueOf('C'), Block.field_72077_au}, new ItemStack(blockIDPlain, 1, 2))).setFaces(0, 1, 2, 3, 4, 4);
        ForestryBlock.factoryPlain = new BlockBase(blockIDPlain, Material.field_76243_f, new MachineDefinition[]{definitionFabricator, definitionRaintank, definitionWorktable}).func_71864_b("for.factory2");
        Item.field_77698_e[ForestryBlock.factoryPlain.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.factoryPlain.field_71990_ca] = new ItemNBTTile(ForestryBlock.factoryPlain.field_71990_ca - 256, "for.factory2");
    }

    @Override
    public void doInit() {
        super.doInit();
        definitionBottler.register();
        definitionCarpenter.register();
        definitionCentrifuge.register();
        definitionFabricator.register();
        definitionFermenter.register();
        definitionMoistener.register();
        definitionRaintank.register();
        definitionSqueezer.register();
        definitionStill.register();
        definitionRainmaker.register();
        definitionWorktable.register();
    }

    @Override
    public void postInit() {
        super.postInit();
        if (Proxies.common.isModLoaded("craftguide")) {
            CraftGuideIntegration.register();
        } else {
            Proxies.log.info("Skipping CraftGuide integration.");
        }
    }

    @Override
    protected void registerItems() {
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerRecipes() {
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), new ItemStack(ForestryItem.tubes, 4, 0), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), "ingotCopper"});
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), new ItemStack(ForestryItem.tubes, 4, 1), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), "ingotTin"});
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), new ItemStack(ForestryItem.tubes, 4, 2), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), "ingotBronze"});
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), new ItemStack(ForestryItem.tubes, 4, 3), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), Item.field_77703_o});
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), new ItemStack(ForestryItem.tubes, 4, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), Item.field_77717_p});
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), new ItemStack(ForestryItem.tubes, 4, 5), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), Item.field_77702_n});
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), new ItemStack(ForestryItem.tubes, 4, 6), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), Block.field_72089_ap});
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), new ItemStack(ForestryItem.tubes, 4, 7), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), Item.field_77722_bw});
        if (PluginIC2.rubber != null) {
            RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), new ItemStack(ForestryItem.tubes, 4, 8), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), PluginIC2.rubber});
        }
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), new ItemStack(ForestryItem.tubes, 4, 9), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), Item.field_77817_bH});
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), new ItemStack(ForestryItem.tubes, 4, 10), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), ForestryItem.apatite});
        RecipeManagers.fabricatorManager.addRecipe(null, LiquidHelper.getLiquid("glass", 500), new ItemStack(ForestryItem.tubes, 4, 11), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), new ItemStack(Item.field_77756_aW, 1, 4)});
        String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        if (ForestryItem.propolis != null) {
            for (int i = 0; i < 16; ++i) {
                RecipeManagers.fabricatorManager.addRecipe(new ItemStack(ForestryItem.waxCast, 1, Short.MAX_VALUE), LiquidHelper.getLiquid("glass", 1000), new ItemStack(ForestryBlock.glass, 1, 15 - i), new Object[]{"#", "X", Character.valueOf('#'), dyes[i], Character.valueOf('X'), new ItemStack(ForestryItem.propolis, 1, Short.MAX_VALUE)});
            }
        }
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Item.field_77706_j)}, LiquidHelper.getLiquid("juice", GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple")), new ItemStack(ForestryItem.mulch), GameMode.getGameMode().getIntegerSetting("squeezer.mulch.apple"));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Item.field_77690_S)}, LiquidHelper.getLiquid("seedoil", GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed")));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Item.field_77739_bg)}, LiquidHelper.getLiquid("seedoil", GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed")));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Item.field_77740_bh)}, LiquidHelper.getLiquid("seedoil", GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed")));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(ForestryItem.phosphor, 2), new ItemStack(Block.field_71978_w)}, LiquidHelper.getLiquid("lava", 1600));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Block.field_72038_aV)}, LiquidHelper.getLiquid("water", 500));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(Item.field_77768_aD), new ItemStack(ForestryItem.craftingMaterial, 4, 5)}, LiquidHelper.getLiquid("ice", 4000));
        RecipeManagers.stillManager.addRecipe(100, LiquidHelper.getLiquid("biomass", 10), LiquidHelper.getLiquid("bioethanol", 3));
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Item.field_77690_S), new ItemStack((Block)Block.field_71994_by), 5000);
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Block.field_71978_w), new ItemStack(Block.field_72087_ao), 20000);
        RecipeManagers.moistenerManager.addRecipe(new ItemStack(Block.field_72007_bm), new ItemStack(Block.field_72007_bm, 1, 1), 20000);
        RecipeUtil.injectLeveledRecipe(new ItemStack(Block.field_71987_y, 1, 0), GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling"), "biomass");
        RecipeUtil.injectLeveledRecipe(new ItemStack(Block.field_71987_y, 1, 1), GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling"), "biomass");
        RecipeUtil.injectLeveledRecipe(new ItemStack(Block.field_71987_y, 1, 2), GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling"), "biomass");
        RecipeUtil.injectLeveledRecipe(new ItemStack(Block.field_71987_y, 1, 3), GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling"), "biomass");
        RecipeUtil.injectLeveledRecipe(new ItemStack(Block.field_72038_aV), GameMode.getGameMode().getIntegerSetting("fermenter.yield.cactus"), "biomass");
        RecipeUtil.injectLeveledRecipe(new ItemStack(Item.field_77685_T), GameMode.getGameMode().getIntegerSetting("fermenter.yield.wheat"), "biomass");
        RecipeUtil.injectLeveledRecipe(new ItemStack(Item.field_77758_aJ), GameMode.getGameMode().getIntegerSetting("fermenter.yield.cane"), "biomass");
        RecipeUtil.injectLeveledRecipe(new ItemStack((Block)Block.field_72109_af), GameMode.getGameMode().getIntegerSetting("fermenter.yield.mushroom"), "biomass");
        RecipeUtil.injectLeveledRecipe(new ItemStack((Block)Block.field_72103_ag), GameMode.getGameMode().getIntegerSetting("fermenter.yield.mushroom"), "biomass");
        RecipeManagers.fabricatorManager.addSmelting(new ItemStack(Block.field_71946_M), LiquidHelper.getLiquid("glass", 1000), 1000);
        RecipeManagers.fabricatorManager.addSmelting(new ItemStack(Block.field_72003_bq), LiquidHelper.getLiquid("glass", 375), 1000);
        RecipeManagers.fabricatorManager.addSmelting(new ItemStack(Block.field_71939_E), LiquidHelper.getLiquid("glass", 1000), 3000);
        RecipeManagers.carpenterManager.addRecipe(50, LiquidHelper.getLiquid("seedoil", 250), null, new ItemStack(ForestryItem.impregnatedCasing, 1), new Object[]{"###", "# #", "###", Character.valueOf('#'), "logWood"});
        RecipeManagers.carpenterManager.addRecipe(50, LiquidHelper.getLiquid("seedoil", 500), null, new ItemStack(ForestryBlock.core, 1, 1), new Object[]{"#  ", "###", "# #", Character.valueOf('#'), "plankWood"});
        RecipeManagers.carpenterManager.addRecipe(10, LiquidHelper.getLiquid("seedoil", 100), null, new ItemStack(ForestryItem.stickImpregnated, 2), new Object[]{"#", "#", Character.valueOf('#'), "logWood"});
        RecipeManagers.carpenterManager.addRecipe(5, LiquidHelper.getLiquid("water", 250), null, new ItemStack(ForestryItem.woodPulp, 4), new Object[]{"#", Character.valueOf('#'), "logWood"});
        RecipeManagers.carpenterManager.addRecipe(5, LiquidHelper.getLiquid("water", 250), null, new ItemStack(Item.field_77759_aK, 1), new Object[]{"#", "#", Character.valueOf('#'), "pulpWood"});
        RecipeManagers.carpenterManager.addRecipe(5, LiquidHelper.getLiquid("water", 1000), null, new ItemStack(ForestryBlock.soil, 9, 0), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), ForestryItem.mulch});
        RecipeManagers.carpenterManager.addRecipe(5, LiquidHelper.getLiquid("water", 1000), null, new ItemStack(ForestryBlock.soil, 8, 1), new Object[]{"#X#", "XYX", "#X#", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), Block.field_71939_E, Character.valueOf('Y'), ForestryItem.mulch});
        RecipeManagers.carpenterManager.addRecipe(75, LiquidHelper.getLiquid("water", 5000), null, new ItemStack(ForestryItem.hardenedCasing), new Object[]{"# #", " Y ", "# #", Character.valueOf('#'), Item.field_77702_n, Character.valueOf('Y'), ForestryItem.sturdyCasing});
        RecipeManagers.carpenterManager.addRecipe(20, LiquidHelper.getLiquid("water", 1000), null, new ItemStack(ForestryItem.circuitboards, 1, 0), new Object[]{"R R", "R#R", "R R", Character.valueOf('#'), "ingotTin", Character.valueOf('R'), Item.field_77767_aC});
        RecipeManagers.carpenterManager.addRecipe(40, LiquidHelper.getLiquid("water", 1000), null, new ItemStack(ForestryItem.circuitboards, 1, 1), new Object[]{"R#R", "R#R", "R#R", Character.valueOf('#'), "ingotBronze", Character.valueOf('R'), Item.field_77767_aC});
        RecipeManagers.carpenterManager.addRecipe(80, LiquidHelper.getLiquid("water", 1000), null, new ItemStack(ForestryItem.circuitboards, 1, 2), new Object[]{"R#R", "R#R", "R#R", Character.valueOf('#'), Item.field_77703_o, Character.valueOf('R'), Item.field_77767_aC});
        RecipeManagers.carpenterManager.addRecipe(80, LiquidHelper.getLiquid("water", 1000), null, new ItemStack(ForestryItem.circuitboards, 1, 3), new Object[]{"R#R", "R#R", "R#R", Character.valueOf('#'), Item.field_77717_p, Character.valueOf('R'), Item.field_77767_aC});
        RecipeManagers.carpenterManager.addRecipe(40, LiquidHelper.getLiquid("water", 1000), null, new ItemStack(ForestryItem.solderingIron), new Object[]{" # ", "# #", "  B", Character.valueOf('#'), Item.field_77703_o, Character.valueOf('B'), "ingotBronze"});
        RecipeManagers.carpenterManager.addRecipe(5, LiquidHelper.getLiquid("water", 1000), null, new ItemStack(ForestryItem.iodineCharge, 1), new Object[]{"Z#Z", "#Y#", "X#X", Character.valueOf('#'), ForestryItem.pollen, Character.valueOf('X'), Item.field_77677_M, Character.valueOf('Y'), ForestryItem.canEmpty, Character.valueOf('Z'), ForestryItem.honeyDrop});
        RecipeManagers.carpenterManager.addRecipe(5, LiquidHelper.getLiquid("water", 1000), null, new ItemStack(ForestryItem.craftingMaterial, 1, 4), new Object[]{"Z#Z", "#Y#", "X#X", Character.valueOf('#'), ForestryItem.royalJelly, Character.valueOf('X'), Item.field_77677_M, Character.valueOf('Y'), ForestryItem.canEmpty, Character.valueOf('Z'), ForestryItem.honeydew});
        RecipeManagers.carpenterManager.addRecipe(100, null, new ItemStack(Item.field_77730_bn, 1), new Object[]{" # ", "###", " # ", Character.valueOf('#'), new ItemStack(ForestryItem.craftingMaterial, 1, 1)});
        RecipeManagers.carpenterManager.addRecipe(10, LiquidHelper.getLiquid("water", 500), null, new ItemStack(ForestryItem.craftingMaterial, 1, 3), new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ForestryItem.craftingMaterial, 1, 2)});
        RecipeManagers.carpenterManager.addRecipe(5, LiquidHelper.getLiquid("water", 1000), null, new ItemStack(ForestryItem.carton, 2), new Object[]{" # ", "# #", " # ", Character.valueOf('#'), "pulpWood"});
        RecipeManagers.carpenterManager.addRecipe(20, LiquidHelper.getLiquid("water", 1000), null, new ItemStack(ForestryItem.crate, 24), new Object[]{" # ", "# #", " # ", Character.valueOf('#'), "logWood"});
        RecipeManagers.carpenterManager.addRecipe(20, null, new ItemStack(ForestryItem.carton), new ItemStack(ForestryItem.kitPickaxe), new Object[]{"###", " X ", " X ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood"});
        RecipeManagers.carpenterManager.addRecipe(20, null, new ItemStack(ForestryItem.carton), new ItemStack(ForestryItem.kitShovel), new Object[]{" # ", " X ", " X ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood"});
        RecipeManagers.carpenterManager.addRecipe(null, new ItemStack(ForestryItem.ingotBronze.field_77993_c, 2, ForestryItem.ingotBronze.func_77958_k()), new Object[]{"#", Character.valueOf('#'), ForestryItem.brokenBronzePickaxe});
        RecipeManagers.carpenterManager.addRecipe(null, ForestryItem.ingotBronze, new Object[]{"#", Character.valueOf('#'), ForestryItem.brokenBronzeShovel});
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedWood));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedCobblestone));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedDirt));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedStone));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedBrick));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedCacti));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedSand));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedObsidian));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedNetherrack));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedSoulsand));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedSandstone));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedBogearth));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedHumus));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedNetherbrick));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedPeat));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedApatite));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedFertilizer));
        ((MachineCarpenter.RecipeManager)RecipeManagers.carpenterManager).addCrating("ingotTin", ForestryItem.ingotTin, new ItemStack((Item)ForestryItem.cratedTin));
        ((MachineCarpenter.RecipeManager)RecipeManagers.carpenterManager).addCrating("ingotCopper", ForestryItem.ingotCopper, new ItemStack((Item)ForestryItem.cratedCopper));
        ((MachineCarpenter.RecipeManager)RecipeManagers.carpenterManager).addCrating("ingotBronze", ForestryItem.ingotBronze, new ItemStack((Item)ForestryItem.cratedBronze));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedWheat));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedMycelium));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedMulch));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedCookies));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedHoneycombs));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedBeeswax));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedPollen));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedPropolis));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedHoneydew));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedRoyalJelly));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedCocoaComb));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedRedstone));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedLapis));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedReeds));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedClay));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedGlowstone));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedApples));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedNetherwart));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedSimmeringCombs));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedStringyCombs));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedFrozenCombs));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedDrippingCombs));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedRefractoryWax));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedPhosphor));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedAsh));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedCharcoal));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedGravel));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedCoal));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedSeeds));
        RecipeManagers.carpenterManager.addCrating(new ItemStack((Item)ForestryItem.cratedSaplings));
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerFactory();
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }
}

