/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.PluginInfo;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IClassification;
import forestry.api.recipes.RecipeManagers;
import forestry.apiculture.CommandBeekeepingMode;
import forestry.apiculture.CommandGiveBee;
import forestry.apiculture.FlowerProviderCacti;
import forestry.apiculture.FlowerProviderEnd;
import forestry.apiculture.FlowerProviderGourd;
import forestry.apiculture.FlowerProviderJungle;
import forestry.apiculture.FlowerProviderMushroom;
import forestry.apiculture.FlowerProviderNetherwart;
import forestry.apiculture.FlowerProviderVanilla;
import forestry.apiculture.FlowerProviderWheat;
import forestry.apiculture.GuiHandlerApiculture;
import forestry.apiculture.PacketHandlerApiculture;
import forestry.apiculture.SaveEventHandlerApiculture;
import forestry.apiculture.VillageHandlerApiculture;
import forestry.apiculture.gadgets.BlockAlveary;
import forestry.apiculture.gadgets.BlockBeehives;
import forestry.apiculture.gadgets.BlockCandle;
import forestry.apiculture.gadgets.BlockStump;
import forestry.apiculture.gadgets.TileAlvearyFan;
import forestry.apiculture.gadgets.TileAlvearyHeater;
import forestry.apiculture.gadgets.TileAlvearyHygroregulator;
import forestry.apiculture.gadgets.TileAlvearyPlain;
import forestry.apiculture.gadgets.TileAlvearySieve;
import forestry.apiculture.gadgets.TileAlvearyStabiliser;
import forestry.apiculture.gadgets.TileAlvearySwarmer;
import forestry.apiculture.gadgets.TileApiaristChest;
import forestry.apiculture.gadgets.TileApiary;
import forestry.apiculture.gadgets.TileBeehouse;
import forestry.apiculture.gadgets.TileSwarm;
import forestry.apiculture.genetics.AlleleBeeSpecies;
import forestry.apiculture.genetics.AlleleEffectAggressive;
import forestry.apiculture.genetics.AlleleEffectCreeper;
import forestry.apiculture.genetics.AlleleEffectExploration;
import forestry.apiculture.genetics.AlleleEffectGlacial;
import forestry.apiculture.genetics.AlleleEffectHeroic;
import forestry.apiculture.genetics.AlleleEffectIgnition;
import forestry.apiculture.genetics.AlleleEffectMiasmic;
import forestry.apiculture.genetics.AlleleEffectMisanthrope;
import forestry.apiculture.genetics.AlleleEffectNone;
import forestry.apiculture.genetics.AlleleEffectPotion;
import forestry.apiculture.genetics.AlleleEffectRadioactive;
import forestry.apiculture.genetics.AlleleEffectRepulsion;
import forestry.apiculture.genetics.AlleleEffectResurrection;
import forestry.apiculture.genetics.AlleleEffectSnowing;
import forestry.apiculture.genetics.AlleleFlowers;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeHelper;
import forestry.apiculture.genetics.BeeMutation;
import forestry.apiculture.genetics.BeeTemplates;
import forestry.apiculture.genetics.BeekeepingMode;
import forestry.apiculture.genetics.BranchBees;
import forestry.apiculture.genetics.HiveDrop;
import forestry.apiculture.genetics.JubilanceNone;
import forestry.apiculture.genetics.JubilanceProviderHermit;
import forestry.apiculture.genetics.MutationTimeLimited;
import forestry.apiculture.items.ItemArmorApiarist;
import forestry.apiculture.items.ItemBeeGE;
import forestry.apiculture.items.ItemBeealyzer;
import forestry.apiculture.items.ItemBiomefinder;
import forestry.apiculture.items.ItemHiveFrame;
import forestry.apiculture.items.ItemHoneycomb;
import forestry.apiculture.items.ItemImprinter;
import forestry.apiculture.items.ItemWaxCast;
import forestry.apiculture.proxy.ProxyApiculture;
import forestry.apiculture.trigger.TriggerNoFrames;
import forestry.apiculture.worldgen.WorldGenHiveEnd;
import forestry.apiculture.worldgen.WorldGenHiveForest;
import forestry.apiculture.worldgen.WorldGenHiveJungle;
import forestry.apiculture.worldgen.WorldGenHiveMeadows;
import forestry.apiculture.worldgen.WorldGenHiveParched;
import forestry.apiculture.worldgen.WorldGenHiveSnow;
import forestry.apiculture.worldgen.WorldGenHiveSwamp;
import forestry.core.GameMode;
import forestry.core.config.Config;
import forestry.core.config.Configuration;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.config.Property;
import forestry.core.gadgets.BlockBase;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.genetics.Allele;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.IPacketHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.items.ItemCrated;
import forestry.core.items.ItemForestry;
import forestry.core.items.ItemForestryBlock;
import forestry.core.items.ItemOverlay;
import forestry.core.proxy.Proxies;
import forestry.core.triggers.Trigger;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.plugins.NativePlugin;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

@PluginInfo(pluginID="Apiculture", name="Apiculture", author="SirSengir", url="http://forestry.sengir.net/", description="Adds bees, beekeeping and bee products. Affects world generation.")
public class PluginApiculture
extends NativePlugin {
    @SidedProxy(clientSide="forestry.apiculture.proxy.ClientProxyApiculture", serverSide="forestry.apiculture.proxy.ProxyApiculture")
    public static ProxyApiculture proxy;
    private static final String CONFIG_CATEGORY = "apiculture";
    private Configuration apicultureConfig;
    public static String beekeepingMode;
    public static int beeCycleTicks;
    public static boolean apiarySideSensitive;
    public static boolean fancyRenderedBees;
    public static Trigger triggerNoFrames;
    private ArrayList forestDrops;
    private ArrayList meadowsDrops;
    private ArrayList desertDrops;
    private ArrayList jungleDrops;
    private ArrayList endDrops;
    private ArrayList snowDrops;
    private ArrayList swampDrops;
    private ArrayList swarmDrops;
    public static IBeeRoot beeInterface;
    public static MachineDefinition definitionApiary;
    public static MachineDefinition definitionChest;
    public static MachineDefinition definitionBeehouse;

    @Override
    public boolean isAvailable() {
        return !Config.disableApiculture;
    }

    @Override
    public void preInit() {
        super.preInit();
        proxy.addLocalizations();
        this.createHiveDropArrays();
        int blockid = Config.getOrCreateBlockIdProperty(CONFIG_CATEGORY, 1408);
        definitionApiary = new MachineDefinition(blockid, 0, "forestry.Apiary", TileApiary.class, ShapedRecipeCustom.createShapedRecipe(new Object[]{"XXX", "#C#", "###", Character.valueOf('X'), "slabWood", Character.valueOf('#'), "plankWood", Character.valueOf('C'), ForestryItem.impregnatedCasing}, new ItemStack(blockid, 1, 0))).setFaces(0, 1, 2, 2, 4, 4, 0, 7);
        definitionBeehouse = new MachineDefinition(blockid, 2, "forestry.Beehouse", TileBeehouse.class, ShapedRecipeCustom.createShapedRecipe(new Object[]{"XXX", "#C#", "###", Character.valueOf('X'), "slabWood", Character.valueOf('#'), "plankWood", Character.valueOf('C'), "beeComb"}, new ItemStack(blockid, 1, 2))).setFaces(0, 1, 2, 2, 4, 4, 0, 7);
        definitionChest = new MachineDefinition(blockid, 1, "forestry.ApiaristChest", TileApiaristChest.class, ShapedRecipeCustom.createShapedRecipe(new Object[]{" # ", "XYX", "XXX", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), "beeComb", Character.valueOf('Y'), Block.field_72077_au}, new ItemStack(blockid, 1, 1))).setFaces(0, 1, 2, 3, 4, 4);
        ForestryBlock.apiculture = new BlockBase(blockid, Material.field_76243_f, new MachineDefinition[]{definitionApiary, definitionChest, definitionBeehouse}).func_71864_b("for.apiculture").func_71849_a(Tabs.tabApiculture);
        Item.field_77698_e[ForestryBlock.apiculture.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.apiculture.field_71990_ca] = new ItemForestryBlock(ForestryBlock.apiculture.field_71990_ca - 256, "for.apiculture");
        ForestryBlock.beehives = new BlockBeehives(Config.getOrCreateBlockIdProperty("beehives", 1399)).func_71864_b("oreCopper");
        Item.field_77698_e[ForestryBlock.beehives.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.beehives.field_71990_ca] = new ItemForestryBlock(ForestryBlock.beehives.field_71990_ca - 256, "oreCopper");
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.beehives, (int)0, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.beehives, (int)1, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.beehives, (int)2, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.beehives, (int)3, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.beehives, (int)4, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.beehives, (int)5, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.beehives, (int)6, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.beehives, (int)7, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.beehives, (int)8, (String)"scoop", (int)0);
        beeInterface = BeeManager.beeInterface = new BeeHelper();
        AlleleManager.alleleRegistry.registerSpeciesRoot(BeeManager.beeInterface);
        BeeManager.villageBees = new ArrayList[]{new ArrayList(), new ArrayList()};
        ForestryBlock.stump = new BlockStump(Config.getOrCreateBlockIdProperty("stump", 1379)).func_71864_b("stump");
        Item.field_77698_e[ForestryBlock.stump.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.stump.field_71990_ca] = new ItemForestryBlock(ForestryBlock.stump.field_71990_ca - 256, "stump");
        ForestryBlock.candle = new BlockCandle(Config.getOrCreateBlockIdProperty("candle", 1378)).func_71864_b("candle");
        Item.field_77698_e[ForestryBlock.candle.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.candle.field_71990_ca] = new ItemForestryBlock(ForestryBlock.candle.field_71990_ca - 256, "candle");
        ForestryBlock.alveary = new BlockAlveary(Config.getOrCreateBlockIdProperty("alveary", 1382)).func_71864_b("alveary");
        Item.field_77698_e[ForestryBlock.alveary.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.alveary.field_71990_ca] = new ItemForestryBlock(ForestryBlock.alveary.field_71990_ca - 256, "alveary");
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.alveary, (String)"axe", (int)0);
        triggerNoFrames = new TriggerNoFrames(620);
        this.createAlleles();
        VillageHandlerApiculture.registerVillageComponents();
    }

    @Override
    public void doInit() {
        super.doInit();
        this.apicultureConfig = new Configuration();
        Property property = this.apicultureConfig.get("apiary.sidesensitive", CONFIG_CATEGORY, apiarySideSensitive);
        property.Comment = "set to false if apiaries should output all items regardless of side a pipe is attached to";
        apiarySideSensitive = Boolean.parseBoolean(property.Value);
        property = this.apicultureConfig.get("render.bees.fancy", CONFIG_CATEGORY, fancyRenderedBees);
        property.Comment = "set to true to enable a fancy butterfly-like renderer for bees. (experimental!)";
        fancyRenderedBees = Boolean.parseBoolean(property.Value);
        property = this.apicultureConfig.get("beekeeping.mode", CONFIG_CATEGORY, "NORMAL");
        property.Comment = "change beekeeping modes here. possible values EASY, NORMAL, HARD, HARDCORE, INSANE. mods may add additional modes.";
        beekeepingMode = property.Value.trim();
        Proxies.log.finer("Beekeeping mode read from config: " + beekeepingMode);
        property = this.apicultureConfig.get("beekeeping.flowers.custom", CONFIG_CATEGORY, "");
        property.Comment = "add additional flower blocks for apiaries here in the format id:meta. separate blocks using ';'. will be treated like vanilla flowers. not recommended for flowers implemented as tile entities.";
        this.parseAdditionalFlowers(property.Value, FlowerManager.plainFlowers);
        property = this.apicultureConfig.get("species.blacklist", CONFIG_CATEGORY, "");
        property.Comment = "add species to blacklist identified by their uid and seperated with ';'.";
        this.parseBeeBlacklist(property.Value);
        this.apicultureConfig.save();
        this.createMutations();
        this.registerBeehiveDrops();
        beeInterface.registerBeekeepingMode(BeekeepingMode.easy);
        beeInterface.registerBeekeepingMode(BeekeepingMode.normal);
        beeInterface.registerBeekeepingMode(BeekeepingMode.hard);
        beeInterface.registerBeekeepingMode(BeekeepingMode.hardcore);
        beeInterface.registerBeekeepingMode(BeekeepingMode.insane);
        BeeManager.inducers.put(new ItemStack(ForestryItem.royalJelly), 10);
        this.registerTemplates();
        definitionApiary.register();
        definitionBeehouse.register();
        definitionChest.register();
        GameRegistry.registerTileEntity(TileAlvearyPlain.class, (String)"forestry.Alveary");
        GameRegistry.registerTileEntity(TileSwarm.class, (String)"forestry.Swarm");
        GameRegistry.registerTileEntity(TileAlvearySwarmer.class, (String)"forestry.AlvearySwarmer");
        GameRegistry.registerTileEntity(TileAlvearyHeater.class, (String)"forestry.AlvearyHeater");
        GameRegistry.registerTileEntity(TileAlvearyFan.class, (String)"forestry.AlvearyFan");
        GameRegistry.registerTileEntity(TileAlvearyHygroregulator.class, (String)"forestry.AlvearyHygro");
        GameRegistry.registerTileEntity(TileAlvearyStabiliser.class, (String)"forestry.AlvearyStabiliser");
        GameRegistry.registerTileEntity(TileAlvearySieve.class, (String)"forestry.AlvearySieve");
        BeeManager.villageBees[0].add(beeInterface.templateAsGenome(BeeTemplates.getForestTemplate()));
        BeeManager.villageBees[0].add(beeInterface.templateAsGenome(BeeTemplates.getMeadowsTemplate()));
        BeeManager.villageBees[0].add(beeInterface.templateAsGenome(BeeTemplates.getModestTemplate()));
        BeeManager.villageBees[0].add(beeInterface.templateAsGenome(BeeTemplates.getMarshyTemplate()));
        BeeManager.villageBees[0].add(beeInterface.templateAsGenome(BeeTemplates.getWintryTemplate()));
        BeeManager.villageBees[0].add(beeInterface.templateAsGenome(BeeTemplates.getTropicalTemplate()));
        BeeManager.villageBees[1].add(beeInterface.templateAsGenome(BeeTemplates.getForestRainResistTemplate()));
        BeeManager.villageBees[1].add(beeInterface.templateAsGenome(BeeTemplates.getCommonTemplate()));
        BeeManager.villageBees[1].add(beeInterface.templateAsGenome(BeeTemplates.getValiantTemplate()));
        VillageHandlerApiculture villageHandler = new VillageHandlerApiculture();
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)villageHandler);
        VillagerRegistry.instance().registerVillagerId(80);
        Proxies.render.registerVillagerSkin(80, "textures/entity/beekeeper.png");
        VillagerRegistry.instance().registerVillageTradeHandler(80, (VillagerRegistry.IVillageTradeHandler)villageHandler);
        proxy.initializeRendering();
    }

    @Override
    public void postInit() {
        super.postInit();
        this.registerDungeonLoot();
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerApiculture();
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return new PacketHandlerApiculture();
    }

    @Override
    protected void registerItems() {
        ForestryItem.beeQueenGE = new ItemBeeGE(Config.getOrCreateItemIdProperty("beeQueenGE", 13083), EnumBeeType.QUEEN).func_77655_b("beeQueenGE");
        ForestryItem.beeDroneGE = new ItemBeeGE(Config.getOrCreateItemIdProperty("beeDroneGE", 13084), EnumBeeType.DRONE).func_77655_b("beeDroneGE");
        ForestryItem.beePrincessGE = new ItemBeeGE(Config.getOrCreateItemIdProperty("beePrincessGE", 13085), EnumBeeType.PRINCESS).func_77655_b("beePrincessGE");
        ForestryItem.beeLarvaeGE = new ItemBeeGE(Config.getOrCreateItemIdProperty("beeLarvaeGE", 13134), EnumBeeType.LARVAE).func_77655_b("beeLarvaeGE");
        ForestryItem.beealyzer = new ItemBeealyzer(Config.getOrCreateItemIdProperty("beealyzer", 13086)).func_77655_b("beealyzer");
        ForestryItem.biomeFinder = new ItemBiomefinder(Config.getOrCreateItemIdProperty("biomeFinder", 13105)).func_77655_b("biomeFinder");
        ForestryItem.imprinter = new ItemImprinter(Config.getOrCreateItemIdProperty("imprinter", 13110)).func_77655_b("imprinter");
        ForestryItem.frameUntreated = new ItemHiveFrame(Config.getOrCreateItemIdProperty("frameUntreated", 13125), 80, 0.9f).func_77655_b("frameUntreated");
        ForestryItem.frameImpregnated = new ItemHiveFrame(Config.getOrCreateItemIdProperty("frameImpregnated", 13126), 240, 0.4f).func_77655_b("frameImpregnated");
        ForestryItem.frameProven = new ItemHiveFrame(Config.getOrCreateItemIdProperty("frameProven", 13127), 720, 0.3f).func_77655_b("frameProven");
        ForestryItem.honeyDrop = new ItemOverlay(Config.getOrCreateItemIdProperty("honeyDrop", 13027), Tabs.tabApiculture, new ItemOverlay.OverlayInfo[]{new ItemOverlay.OverlayInfo("honey", 15512621, 15255572), new ItemOverlay.OverlayInfo("charged", 0x800505, 10225415).setIsSecret(), new ItemOverlay.OverlayInfo("omega", 0x191919, 4885671).setIsSecret()}).func_77655_b("honeyDrop");
        OreDictionary.registerOre((String)"dropHoney", (ItemStack)new ItemStack(ForestryItem.honeyDrop, 1, 0));
        ForestryItem.pollen = new ItemOverlay(Config.getOrCreateItemIdProperty("pollen", 13030), Tabs.tabApiculture, new ItemOverlay.OverlayInfo[]{new ItemOverlay.OverlayInfo("normal", 10652197, 10652197), new ItemOverlay.OverlayInfo("crystalline", 0xFFFFFF, 12975871)}).func_77655_b("pollen");
        OreDictionary.registerOre((String)"itemPollen", (ItemStack)new ItemStack(ForestryItem.pollen));
        ForestryItem.propolis = new ItemOverlay(Config.getOrCreateItemIdProperty("propolis", 13031), Tabs.tabApiculture, new ItemOverlay.OverlayInfo[]{new ItemOverlay.OverlayInfo("normal", 12956238), new ItemOverlay.OverlayInfo("sticky", 13012567), new ItemOverlay.OverlayInfo("pulsating", 2936241).setIsSecret(), new ItemOverlay.OverlayInfo("silky", 0xDDFF00)}).func_77655_b("propolis");
        ForestryItem.honeydew = new ItemForestry(Config.getOrCreateItemIdProperty("honeydew", 13033)).func_77655_b("honeydew").func_77637_a(Tabs.tabApiculture);
        OreDictionary.registerOre((String)"dropHoneydew", (ItemStack)new ItemStack(ForestryItem.honeydew));
        ForestryItem.royalJelly = new ItemForestry(Config.getOrCreateItemIdProperty("royalJelly", 13032)).func_77655_b("royalJelly").func_77637_a(Tabs.tabApiculture);
        OreDictionary.registerOre((String)"dropRoyalJelly", (ItemStack)new ItemStack(ForestryItem.royalJelly));
        ForestryItem.waxCast = new ItemWaxCast(Config.getOrCreateItemIdProperty("waxCast", 13123)).func_77655_b("waxCast").func_77637_a(Tabs.tabApiculture);
        ForestryItem.beeComb = new ItemHoneycomb(Config.getOrCreateItemIdProperty("beeCombs", 13104)).func_77655_b("beeCombs");
        OreDictionary.registerOre((String)"beeComb", (ItemStack)new ItemStack(ForestryItem.beeComb, 1, Short.MAX_VALUE));
        ForestryItem.apiaristHat = new ItemArmorApiarist(Config.getOrCreateItemIdProperty("apiaristHelmet", 13100), 0).func_77655_b("apiaristHelmet");
        ForestryItem.apiaristChest = new ItemArmorApiarist(Config.getOrCreateItemIdProperty("apiaristChest", 13101), 1).func_77655_b("apiaristChest");
        ForestryItem.apiaristLegs = new ItemArmorApiarist(Config.getOrCreateItemIdProperty("apiaristLegs", 13102), 2).func_77655_b("apiaristLegs");
        ForestryItem.apiaristBoots = new ItemArmorApiarist(Config.getOrCreateItemIdProperty("apiaristBoots", 13103), 3).func_77655_b("apiaristBoots");
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerCrates() {
        ForestryItem.cratedBeeswax = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedBeeswax", 13528), new ItemStack(ForestryItem.beeswax)).func_77655_b("cratedBeeswax");
        ForestryItem.cratedPollen = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedPollen", 13529), new ItemStack(ForestryItem.pollen)).func_77655_b("cratedPollen");
        ForestryItem.cratedPropolis = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedPropolis", 13530), new ItemStack(ForestryItem.propolis)).func_77655_b("cratedPropolis");
        ForestryItem.cratedHoneydew = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedHoneydew", 13531), new ItemStack(ForestryItem.honeydew)).func_77655_b("cratedHoneydew");
        ForestryItem.cratedRoyalJelly = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedRoyalJelly", 13532), new ItemStack(ForestryItem.royalJelly)).func_77655_b("cratedRoyalJelly");
        ForestryItem.cratedHoneycombs = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedHoneycombs", 13527), new ItemStack(ForestryItem.beeComb, 1, 0)).func_77655_b("cratedHoneycombs");
        ForestryItem.cratedCocoaComb = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedCocoaComb", 13533), new ItemStack(ForestryItem.beeComb, 1, 1)).func_77655_b("cratedCocoaComb");
        ForestryItem.cratedSimmeringCombs = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedSimmeringCombs", 13545), new ItemStack(ForestryItem.beeComb, 1, 2)).func_77655_b("cratedSimmeringCombs");
        ForestryItem.cratedStringyCombs = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedStringyCombs", 13546), new ItemStack(ForestryItem.beeComb, 1, 3)).func_77655_b("cratedStringyCombs");
        ForestryItem.cratedFrozenCombs = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedFrozenCombs", 13547), new ItemStack(ForestryItem.beeComb, 1, 4)).func_77655_b("cratedFrozenCombs");
        ForestryItem.cratedDrippingCombs = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedDrippingCombs", 13548), new ItemStack(ForestryItem.beeComb, 1, 5)).func_77655_b("cratedDrippingCombs");
        ForestryItem.cratedRefractoryWax = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedRefractoryWax", 13549), new ItemStack(ForestryItem.refractoryWax)).func_77655_b("cratedRefractoryWax");
    }

    @Override
    protected void registerRecipes() {
        Proxies.common.addRecipe(new ItemStack(ForestryItem.apiaristHat), new Object[]{"###", "# #", Character.valueOf('#'), new ItemStack(ForestryItem.craftingMaterial, 1, 3)});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.apiaristChest), new Object[]{"# #", "###", "###", Character.valueOf('#'), new ItemStack(ForestryItem.craftingMaterial, 1, 3)});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.apiaristLegs), new Object[]{"###", "# #", "# #", Character.valueOf('#'), new ItemStack(ForestryItem.craftingMaterial, 1, 3)});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.apiaristBoots), new Object[]{"# #", "# #", Character.valueOf('#'), new ItemStack(ForestryItem.craftingMaterial, 1, 3)});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.biomeFinder), new Object[]{" X ", "X#X", " X ", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('X'), "ingotBronze"});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.vialCatalyst, 3), new Object[]{"###", "YXY", Character.valueOf('#'), ForestryItem.waxCapsule, Character.valueOf('X'), Item.field_77755_aX, Character.valueOf('Y'), ForestryItem.pollen});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.vialCatalyst, 3), new Object[]{"###", "YXY", Character.valueOf('#'), ForestryItem.canEmpty, Character.valueOf('X'), Item.field_77755_aX, Character.valueOf('Y'), ForestryItem.pollen});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.vialCatalyst), new Object[]{"###", "YXY", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('Y'), ForestryItem.fertilizerCompound, Character.valueOf('X'), ForestryItem.waxCapsule});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.vialCatalyst), new Object[]{"###", "YXY", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('Y'), ForestryItem.fertilizerCompound, Character.valueOf('X'), ForestryItem.canEmpty});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.vialCatalyst), new Object[]{"###", "YXY", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('Y'), ForestryItem.pollen, Character.valueOf('X'), ForestryItem.waxCapsule});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.vialCatalyst), new Object[]{"###", "YXY", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('Y'), ForestryItem.pollen, Character.valueOf('X'), ForestryItem.canEmpty});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.scoop, 1), new Object[]{"#X#", "###", " # ", Character.valueOf('#'), "stickWood", Character.valueOf('X'), Block.field_72101_ab});
        Proxies.common.addRecipe(new ItemStack(Item.field_77761_aM), new Object[]{"#X#", "#X#", "#X#", Character.valueOf('#'), ForestryItem.propolis, Character.valueOf('X'), ForestryItem.pollen});
        Proxies.common.addRecipe(new ItemStack(Item.field_77813_bB), new Object[]{"#X#", "#Y#", "#X#", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('X'), ForestryItem.honeydew, Character.valueOf('Y'), Item.field_77738_bf});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.frameUntreated), new Object[]{"###", "#S#", "###", Character.valueOf('#'), "stickWood", Character.valueOf('S'), Item.field_77683_K});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.frameImpregnated), new Object[]{"###", "#S#", "###", Character.valueOf('#'), ForestryItem.stickImpregnated, Character.valueOf('S'), Item.field_77683_K});
        if (ForestryItem.honeyedSlice != null) {
            Proxies.common.addRecipe(new ItemStack(ForestryItem.honeyedSlice, 4), new Object[]{"###", "#X#", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('X'), Item.field_77684_U});
        }
        if (ForestryItem.honeyPot != null) {
            Proxies.common.addRecipe(new ItemStack(ForestryItem.honeyPot, 1), new Object[]{"# #", " X ", "# #", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('X'), ForestryItem.waxCapsule});
        }
        if (ForestryItem.ambrosia != null) {
            Proxies.common.addRecipe(new ItemStack(ForestryItem.ambrosia), new Object[]{"#Y#", "XXX", "###", Character.valueOf('#'), ForestryItem.honeydew, Character.valueOf('X'), ForestryItem.royalJelly, Character.valueOf('Y'), ForestryItem.waxCapsule});
        }
        Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.capsule"), new Object[]{"###", Character.valueOf('#'), ForestryItem.beeswax});
        Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.refractory"), new Object[]{"###", Character.valueOf('#'), ForestryItem.refractoryWax});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.bituminousPeat), new Object[]{" # ", "XYX", " # ", Character.valueOf('#'), "dustAsh", Character.valueOf('X'), ForestryItem.peat, Character.valueOf('Y'), ForestryItem.propolis});
        Proxies.common.addRecipe(new ItemStack(Block.field_72069_aq, 3), new Object[]{" # ", " # ", " Y ", Character.valueOf('#'), ForestryItem.beeswax, Character.valueOf('Y'), "stickWood"});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.craftingMaterial, 1, 1), new Object[]{"# #", " # ", "# #", Character.valueOf('#'), new ItemStack(ForestryItem.propolis, 1, 2)});
        RecipeManagers.carpenterManager.addRecipe(30, LiquidHelper.getLiquid("water", 600), null, new ItemStack(ForestryBlock.candle, 24), new Object[]{" X ", "###", "###", Character.valueOf('#'), ForestryItem.beeswax, Character.valueOf('X'), Item.field_77683_K});
        RecipeManagers.carpenterManager.addRecipe(10, LiquidHelper.getLiquid("water", 200), null, new ItemStack(ForestryBlock.candle, 6), new Object[]{"#X#", Character.valueOf('#'), ForestryItem.beeswax, Character.valueOf('X'), new ItemStack(ForestryItem.craftingMaterial, 1, 2)});
        Proxies.common.addRecipe(new ItemStack(ForestryItem.waxCast), new Object[]{"###", "# #", "###", Character.valueOf('#'), ForestryItem.beeswax});
        Proxies.common.addRecipe(new ItemStack(ForestryBlock.alveary), new Object[]{"###", "#X#", "###", Character.valueOf('X'), ForestryItem.impregnatedCasing, Character.valueOf('#'), new ItemStack(ForestryItem.craftingMaterial, 1, 6)});
        Proxies.common.addRecipe(new ItemStack(ForestryBlock.alveary, 1, 2), new Object[]{"#G#", " X ", "#G#", Character.valueOf('#'), new ItemStack(ForestryItem.tubes, 1, 5), Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('G'), Item.field_77717_p});
        Proxies.common.addRecipe(new ItemStack(ForestryBlock.alveary, 1, 3), new Object[]{"I I", " X ", "I#I", Character.valueOf('#'), new ItemStack(ForestryItem.tubes, 1, 4), Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('I'), Item.field_77703_o});
        Proxies.common.addRecipe(new ItemStack(ForestryBlock.alveary, 1, 4), new Object[]{"#I#", " X ", "YYY", Character.valueOf('#'), new ItemStack(ForestryItem.tubes, 1, 4), Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('Y'), Block.field_71981_t});
        Proxies.common.addRecipe(new ItemStack(ForestryBlock.alveary, 1, 5), new Object[]{"GIG", "GXG", "GIG", Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('G'), Block.field_71946_M});
        Proxies.common.addRecipe(new ItemStack(ForestryBlock.alveary, 1, 6), new Object[]{"G G", "GXG", "G G", Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('G'), Item.field_94583_ca});
        Proxies.common.addRecipe(new ItemStack(ForestryBlock.alveary, 1, 7), new Object[]{"III", " X ", "WWW", Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('W'), new ItemStack(ForestryItem.craftingMaterial, 1, 3)});
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(ForestryItem.honeyDrop)}, LiquidHelper.getLiquid("honey", 100), new ItemStack(ForestryItem.propolis), 5);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(ForestryItem.honeydew)}, LiquidHelper.getLiquid("honey", 100));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(ForestryItem.phosphor, 2), new ItemStack(Block.field_71939_E)}, LiquidHelper.getLiquid("lava", 2000));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(ForestryItem.phosphor, 2), new ItemStack(Block.field_71979_v)}, LiquidHelper.getLiquid("lava", 1600));
        RecipeManagers.carpenterManager.addRecipe(100, LiquidHelper.getLiquid("water", 2000), null, new ItemStack(ForestryItem.beealyzer), new Object[]{"X#X", "X#X", "RDR", Character.valueOf('#'), Block.field_72003_bq, Character.valueOf('X'), "ingotTin", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('D'), Item.field_77702_n});
        RecipeManagers.carpenterManager.addRecipe(50, LiquidHelper.getLiquid("honey", 500), null, new ItemStack(ForestryItem.craftingMaterial, 1, 6), new Object[]{" J ", "###", "WPW", Character.valueOf('#'), "plankWood", Character.valueOf('J'), ForestryItem.royalJelly, Character.valueOf('W'), ForestryItem.beeswax, Character.valueOf('P'), ForestryItem.pollen});
        RecipeManagers.centrifugeManager.addRecipe(20, new ItemStack(ForestryItem.beeComb, 1, 0), new ItemStack(ForestryItem.beeswax), new ItemStack(ForestryItem.honeyDrop), 90);
        RecipeManagers.centrifugeManager.addRecipe(20, new ItemStack(ForestryItem.beeComb, 1, 1), new ItemStack(ForestryItem.beeswax), new ItemStack(Item.field_77756_aW, 1, 3), 50);
        RecipeManagers.centrifugeManager.addRecipe(20, new ItemStack(ForestryItem.beeComb, 1, 2), new ItemStack(ForestryItem.refractoryWax), new ItemStack(ForestryItem.phosphor, 2), 70);
        RecipeManagers.centrifugeManager.addRecipe(20, new ItemStack(ForestryItem.beeComb, 1, 3), new ItemStack(ForestryItem.propolis), new ItemStack(ForestryItem.honeyDrop), 40);
        RecipeManagers.centrifugeManager.addRecipe(20, new ItemStack(ForestryItem.beeComb, 1, 5), new ItemStack(ForestryItem.honeydew), new ItemStack(ForestryItem.honeyDrop), 40);
        RecipeManagers.centrifugeManager.addRecipe(20, new ItemStack(ForestryItem.beeComb, 1, 4), new ItemStack[]{new ItemStack(ForestryItem.beeswax), new ItemStack(ForestryItem.honeyDrop), new ItemStack(Item.field_77768_aD), new ItemStack(ForestryItem.pollen, 1, 1)}, new int[]{80, 70, 40, 20});
        RecipeManagers.centrifugeManager.addRecipe(20, new ItemStack(ForestryItem.beeComb, 1, 6), new ItemStack(ForestryItem.honeyDrop), new ItemStack(ForestryItem.propolis, 1, 3), 80);
        RecipeManagers.centrifugeManager.addRecipe(20, new ItemStack(ForestryItem.beeComb, 1, 7), new ItemStack(ForestryItem.beeswax), new ItemStack(ForestryItem.honeyDrop), 90);
        RecipeManagers.centrifugeManager.addRecipe(20, new ItemStack(ForestryItem.beeComb, 1, 8), new ItemStack[]{new ItemStack(ForestryItem.honeyDrop), new ItemStack(ForestryItem.propolis, 1, 2)}, new int[]{40, 100});
        RecipeManagers.centrifugeManager.addRecipe(20, new ItemStack(ForestryItem.beeComb, 1, 9), new ItemStack[0], new int[0]);
        RecipeManagers.centrifugeManager.addRecipe(20, new ItemStack(ForestryItem.beeComb, 1, 10), new ItemStack[]{new ItemStack(ForestryItem.honeyDrop), new ItemStack(ForestryItem.beeswax), new ItemStack(Item.field_77677_M)}, new int[]{20, 20, 90});
        RecipeManagers.centrifugeManager.addRecipe(80, new ItemStack(ForestryItem.beeComb, 1, 11), new ItemStack[]{new ItemStack(ForestryItem.honeyDrop, 2, 1)}, new int[]{100});
        RecipeManagers.centrifugeManager.addRecipe(80, new ItemStack(ForestryItem.beeComb, 1, 12), new ItemStack[]{new ItemStack(ForestryItem.honeyDrop, 1, 1)}, new int[]{100});
        RecipeManagers.centrifugeManager.addRecipe(400, new ItemStack(ForestryItem.beeComb, 1, 13), new ItemStack[]{new ItemStack(ForestryItem.honeyDrop, 1, 2)}, new int[]{100});
        RecipeManagers.centrifugeManager.addRecipe(20, new ItemStack(ForestryItem.beeComb, 1, 14), new ItemStack[]{new ItemStack(ForestryItem.honeyDrop), new ItemStack(ForestryItem.beeswax), new ItemStack(Item.field_77685_T)}, new int[]{20, 20, 80});
        RecipeManagers.centrifugeManager.addRecipe(20, new ItemStack(ForestryItem.beeComb, 1, 15), new ItemStack(ForestryItem.beeswax), new ItemStack(ForestryItem.honeyDrop), 90);
        RecipeManagers.centrifugeManager.addRecipe(20, new ItemStack(ForestryItem.beeComb, 1, 16), new ItemStack[]{new ItemStack(ForestryItem.honeydew), new ItemStack(ForestryItem.beeswax), new ItemStack(Item.field_94583_ca)}, new int[]{60, 20, 30});
        RecipeManagers.centrifugeManager.addRecipe(5, new ItemStack(ForestryItem.propolis, 1, 3), new ItemStack[]{new ItemStack(ForestryItem.craftingMaterial, 1, 2), new ItemStack(ForestryItem.propolis)}, new int[]{60, 10});
        RecipeManagers.fermenterManager.addRecipe(new ItemStack(ForestryItem.honeydew), 500, 1.0f, LiquidHelper.getLiquid("short.mead", 1), LiquidHelper.getLiquid("honey", 1));
    }

    @Override
    public void generateSurface(World world, Random rand, int chunkX, int chunkZ) {
        if (Config.generateBeehives) {
            int randPosZ;
            int randPosY;
            int randPosX;
            int i;
            for (i = 0; i < 3; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                if (!new WorldGenHiveForest().func_76484_a(world, rand, randPosX, randPosY = rand.nextInt(50) + 42, randPosZ = chunkZ + rand.nextInt(16))) continue;
                return;
            }
            for (i = 0; i < 3; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                if (!new WorldGenHiveJungle().func_76484_a(world, rand, randPosX, randPosY = rand.nextInt(50) + 62, randPosZ = chunkZ + rand.nextInt(16))) continue;
                return;
            }
            for (i = 0; i < 1; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                if (!new WorldGenHiveMeadows().func_76484_a(world, rand, randPosX, randPosY = rand.nextInt(50) + 42, randPosZ = chunkZ + rand.nextInt(16))) continue;
                return;
            }
            for (i = 0; i < 2; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                if (!new WorldGenHiveParched().func_76484_a(world, rand, randPosX, randPosY = rand.nextInt(50) + 42, randPosZ = chunkZ + rand.nextInt(16))) continue;
                return;
            }
            for (i = 0; i < 2; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                randPosY = rand.nextInt(50) + 42;
                randPosZ = chunkZ + rand.nextInt(16);
                new WorldGenHiveEnd().func_76484_a(world, rand, randPosX, randPosY, randPosZ);
            }
            for (i = 0; i < 2; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                if (!new WorldGenHiveSnow().func_76484_a(world, rand, randPosX, randPosY = rand.nextInt(50) + 42, randPosZ = chunkZ + rand.nextInt(16))) continue;
                return;
            }
            for (i = 0; i < 2; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                if (!new WorldGenHiveSwamp().func_76484_a(world, rand, randPosX, randPosY = rand.nextInt(50) + 42, randPosZ = chunkZ + rand.nextInt(16))) continue;
                return;
            }
        }
    }

    private void registerBeehiveDrops() {
        this.forestDrops.add(new HiveDrop(BeeTemplates.getForestTemplate(), new ItemStack[]{new ItemStack(ForestryItem.beeComb, 1, 0)}, 80).setIgnobleShare(0.7f));
        this.forestDrops.add(new HiveDrop(BeeTemplates.getForestRainResistTemplate(), new ItemStack[]{new ItemStack(ForestryItem.beeComb, 1, 0)}, 8));
        this.forestDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), new ItemStack[]{new ItemStack(ForestryItem.beeComb, 1, 0)}, 3));
        this.meadowsDrops.add(new HiveDrop(BeeTemplates.getMeadowsTemplate(), new ItemStack[]{new ItemStack(ForestryItem.beeComb, 1, 0)}, 80).setIgnobleShare(0.7f));
        this.meadowsDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), new ItemStack[]{new ItemStack(ForestryItem.beeComb, 1, 0)}, 3));
        this.desertDrops.add(new HiveDrop(BeeTemplates.getModestTemplate(), new ItemStack[]{new ItemStack(ForestryItem.beeComb, 1, 7)}, 80).setIgnobleShare(0.7f));
        this.desertDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), new ItemStack[]{new ItemStack(ForestryItem.beeComb, 1, 7)}, 3));
        this.jungleDrops.add(new HiveDrop(BeeTemplates.getTropicalTemplate(), new ItemStack[]{new ItemStack(ForestryItem.beeComb, 1, 6)}, 80).setIgnobleShare(0.7f));
        this.jungleDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), new ItemStack[]{new ItemStack(ForestryItem.beeComb, 1, 6)}, 3));
        this.endDrops.add(new HiveDrop(BeeTemplates.getEnderTemplate(), new ItemStack[]{new ItemStack(ForestryItem.beeComb, 1, 8)}, 90));
        this.snowDrops.add(new HiveDrop(BeeTemplates.getWintryTemplate(), new ItemStack[]{new ItemStack(ForestryItem.beeComb, 1, 4)}, 80).setIgnobleShare(0.5f));
        this.snowDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), new ItemStack[]{new ItemStack(ForestryItem.beeComb, 1, 4)}, 3));
        this.swampDrops.add(new HiveDrop(BeeTemplates.getMarshyTemplate(), new ItemStack[]{new ItemStack(ForestryItem.beeComb, 1, 15)}, 80).setIgnobleShare(0.4f));
        this.swampDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), new ItemStack[]{new ItemStack(ForestryItem.beeComb, 1, 15)}, 3));
    }

    private void registerDungeonLoot() {
        int rarity = Config.dungeonLootRare ? 5 : 10;
        Bee bee = new Bee(beeInterface.templateAsGenome(BeeTemplates.getSteadfastTemplate()));
        ItemStack beeItem = new ItemStack(ForestryItem.beeDroneGE);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        bee.writeToNBT(nbttagcompound);
        beeItem.func_77982_d(nbttagcompound);
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(beeItem, 1, 1, rarity));
    }

    private void createHiveDropArrays() {
        BeeManager.hiveDrops = new ArrayList[8];
        this.forestDrops = new ArrayList();
        BeeManager.hiveDrops[0] = this.forestDrops;
        this.meadowsDrops = new ArrayList();
        BeeManager.hiveDrops[1] = this.meadowsDrops;
        this.desertDrops = new ArrayList();
        BeeManager.hiveDrops[2] = this.desertDrops;
        this.jungleDrops = new ArrayList();
        BeeManager.hiveDrops[3] = this.jungleDrops;
        this.endDrops = new ArrayList();
        BeeManager.hiveDrops[4] = this.endDrops;
        this.snowDrops = new ArrayList();
        BeeManager.hiveDrops[5] = this.snowDrops;
        this.swampDrops = new ArrayList();
        BeeManager.hiveDrops[6] = this.swampDrops;
        this.swarmDrops = new ArrayList();
        BeeManager.hiveDrops[7] = this.swarmDrops;
    }

    private void createAlleles() {
        IClassification hymnoptera = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "hymnoptera", "Hymnoptera");
        AlleleManager.alleleRegistry.getClassification("class.insecta").addMemberGroup(hymnoptera);
        IClassification apidae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "apidae", "Apidae");
        hymnoptera.addMemberGroup(apidae);
        BranchBees honey = new BranchBees("honey", "Apis");
        apidae.addMemberGroup(honey);
        BranchBees noble = new BranchBees("noble", "Probapis");
        apidae.addMemberGroup(noble);
        BranchBees industrious = new BranchBees("industrious", "Industrapis");
        apidae.addMemberGroup(industrious);
        BranchBees heroic = new BranchBees("heroic", "Herapis");
        apidae.addMemberGroup(heroic);
        BranchBees infernal = new BranchBees("infernal", "Diapis");
        apidae.addMemberGroup(infernal);
        BranchBees austere = new BranchBees("austere", "Modapis");
        apidae.addMemberGroup(austere);
        BranchBees end = new BranchBees("end", "Finapis");
        apidae.addMemberGroup(end);
        BranchBees vengeful = new BranchBees("vengeful", "Punapis");
        apidae.addMemberGroup(vengeful);
        BranchBees tropical = new BranchBees("tropical", "Caldapis");
        apidae.addMemberGroup(tropical);
        BranchBees frozen = new BranchBees("frozen", "Coagapis");
        apidae.addMemberGroup(frozen);
        BranchBees reddened = new BranchBees("reddened", "Rubapis");
        apidae.addMemberGroup(reddened);
        BranchBees festive = new BranchBees("festive", "Festapis");
        apidae.addMemberGroup(festive);
        BranchBees agrarian = new BranchBees("agrarian", "Rustapis");
        apidae.addMemberGroup(agrarian);
        BranchBees boggy = new BranchBees("boggy", "Paludapis");
        apidae.addMemberGroup(boggy);
        BranchBees monastic = new BranchBees("monastic", "Monapis");
        apidae.addMemberGroup(monastic);
        Allele.speciesForest = new AlleleBeeSpecies("speciesForest", true, "bees.species.forest", honey, "nigrocincta", 1691884, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 0), 30);
        Allele.speciesMeadows = new AlleleBeeSpecies("speciesMeadows", true, "bees.species.meadows", honey, "florea", 15667998, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 0), 30);
        Allele.speciesCommon = new AlleleBeeSpecies("speciesCommon", true, "bees.species.common", honey, "cerana", 0xB2B2B2, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 0), 35).setIsSecret();
        Allele.speciesCultivated = new AlleleBeeSpecies("speciesCultivated", true, "bees.species.cultivated", honey, "mellifera", 5715180, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 0), 40).setIsSecret();
        Allele.speciesNoble = new AlleleBeeSpecies("speciesNoble", false, "bees.species.noble", noble, "nobilis", 15505945, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 5), 20).setIsSecret();
        Allele.speciesMajestic = new AlleleBeeSpecies("speciesMajestic", true, "bees.species.majestic", noble, "regalis", 0x7F0000, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 5), 30).setIsSecret();
        Allele.speciesImperial = new AlleleBeeSpecies("speciesImperial", false, "bees.species.imperial", noble, "imperatorius", 10739759, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 5), 20).addProduct(new ItemStack(ForestryItem.royalJelly), 15).setHasEffect().setIsSecret();
        Allele.speciesDiligent = new AlleleBeeSpecies("speciesDiligent", false, "bees.species.diligent", industrious, "sedulus", 12720620, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 3), 20).setIsSecret();
        Allele.speciesUnweary = new AlleleBeeSpecies("speciesUnweary", true, "bees.species.unweary", industrious, "assiduus", 1698906, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 3), 30).setIsSecret();
        Allele.speciesIndustrious = new AlleleBeeSpecies("speciesIndustrious", false, "bees.species.industrious", industrious, "industria", 0xFFFFFF, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 3), 20).addProduct(new ItemStack(ForestryItem.pollen), 15).setHasEffect().setIsSecret();
        Allele.speciesSteadfast = new AlleleBeeSpecies("speciesSteadfast", false, "bees.species.steadfast", heroic, "legio", 5057301, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 1), 20).setIsSecret().setHasEffect();
        Allele.speciesValiant = new AlleleBeeSpecies("speciesValiant", true, "bees.species.valiant", heroic, "centurio", 6450141, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 1), 30).addSpecialty(new ItemStack(Item.field_77747_aY), 15).setIsSecret();
        Allele.speciesHeroic = new AlleleBeeSpecies("speciesHeroic", false, "bees.species.heroic", heroic, "kraphti", 11785700, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 1), 40).setIsSecret().setHasEffect();
        Allele.speciesSinister = new AlleleBeeSpecies("speciesSinister", false, "bees.species.sinister", infernal, "caecus", 11785700, 10101539).addProduct(new ItemStack(ForestryItem.beeComb, 1, 2), 45).setEntityTexture("sinisterBee").setIsSecret().setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        Allele.speciesFiendish = new AlleleBeeSpecies("speciesFiendish", true, "bees.species.fiendish", infernal, "diabolus", 14139109, 10101539).addProduct(new ItemStack(ForestryItem.beeComb, 1, 2), 55).addProduct(new ItemStack(ForestryItem.ash), 15).setEntityTexture("sinisterBee").setIsSecret().setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        Allele.speciesDemonic = new AlleleBeeSpecies("speciesDemonic", false, "bees.species.demonic", infernal, "draco", 16049152, 10101539).addProduct(new ItemStack(ForestryItem.beeComb, 1, 2), 45).addProduct(new ItemStack(Item.field_77751_aT), 15).setEntityTexture("sinisterBee").setHasEffect().setIsSecret().setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        Allele.speciesModest = new AlleleBeeSpecies("speciesModest", false, "bees.species.modest", austere, "modicus", 12959366, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 7), 20).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        Allele.speciesFrugal = new AlleleBeeSpecies("speciesFrugal", true, "bees.species.frugal", austere, "permodestus", 15260849, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 7), 30).setIsSecret().setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        Allele.speciesAustere = new AlleleBeeSpecies("speciesAustere", false, "bees.species.austere", austere, "correpere", 16775874, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 7), 20).addSpecialty(new ItemStack(ForestryItem.beeComb, 1, 10), 50).setHasEffect().setIsSecret().setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        Allele.speciesTropical = new AlleleBeeSpecies("speciesTropical", false, "bees.species.tropical", tropical, "mendelia", 3637280, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 6), 20).setEntityTexture("tropicalBee").setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        Allele.speciesExotic = new AlleleBeeSpecies("speciesExotic", true, "bees.species.exotic", tropical, "darwini", 3164419, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 6), 30).setEntityTexture("tropicalBee").setIsSecret().setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        Allele.speciesEdenic = new AlleleBeeSpecies("speciesEdenic", false, "bees.species.edenic", tropical, "humboldti", 3751181, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 6), 20).setEntityTexture("tropicalBee").setHasEffect().setIsSecret().setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        Allele.speciesEnded = new AlleleBeeSpecies("speciesEnded", false, "bees.species.ender", end, "notchi", 14711290, 0xD9DE9E).addProduct(new ItemStack(ForestryItem.beeComb, 1, 8), 30).setEntityTexture("endBee").setIsSecret().setTemperature(EnumTemperature.COLD);
        Allele.speciesSpectral = new AlleleBeeSpecies("speciesSpectral", true, "bees.species.spectral", end, "idolum", 11111405, 0xD9DE9E).addProduct(new ItemStack(ForestryItem.beeComb, 1, 8), 50).setEntityTexture("endBee").setIsSecret().setTemperature(EnumTemperature.COLD);
        Allele.speciesPhantasmal = new AlleleBeeSpecies("speciesPhantasmal", false, "bees.species.phantasmal", end, "lemur", 13369594, 0xD9DE9E).addProduct(new ItemStack(ForestryItem.beeComb, 1, 8), 40).setEntityTexture("endBee").setIsSecret().setHasEffect().setTemperature(EnumTemperature.COLD);
        Allele.speciesWintry = new AlleleBeeSpecies("speciesWintry", false, "bees.species.wintry", frozen, "brumalis", 10551240, 14349811).addProduct(new ItemStack(ForestryItem.beeComb, 1, 4), 30).setEntityTexture("icyBee").setTemperature(EnumTemperature.ICY);
        Allele.speciesIcy = new AlleleBeeSpecies("speciesIcy", true, "bees.species.icy", frozen, "coagulis", 0xA0FFFF, 14349811).addProduct(new ItemStack(ForestryItem.beeComb, 1, 4), 20).setEntityTexture("icyBee").addProduct(new ItemStack(ForestryItem.craftingMaterial, 1, 5), 20).setTemperature(EnumTemperature.ICY).setIsSecret();
        Allele.speciesGlacial = new AlleleBeeSpecies("speciesGlacial", false, "bees.species.glacial", frozen, "glacialis", 0xEFFFFF, 14349811).addProduct(new ItemStack(ForestryItem.beeComb, 1, 4), 20).setEntityTexture("icyBee").addProduct(new ItemStack(ForestryItem.craftingMaterial, 1, 5), 40).setTemperature(EnumTemperature.ICY).setHasEffect().setIsSecret();
        Allele.speciesVindictive = new AlleleBeeSpecies("speciesVindictive", false, "bees.species.vindictive", vengeful, "ultio", 15400947, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 9), 25).setIsSecret().setIsNotCounted();
        Allele.speciesVengeful = new AlleleBeeSpecies("speciesVengeful", false, "bees.species.vengeful", vengeful, "punire", 12770816, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 9), 40).setIsSecret().setIsNotCounted();
        Allele.speciesAvenging = new AlleleBeeSpecies("speciesAvenging", false, "bees.species.avenging", vengeful, "hostimentum", 0xDDFF00, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 9), 40).setIsSecret().setHasEffect().setIsNotCounted();
        Allele.speciesDarkened = new AlleleBeeSpecies("speciesDarkened", false, "bees.species.darkened", reddened, "pahimas", 14139109, 2494249).addProduct(new ItemStack(ForestryItem.beeComb, 1, 0), 100).addSpecialty(new ItemStack(ForestryItem.beeComb, 1, 12), 100).setJubilanceProvider(new JubilanceNone()).setIsSecret().setIsNotCounted();
        AlleleManager.alleleRegistry.blacklistAllele(Allele.speciesDarkened.getUID());
        Allele.speciesReddened = new AlleleBeeSpecies("speciesReddened", false, "bees.species.reddened", reddened, "xenophos", 16302529, 2494249).addProduct(new ItemStack(ForestryItem.beeComb, 1, 0), 100).addSpecialty(new ItemStack(ForestryItem.beeComb, 1, 11), 100).setJubilanceProvider(new JubilanceNone()).setIsSecret().setIsNotCounted();
        AlleleManager.alleleRegistry.blacklistAllele(Allele.speciesReddened.getUID());
        Allele.speciesOmega = new AlleleBeeSpecies("speciesOmega", false, "bees.species.omega", reddened, "slopokis", 0xFEFF8F, 2494249).addProduct(new ItemStack(ForestryItem.beeComb, 1, 0), 100).addSpecialty(new ItemStack(ForestryItem.beeComb, 1, 13), 100).setJubilanceProvider(new JubilanceNone()).setIsSecret().setIsNotCounted();
        AlleleManager.alleleRegistry.blacklistAllele(Allele.speciesOmega.getUID());
        Allele.speciesLeporine = new AlleleBeeSpecies("speciesLeporine", false, "bees.species.leporine", festive, "lepus", 0xFEFF8F, 3987287).addProduct(new ItemStack(ForestryItem.beeComb, 1, 6), 30).addProduct(new ItemStack(Item.field_77764_aP), 10).setIsSecret().setIsNotCounted().setHasEffect();
        Allele.speciesMerry = new AlleleBeeSpecies("speciesMerry", false, "bees.species.merry", festive, "feliciter", 0xFFFFFF, 0xD40000).addProduct(new ItemStack(ForestryItem.beeComb, 1, 4), 30).addProduct(new ItemStack(ForestryItem.craftingMaterial, 1, 5), 20).setTemperature(EnumTemperature.ICY).setIsSecret().setIsNotCounted().setHasEffect();
        Allele.speciesTipsy = new AlleleBeeSpecies("speciesTipsy", false, "bees.species.tipsy", festive, "ebrius", 0xFFFFFF, 12720620).addProduct(new ItemStack(ForestryItem.beeComb, 1, 4), 30).addProduct(new ItemStack(ForestryItem.craftingMaterial, 1, 5), 20).setTemperature(EnumTemperature.ICY).setIsSecret().setIsNotCounted().setHasEffect();
        Allele.speciesTricky = new AlleleBeeSpecies("speciesTricky", false, "bees.species.tricky", festive, "libita", 4800827, 16738816).addProduct(new ItemStack(ForestryItem.beeComb, 1, 0), 40).addProduct(new ItemStack(Item.field_77743_bc), 15).addSpecialty(new ItemStack(Item.field_82799_bQ, 1, 0), 2).addSpecialty(new ItemStack(Item.field_82799_bQ, 1, 2), 2).addSpecialty(new ItemStack(Item.field_82799_bQ, 1, 3), 2).addSpecialty(new ItemStack(Item.field_82799_bQ, 1, 4), 2).setIsNotCounted().setHasEffect();
        Allele.speciesRural = new AlleleBeeSpecies("speciesRural", false, "bees.species.rural", agrarian, "rustico", 0xFEFF8F, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 14), 20).setIsSecret();
        Allele.speciesMarshy = new AlleleBeeSpecies("speciesMarshy", true, "bees.species.marshy", boggy, "adorasti", 5531174, 16768022).addProduct(new ItemStack(ForestryItem.beeComb, 1, 15), 30).setHumidity(EnumHumidity.DAMP);
        Allele.speciesMonastic = new AlleleBeeSpecies("speciesMonastic", false, "bees.species.monastic", monastic, "monachus", 4339484, 16775094).addProduct(new ItemStack(ForestryItem.beeComb, 1, 14), 30).addSpecialty(new ItemStack(ForestryItem.beeComb, 1, 16), 10).setJubilanceProvider(new JubilanceProviderHermit()).setIsSecret();
        Allele.speciesSecluded = new AlleleBeeSpecies("speciesSecluded", true, "bees.species.secluded", monastic, "contractus", 8087092, 16775094).addSpecialty(new ItemStack(ForestryItem.beeComb, 1, 16), 20).setJubilanceProvider(new JubilanceProviderHermit()).setIsSecret();
        Allele.speciesHermitic = new AlleleBeeSpecies("speciesHermitic", false, "bees.species.hermitic", monastic, "anachoreta", 16766060, 16775094).addSpecialty(new ItemStack(ForestryItem.beeComb, 1, 16), 20).setJubilanceProvider(new JubilanceProviderHermit()).setHasEffect().setIsSecret();
        Allele.flowersVanilla = new AlleleFlowers("flowersVanilla", new FlowerProviderVanilla(), true);
        Allele.flowersNether = new AlleleFlowers("flowersNether", new FlowerProviderNetherwart());
        Allele.flowersCacti = new AlleleFlowers("flowersCacti", new FlowerProviderCacti());
        Allele.flowersMushrooms = new AlleleFlowers("flowersMushrooms", new FlowerProviderMushroom());
        Allele.flowersEnd = new AlleleFlowers("flowersEnd", new FlowerProviderEnd());
        Allele.flowersJungle = new AlleleFlowers("flowersJungle", new FlowerProviderJungle());
        Allele.flowersSnow = new AlleleFlowers("flowersSnow", new FlowerProviderVanilla(), true);
        Allele.flowersWheat = new AlleleFlowers("flowersWheat", new FlowerProviderWheat(), true);
        Allele.flowersGourd = new AlleleFlowers("flowersGourd", new FlowerProviderGourd(), true);
        Allele.effectNone = new AlleleEffectNone("effectNone");
        Allele.effectAggressive = new AlleleEffectAggressive("effectAggressive");
        Allele.effectHeroic = new AlleleEffectHeroic("effectHeroic");
        Allele.effectBeatific = new AlleleEffectPotion("effectBeatific", "beatific", false, Potion.field_76428_l, 100, true);
        Allele.effectMiasmic = new AlleleEffectMiasmic("effectMiasmic");
        Allele.effectMisanthrope = new AlleleEffectMisanthrope("effectMisanthrope");
        Allele.effectGlacial = new AlleleEffectGlacial("effectGlacial");
        Allele.effectRadioactive = new AlleleEffectRadioactive("effectRadioactive");
        Allele.effectCreeper = new AlleleEffectCreeper("effectCreeper");
        Allele.effectIgnition = new AlleleEffectIgnition("effectIgnition");
        Allele.effectExploration = new AlleleEffectExploration("effectExploration");
        Allele.effectFestiveEaster = new AlleleEffectNone("effectFestiveEaster");
        Allele.effectSnowing = new AlleleEffectSnowing("effectSnowing");
        Allele.effectDrunkard = new AlleleEffectPotion("effectDrunkard", "drunkard", false, Potion.field_76431_k, 100, false);
        Allele.effectReanimation = new AlleleEffectResurrection("effectReanimation", "reanimation", AlleleEffectResurrection.getReanimationList());
        Allele.effectResurrection = new AlleleEffectResurrection("effectResurrection", "resurrection", AlleleEffectResurrection.getResurrectionList());
        Allele.effectRepulsion = new AlleleEffectRepulsion("effectRepulsion");
    }

    private void createMutations() {
        BeeTemplates.commonA = new BeeMutation(Allele.speciesForest, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonB = new BeeMutation(Allele.speciesModest, Allele.speciesForest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonC = new BeeMutation(Allele.speciesModest, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonD = new BeeMutation(Allele.speciesWintry, Allele.speciesForest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonE = new BeeMutation(Allele.speciesWintry, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonF = new BeeMutation(Allele.speciesWintry, Allele.speciesModest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonG = new BeeMutation(Allele.speciesTropical, Allele.speciesForest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonH = new BeeMutation(Allele.speciesTropical, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonI = new BeeMutation(Allele.speciesTropical, Allele.speciesModest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonJ = new BeeMutation(Allele.speciesTropical, Allele.speciesWintry, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonK = new BeeMutation(Allele.speciesMarshy, Allele.speciesForest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonL = new BeeMutation(Allele.speciesMarshy, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonM = new BeeMutation(Allele.speciesMarshy, Allele.speciesModest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonN = new BeeMutation(Allele.speciesMarshy, Allele.speciesWintry, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonO = new BeeMutation(Allele.speciesMarshy, Allele.speciesTropical, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.cultivatedA = new BeeMutation(Allele.speciesCommon, Allele.speciesForest, BeeTemplates.getCultivatedTemplate(), 12);
        BeeTemplates.cultivatedB = new BeeMutation(Allele.speciesCommon, Allele.speciesMeadows, BeeTemplates.getCultivatedTemplate(), 12);
        BeeTemplates.cultivatedC = new BeeMutation(Allele.speciesCommon, Allele.speciesModest, BeeTemplates.getCultivatedTemplate(), 12);
        BeeTemplates.cultivatedD = new BeeMutation(Allele.speciesCommon, Allele.speciesWintry, BeeTemplates.getCultivatedTemplate(), 12);
        BeeTemplates.cultivatedE = new BeeMutation(Allele.speciesCommon, Allele.speciesTropical, BeeTemplates.getCultivatedTemplate(), 12);
        BeeTemplates.cultivatedF = new BeeMutation(Allele.speciesCommon, Allele.speciesMarshy, BeeTemplates.getCultivatedTemplate(), 12);
        BeeTemplates.nobleA = new BeeMutation(Allele.speciesCommon, Allele.speciesCultivated, BeeTemplates.getNobleTemplate(), 10);
        BeeTemplates.majesticA = new BeeMutation(Allele.speciesNoble, Allele.speciesCultivated, BeeTemplates.getMajesticTemplate(), 8);
        BeeTemplates.imperialA = new BeeMutation(Allele.speciesNoble, Allele.speciesMajestic, BeeTemplates.getImperialTemplate(), 8);
        BeeTemplates.diligentA = new BeeMutation(Allele.speciesCommon, Allele.speciesCultivated, BeeTemplates.getDiligentTemplate(), 10);
        BeeTemplates.unwearyA = new BeeMutation(Allele.speciesDiligent, Allele.speciesCultivated, BeeTemplates.getUnwearyTemplate(), 8);
        BeeTemplates.industriousA = new BeeMutation(Allele.speciesDiligent, Allele.speciesUnweary, BeeTemplates.getIndustriousTemplate(), 8);
        BeeTemplates.heroicA = new BeeMutation(Allele.speciesSteadfast, Allele.speciesValiant, BeeTemplates.getHeroicTemplate(), 6).restrictBiomeType(BiomeDictionary.Type.FOREST).enableStrictBiomeCheck();
        BeeTemplates.sinisterA = new BeeMutation(Allele.speciesModest, Allele.speciesCultivated, BeeTemplates.getSinisterTemplate(), 60).restrictBiomeType(BiomeDictionary.Type.NETHER);
        BeeTemplates.sinisterB = new BeeMutation(Allele.speciesTropical, Allele.speciesCultivated, BeeTemplates.getSinisterTemplate(), 60).restrictBiomeType(BiomeDictionary.Type.NETHER);
        BeeTemplates.fiendishA = new BeeMutation(Allele.speciesSinister, Allele.speciesCultivated, BeeTemplates.getFiendishTemplate(), 40).restrictBiomeType(BiomeDictionary.Type.NETHER);
        BeeTemplates.fiendishB = new BeeMutation(Allele.speciesSinister, Allele.speciesModest, BeeTemplates.getFiendishTemplate(), 40).restrictBiomeType(BiomeDictionary.Type.NETHER);
        BeeTemplates.fiendishC = new BeeMutation(Allele.speciesSinister, Allele.speciesTropical, BeeTemplates.getFiendishTemplate(), 40).restrictBiomeType(BiomeDictionary.Type.NETHER);
        BeeTemplates.demonicA = new BeeMutation(Allele.speciesSinister, Allele.speciesFiendish, BeeTemplates.getDemonicTemplate(), 25).restrictBiomeType(BiomeDictionary.Type.NETHER);
        BeeTemplates.frugalA = new BeeMutation(Allele.speciesModest, Allele.speciesSinister, BeeTemplates.getFrugalTemplate(), 16).setTemperatureRainfall(1.9f, 2.0f, 0.0f, 0.1f);
        BeeTemplates.frugalB = new BeeMutation(Allele.speciesModest, Allele.speciesFiendish, BeeTemplates.getFrugalTemplate(), 10).setTemperatureRainfall(1.9f, 2.0f, 0.0f, 0.1f);
        BeeTemplates.austereA = new BeeMutation(Allele.speciesModest, Allele.speciesFrugal, BeeTemplates.getAustereTemplate(), 8).setTemperatureRainfall(1.9f, 2.0f, 0.0f, 0.1f);
        BeeTemplates.exoticA = new BeeMutation(Allele.speciesAustere, Allele.speciesTropical, BeeTemplates.getExoticTemplate(), 12);
        BeeTemplates.edenicA = new BeeMutation(Allele.speciesExotic, Allele.speciesTropical, BeeTemplates.getEdenicTemplate(), 8);
        BeeTemplates.icyA = new BeeMutation(Allele.speciesIndustrious, Allele.speciesWintry, BeeTemplates.getIcyTemplate(), 12).setTemperature(0.0f, 0.15f);
        BeeTemplates.glacialA = new BeeMutation(Allele.speciesIcy, Allele.speciesWintry, BeeTemplates.getGlacialTemplate(), 8).setTemperature(0.0f, 0.15f);
        BeeTemplates.leporineA = new MutationTimeLimited(Allele.speciesMeadows, Allele.speciesForest, BeeTemplates.getLeporineTemplate(), 10, new MutationTimeLimited.DayMonth(29, 3), new MutationTimeLimited.DayMonth(15, 4)).setIsSecret();
        BeeTemplates.merryA = new MutationTimeLimited(Allele.speciesWintry, Allele.speciesForest, BeeTemplates.getMerryTemplate(), 10, new MutationTimeLimited.DayMonth(21, 12), new MutationTimeLimited.DayMonth(27, 12)).setIsSecret();
        BeeTemplates.tipsyA = new MutationTimeLimited(Allele.speciesWintry, Allele.speciesMeadows, BeeTemplates.getTipsyTemplate(), 10, new MutationTimeLimited.DayMonth(27, 12), new MutationTimeLimited.DayMonth(2, 1)).setIsSecret();
        BeeTemplates.trickyA = new MutationTimeLimited(Allele.speciesSinister, Allele.speciesCommon, BeeTemplates.getTrickyTemplate(), 10, new MutationTimeLimited.DayMonth(15, 10), new MutationTimeLimited.DayMonth(3, 11)).setIsSecret();
        BeeTemplates.ruralA = new BeeMutation(Allele.speciesMeadows, Allele.speciesDiligent, BeeTemplates.getRuralTemplate(), 12).restrictBiomeType(BiomeDictionary.Type.PLAINS).enableStrictBiomeCheck();
        BeeTemplates.secludedA = new BeeMutation(Allele.speciesMonastic, Allele.speciesAustere, BeeTemplates.getSecludedTemplate(), 12);
        BeeTemplates.hermiticA = new BeeMutation(Allele.speciesMonastic, Allele.speciesSecluded, BeeTemplates.getHermiticTemplate(), 8);
        BeeTemplates.spectralA = new BeeMutation(Allele.speciesHermitic, Allele.speciesEnded, BeeTemplates.getSpectralTemplate(), 4);
        BeeTemplates.phantasmalA = new BeeMutation(Allele.speciesSpectral, Allele.speciesEnded, BeeTemplates.getPhantasmalTemplate(), 2);
        BeeTemplates.vindictiveA = new BeeMutation(Allele.speciesMonastic, Allele.speciesDemonic, BeeTemplates.getVindictiveTemplate(), 4).setIsSecret();
        BeeTemplates.vengefulA = new BeeMutation(Allele.speciesDemonic, Allele.speciesVindictive, BeeTemplates.getVengefulTemplate(), 8).setIsSecret();
        BeeTemplates.vengefulB = new BeeMutation(Allele.speciesMonastic, Allele.speciesVindictive, BeeTemplates.getVengefulTemplate(), 8).setIsSecret();
        BeeTemplates.avengingA = new BeeMutation(Allele.speciesVengeful, Allele.speciesVindictive, BeeTemplates.getAvengingTemplate(), 4);
    }

    private void registerTemplates() {
        beeInterface.registerTemplate(BeeTemplates.getForestTemplate());
        beeInterface.registerTemplate(BeeTemplates.getMeadowsTemplate());
        beeInterface.registerTemplate(BeeTemplates.getCommonTemplate());
        beeInterface.registerTemplate(BeeTemplates.getCultivatedTemplate());
        beeInterface.registerTemplate(BeeTemplates.getNobleTemplate());
        beeInterface.registerTemplate(BeeTemplates.getMajesticTemplate());
        beeInterface.registerTemplate(BeeTemplates.getImperialTemplate());
        beeInterface.registerTemplate(BeeTemplates.getDiligentTemplate());
        beeInterface.registerTemplate(BeeTemplates.getUnwearyTemplate());
        beeInterface.registerTemplate(BeeTemplates.getIndustriousTemplate());
        beeInterface.registerTemplate(BeeTemplates.getSteadfastTemplate());
        beeInterface.registerTemplate(BeeTemplates.getValiantTemplate());
        beeInterface.registerTemplate(BeeTemplates.getHeroicTemplate());
        beeInterface.registerTemplate(BeeTemplates.getSinisterTemplate());
        beeInterface.registerTemplate(BeeTemplates.getFiendishTemplate());
        beeInterface.registerTemplate(BeeTemplates.getDemonicTemplate());
        beeInterface.registerTemplate(BeeTemplates.getModestTemplate());
        beeInterface.registerTemplate(BeeTemplates.getFrugalTemplate());
        beeInterface.registerTemplate(BeeTemplates.getAustereTemplate());
        beeInterface.registerTemplate(BeeTemplates.getTropicalTemplate());
        beeInterface.registerTemplate(BeeTemplates.getExoticTemplate());
        beeInterface.registerTemplate(BeeTemplates.getEdenicTemplate());
        beeInterface.registerTemplate(BeeTemplates.getWintryTemplate());
        beeInterface.registerTemplate(BeeTemplates.getIcyTemplate());
        beeInterface.registerTemplate(BeeTemplates.getGlacialTemplate());
        beeInterface.registerTemplate(BeeTemplates.getVindictiveTemplate());
        beeInterface.registerTemplate(BeeTemplates.getVengefulTemplate());
        beeInterface.registerTemplate(BeeTemplates.getAvengingTemplate());
        beeInterface.registerTemplate(BeeTemplates.getDarkenedTemplate());
        beeInterface.registerTemplate(BeeTemplates.getReddenedTemplate());
        beeInterface.registerTemplate(BeeTemplates.getOmegaTemplate());
        beeInterface.registerTemplate(BeeTemplates.getRuralTemplate());
        beeInterface.registerTemplate(BeeTemplates.getLeporineTemplate());
        beeInterface.registerTemplate(BeeTemplates.getMerryTemplate());
        beeInterface.registerTemplate(BeeTemplates.getTipsyTemplate());
        beeInterface.registerTemplate(BeeTemplates.getTrickyTemplate());
        beeInterface.registerTemplate(BeeTemplates.getMarshyTemplate());
        beeInterface.registerTemplate(BeeTemplates.getMonasticTemplate());
        beeInterface.registerTemplate(BeeTemplates.getSecludedTemplate());
        beeInterface.registerTemplate(BeeTemplates.getHermiticTemplate());
        beeInterface.registerTemplate(BeeTemplates.getEnderTemplate());
        beeInterface.registerTemplate(BeeTemplates.getSpectralTemplate());
        beeInterface.registerTemplate(BeeTemplates.getPhantasmalTemplate());
    }

    private void parseAdditionalFlowers(String list, ArrayList target) {
        String[] items;
        for (String item : items = list.split("[;]+")) {
            if (item.isEmpty()) continue;
            String[] ident = item.split("[:]+");
            int id = 0;
            int meta = 0;
            if (ident.length > 1) {
                id = Integer.parseInt(ident[0]);
                meta = Integer.parseInt(ident[1]);
            } else {
                id = Integer.parseInt(ident[0]);
            }
            if (id <= 0) continue;
            if (id < Block.field_71973_m.length && Block.field_71973_m[id] != null || Item.field_77698_e[id] != null) {
                Proxies.log.finer("Adding flower of (" + id + ":" + meta + ") to vanilla flower provider.");
                target.add(new ItemStack(id, 1, meta));
                continue;
            }
            Proxies.log.warning("Failed to add flower of (" + id + ":" + meta + ") to vanilla flower provider since it was null.");
        }
    }

    private void parseBeeBlacklist(String list) {
        String[] items;
        for (String item : items = list.split("[;]+")) {
            if (item.isEmpty()) continue;
            FMLCommonHandler.instance().getFMLLogger().finer("Blacklisting bee species identified by " + item);
            AlleleManager.alleleRegistry.blacklistAllele(item);
        }
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerApiculture();
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }

    @Override
    public ICommand[] getConsoleCommands() {
        return new ICommand[]{new CommandBeekeepingMode(), new CommandGiveBee(EnumBeeType.DRONE), new CommandGiveBee(EnumBeeType.PRINCESS), new CommandGiveBee(EnumBeeType.QUEEN)};
    }

    static {
        beekeepingMode = "NORMAL";
        beeCycleTicks = 550;
        apiarySideSensitive = false;
        fancyRenderedBees = false;
    }
}

