/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gui;

import forestry.core.gui.ContainerForestry;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.Widget;
import forestry.core.gui.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import forestry.factory.gadgets.TileWorktable;
import forestry.factory.gui.ContainerWorktable;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiWorktable
extends GuiForestry {
    protected ContainerWorktable container;
    private final ItemStack bookSymbol = new ItemStack(Item.field_77760_aL);

    public GuiWorktable(EntityPlayer player, TileWorktable tile) {
        super("textures/gui/worktable.png", (ContainerForestry)new ContainerWorktable(player, tile));
        this.field_74195_c = 218;
        this.tile = tile;
        this.container = (ContainerWorktable)this.field_74193_d;
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 146, 20, tile, 0));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 146, 38, tile, 1));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 146, 56, tile, 2));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 128, 56, tile, 3));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 110, 56, tile, 4));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 110, 38, tile, 5));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 110, 20, tile, 6));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 128, 20, tile, 7));
    }

    @Override
    protected void func_74189_g(int mouseX, int mouseY) {
        super.func_74189_g(mouseX, mouseY);
        String name = StringUtil.localize("tile.for." + this.tile.func_70303_b());
        this.field_73886_k.func_78276_b(name, this.getCenteredOffset(name), 6, this.fontColor.get("gui.title"));
    }

    @Override
    protected void func_74185_a(float var1, int mouseX, int mouseY) {
        super.func_74185_a(var1, mouseX, mouseY);
        this.drawItemStack(this.bookSymbol, this.field_74198_m + 128, this.field_74197_n + 38);
    }

    private static class MemorizedSlot
    extends Widget {
        TileWorktable tile;
        int slotNumber;

        public MemorizedSlot(WidgetManager manager, int xPos, int yPos, TileWorktable tile, int slot) {
            super(manager, xPos, yPos);
            this.tile = tile;
            this.slotNumber = slot;
        }

        private ItemStack getOutputStack() {
            return this.tile.getMemory().getRecipeOutput(this.slotNumber);
        }

        @Override
        public void draw(int startX, int startY) {
            ItemStack output = this.getOutputStack();
            if (output == null) {
                return;
            }
            GL11.glPushAttrib((int)8192);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            RenderHelper.func_74520_c();
            int short1 = 240;
            int short2 = 240;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)short1 / 1.0f), (float)((float)short2 / 1.0f));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.manager.gui.drawItemStack(output, startX + this.xPos, startY + this.yPos);
            if (this.tile.getMemory().isLocked(this.slotNumber)) {
                this.manager.gui.setZLevel(110.0f);
                Proxies.common.bindTexture(SpriteSheet.ITEMS);
                this.manager.gui.func_94065_a(startX + this.xPos, startY + this.yPos, TextureManager.getInstance().getDefault("slots/locked"), 16, 16);
                this.manager.gui.setZLevel(0.0f);
            }
            GL11.glPopAttrib();
        }

        @Override
        protected String getTooltip(EntityPlayer player) {
            ItemStack output = this.getOutputStack();
            return output != null ? output.func_82833_r() : null;
        }

        @Override
        public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            ((GuiWorktable)this.manager.gui).container.sendRecipeClick(mouseButton, this.slotNumber);
        }
    }
}

