/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.power.PowerHandler;
import forestry.api.core.ForestryAPI;
import forestry.api.recipes.ICarpenterManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.Defaults;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.items.ItemCrated;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.core.utils.StackUtils;
import forestry.core.utils.TankSlot;
import forestry.core.utils.TileInventoryAdapter;
import forestry.core.utils.Utils;
import forestry.factory.gui.ContainerCarpenter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MachineCarpenter
extends TilePowered
implements ISpecialInventory,
ISidedInventory,
ILiquidTankContainer {
    public static final int SLOT_CRAFTING_1 = 0;
    public static final int SLOT_BOX = 9;
    public static final int SLOT_PRODUCT = 10;
    public static final int SLOT_CAN_INPUT = 11;
    public static final short SLOT_INVENTORY_1 = 12;
    public static final short SLOT_INVENTORY_COUNT = 18;
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    private TileInventoryAdapter craftingInventory;
    private TileInventoryAdapter accessibleInventory;
    public Recipe currentRecipe;
    public ContainerCarpenter activeContainer;
    private int packageTime;
    private int totalTime;
    private ItemStack currentProduct;
    private ItemStack pendingProduct;

    public ItemStack getBoxStack() {
        return this.accessibleInventory.func_70301_a(9);
    }

    public MachineCarpenter() {
        this.setHints((String[])Config.hints.get("carpenter"));
        this.craftingInventory = new TileInventoryAdapter(this, 10, "CraftItems");
        this.accessibleInventory = (TileInventoryAdapter)new TileInventoryAdapter(this, 30, "Items").configureSided(Defaults.FACINGS, 9, 20);
    }

    @Override
    public String func_70303_b() {
        return "factory.1";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.CarpenterGUI.ordinal(), player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    protected void configurePowerProvider(PowerHandler provider) {
        provider.configure(50.0f, 110.0f, 5.0f, 400.0f);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("PackageTime", this.packageTime);
        nbttagcompound.func_74768_a("PackageTotalTime", this.totalTime);
        NBTTagCompound NBTresourceSlot = new NBTTagCompound();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.func_74782_a("ResourceTank", (NBTBase)NBTresourceSlot);
        this.craftingInventory.writeToNBT(nbttagcompound);
        this.accessibleInventory.writeToNBT(nbttagcompound);
        if (this.pendingProduct != null) {
            NBTTagCompound nbttagcompoundP = new NBTTagCompound();
            this.pendingProduct.func_77955_b(nbttagcompoundP);
            nbttagcompound.func_74782_a("PendingProduct", (NBTBase)nbttagcompoundP);
        }
        if (this.currentProduct != null) {
            NBTTagCompound nbttagcompoundC = new NBTTagCompound();
            this.currentProduct.func_77955_b(nbttagcompoundC);
            nbttagcompound.func_74782_a("CurrentProduct", (NBTBase)nbttagcompoundC);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbttagcompoundP;
        super.func_70307_a(nbttagcompound);
        this.packageTime = nbttagcompound.func_74762_e("PackageTime");
        this.totalTime = nbttagcompound.func_74762_e("PackageTotalTime");
        this.resourceTank = new TankSlot(10000);
        if (nbttagcompound.func_74764_b("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.func_74775_l("ResourceTank"));
        }
        if (nbttagcompound.func_74764_b("CraftItems")) {
            this.craftingInventory.readFromNBT(nbttagcompound);
        } else {
            NBTTagList nbttaglist = nbttagcompound.func_74761_m("Items");
            for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbttaglist.func_74743_b(j);
                byte index = nbttagcompound2.func_74771_c("Slot");
                if (index >= 9) continue;
                this.craftingInventory.func_70299_a(index, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound2));
            }
        }
        this.accessibleInventory.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("PendingProduct")) {
            nbttagcompoundP = nbttagcompound.func_74775_l("PendingProduct");
            this.pendingProduct = ItemStack.func_77949_a((NBTTagCompound)nbttagcompoundP);
        }
        if (nbttagcompound.func_74764_b("CurrentProduct")) {
            nbttagcompoundP = nbttagcompound.func_74775_l("CurrentProduct");
            this.currentProduct = ItemStack.func_77949_a((NBTTagCompound)nbttagcompoundP);
        }
        ContainerCarpenter container = new ContainerCarpenter(this);
        this.currentRecipe = RecipeManager.findMatchingRecipe(this.resourceTank.getFluid(), this.getBoxStack(), container.craftMatrix, this.field_70331_k);
    }

    @Override
    public void updateServerSide() {
        Object container;
        if (this.field_70331_k.func_82737_E() % 20L * 10L != 0L) {
            return;
        }
        if (this.accessibleInventory.func_70301_a(11) != null && (container = LiquidHelper.getLiquidContainer(this.accessibleInventory.func_70301_a(11))) != null && RecipeManager.isResourceLiquid(container.fluid)) {
            this.accessibleInventory.func_70299_a(11, StackUtils.replenishByContainer(this, this.accessibleInventory.func_70301_a(11), container, this.resourceTank));
            if (this.accessibleInventory.func_70301_a((int)11).field_77994_a <= 0) {
                this.accessibleInventory.func_70299_a(11, null);
            }
        }
        if (this.field_70331_k.func_82737_E() % 40L * 10L != 0L) {
            return;
        }
        if (this.currentRecipe == null) {
            container = new ContainerCarpenter(this);
            this.currentRecipe = RecipeManager.findMatchingRecipe(this.resourceTank.getFluid(), this.getBoxStack(), container.craftMatrix, this.field_70331_k);
        }
        if (this.currentRecipe == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        } else if (!this.validateResources()) {
            this.setErrorState(EnumErrorCode.NORESOURCE);
        } else {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean workCycle() {
        if (this.packageTime > 0) {
            --this.packageTime;
            if (this.currentRecipe == null || !this.currentProduct.func_77969_a(this.currentRecipe.getCraftingResult()) || !this.validateResources()) {
                this.currentProduct = null;
                this.totalTime = 0;
                this.packageTime = 0;
                return false;
            }
            if (this.packageTime <= 0) {
                this.pendingProduct = this.currentProduct;
                this.currentProduct = null;
                this.totalTime = 0;
                this.removeResources(this.currentRecipe);
                if (this.activeContainer != null) {
                    this.activeContainer.updateProductDisplay();
                }
                return this.tryAddPending();
            }
            return true;
        }
        if (this.pendingProduct != null) {
            return this.tryAddPending();
        }
        if (this.currentRecipe != null) {
            if (!this.validateResources()) {
                return false;
            }
            this.packageTime = this.totalTime = this.currentRecipe.packagingTime;
            this.currentProduct = this.currentRecipe.getCraftingResult();
            if (this.activeContainer != null) {
                this.activeContainer.updateProductDisplay();
            }
            return true;
        }
        return false;
    }

    private boolean validateResources() {
        if (this.currentRecipe.liquid != null && this.resourceTank.getFluidAmount() < ((Recipe)this.currentRecipe).liquid.amount) {
            return false;
        }
        if (this.currentRecipe.box != null && this.accessibleInventory.func_70301_a(9) == null) {
            return false;
        }
        return StackUtils.containsSets(this.craftingInventory.getStacks(0, 9), this.accessibleInventory.getStacks(12, 18), null, true, false) > 0;
    }

    private void removeResources(Recipe recipe) {
        if (recipe.liquid != null) {
            this.resourceTank.drain(((Recipe)recipe).liquid.amount, true);
        }
        if (recipe.box != null) {
            this.accessibleInventory.func_70298_a(9, 1);
        }
        this.removeSets(1, this.craftingInventory.getStacks(0, 9));
    }

    private void removeSets(int count, ItemStack[] set) {
        for (int i = 0; i < count; ++i) {
            ItemStack[] condensedSet;
            for (ItemStack req : condensedSet = StackUtils.condenseStacks(set)) {
                for (int j = 12; j < 30; ++j) {
                    ItemStack pol = this.accessibleInventory.func_70301_a(j);
                    if (pol == null || !StackUtils.isCraftingEquivalent(pol, req, true, false)) continue;
                    ItemStack removed = this.accessibleInventory.func_70298_a(j, req.field_77994_a);
                    req.field_77994_a -= removed.field_77994_a;
                }
            }
        }
    }

    private boolean tryAddPending() {
        if (this.accessibleInventory.func_70301_a(10) == null) {
            this.accessibleInventory.func_70299_a(10, this.pendingProduct.func_77946_l());
            this.pendingProduct = null;
            return true;
        }
        if (this.accessibleInventory.func_70301_a(10).func_77969_a(this.pendingProduct) && this.accessibleInventory.func_70301_a((int)10).field_77994_a <= this.accessibleInventory.func_70301_a(10).func_77976_d() - this.pendingProduct.field_77994_a) {
            this.accessibleInventory.func_70301_a((int)10).field_77994_a += this.pendingProduct.field_77994_a;
            this.pendingProduct = null;
            return true;
        }
        this.setErrorState(EnumErrorCode.NOSPACE);
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.packageTime > 0 || this.pendingProduct != null || this.currentRecipe != null && this.validateResources();
    }

    @Override
    public boolean hasWork() {
        if (this.currentRecipe == null) {
            return false;
        }
        if (this.accessibleInventory.func_70301_a(10) != null && this.accessibleInventory.func_70301_a(10).func_77976_d() - this.accessibleInventory.func_70301_a((int)10).field_77994_a < this.currentRecipe.getCraftingResult().field_77994_a) {
            return false;
        }
        return this.validateResources();
    }

    public int getCraftingProgressScaled(int i) {
        if (this.totalTime == 0) {
            return 0;
        }
        return this.packageTime * i / this.totalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    public int func_70302_i_() {
        return this.accessibleInventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.accessibleInventory.func_70301_a(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.accessibleInventory.func_70299_a(i, itemstack);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.accessibleInventory.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int slot) {
        return this.accessibleInventory.func_70304_b(slot);
    }

    public int func_70297_j_() {
        return this.accessibleInventory.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.packageTime = j;
                break;
            }
            case 1: {
                this.totalTime = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.packageTime);
        iCrafting.func_71112_a(container, 1, this.totalTime);
    }

    @Override
    public InventoryAdapter getInternalInventory() {
        return this.accessibleInventory;
    }

    public InventoryAdapter getCraftingInventory() {
        return this.craftingInventory;
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex == 10;
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        if (slotIndex == 10) {
            return false;
        }
        if (slotIndex == 9) {
            return RecipeManager.isBox(itemstack);
        }
        if (slotIndex >= 12 && slotIndex < 30) {
            if (this.currentRecipe == null) {
                return false;
            }
            return this.currentRecipe.isIngredient(itemstack);
        }
        return false;
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        FluidContainerRegistry.FluidContainerData container = LiquidHelper.getLiquidContainer(stack);
        if (container != null && RecipeManager.isResourceLiquid(container.fluid)) {
            return this.accessibleInventory.addStack(stack, 11, 1, false, doAdd);
        }
        if (this.currentRecipe != null && this.currentRecipe.isIngredient(stack)) {
            return this.accessibleInventory.addStack(stack, 12, 18, false, doAdd);
        }
        if (RecipeManager.isBox(stack)) {
            return this.accessibleInventory.addStack(stack, 9, 1, false, doAdd);
        }
        return 0;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        if (this.accessibleInventory.func_70301_a(10) == null) {
            return new ItemStack[0];
        }
        if (this.accessibleInventory.func_70301_a((int)10).field_77994_a <= 0) {
            return new ItemStack[0];
        }
        ItemStack product = new ItemStack(this.accessibleInventory.func_70301_a((int)10).field_77993_c, 1, this.accessibleInventory.func_70301_a(10).func_77960_j());
        if (doRemove) {
            this.accessibleInventory.func_70298_a(10, 1);
        }
        return new ItemStack[]{product};
    }

    @Override
    public int fill(ForgeDirection direction, FluidStack resource, boolean doFill) {
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public TankSlot[] getTanks() {
        return new TankSlot[]{this.resourceTank};
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static class RecipeManager
    implements ICarpenterManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addCrating(ItemStack itemStack) {
            ItemStack uncrated = ((ItemCrated)itemStack.func_77973_b()).getContained(itemStack);
            this.addRecipe(5, LiquidHelper.getLiquid("water", 100), new ItemStack(ForestryItem.crate), itemStack, new Object[]{"###", "###", "###", Character.valueOf('#'), uncrated});
            this.addRecipe(null, new ItemStack(uncrated.field_77993_c, 9, uncrated.func_77960_j()), new Object[]{"#", Character.valueOf('#'), itemStack});
        }

        @Override
        public void addCrating(String toCrate, ItemStack unpack, ItemStack crated) {
            this.addRecipe(5, LiquidHelper.getLiquid("water", 100), new ItemStack(ForestryItem.crate), crated, new Object[]{"###", "###", "###", Character.valueOf('#'), toCrate});
            this.addRecipe(null, new ItemStack(unpack.field_77993_c, 9, unpack.func_77960_j()), new Object[]{"#", Character.valueOf('#'), crated});
        }

        @Override
        public void addRecipe(ItemStack box, ItemStack product, Object[] materials) {
            this.addRecipe(5, null, box, product, materials);
        }

        @Override
        public void addRecipe(int packagingTime, ItemStack box, ItemStack product, Object[] materials) {
            this.addRecipe(packagingTime, null, box, product, materials);
        }

        @Override
        public void addRecipe(int packagingTime, FluidStack liquid, ItemStack box, ItemStack product, Object[] materials) {
            recipes.add(new Recipe(packagingTime, liquid, box, ShapedRecipeCustom.createShapedRecipe(materials, product)));
        }

        public static Recipe findMatchingRecipe(FluidStack liquid, ItemStack item, InventoryCrafting inventorycrafting, World world) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(liquid, item, inventorycrafting, world)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isResourceLiquid(FluidStack liquid) {
            for (Recipe recipe : recipes) {
                if (!recipe.hasLiquid(liquid)) continue;
                return true;
            }
            return false;
        }

        public static boolean isBox(ItemStack resource) {
            for (Recipe recipe : recipes) {
                if (!recipe.hasBox(resource)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Map getRecipes() {
            HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(recipe.internal.getIngredients(), new Object[]{recipe.getCraftingResult()});
            }
            return recipeList;
        }
    }

    public static class Recipe {
        private int packagingTime;
        private FluidStack liquid;
        private ItemStack box;
        private ShapedRecipeCustom internal;

        public Recipe(int packagingTime, FluidStack liquid, ItemStack box, ShapedRecipeCustom internal) {
            this.packagingTime = packagingTime;
            this.liquid = liquid;
            this.box = box;
            this.internal = internal;
        }

        public ItemStack getCraftingResult() {
            return this.internal.func_77571_b();
        }

        public boolean matches(FluidStack resource, ItemStack item, InventoryCrafting inventorycrafting, World world) {
            if (this.liquid != null && resource == null) {
                return false;
            }
            if (this.liquid != null && !this.liquid.isFluidEqual(resource)) {
                return false;
            }
            if (this.box != null && item == null) {
                return false;
            }
            if (this.box != null && !this.box.func_77969_a(item)) {
                return false;
            }
            return this.internal.func_77569_a(inventorycrafting, world);
        }

        public boolean hasLiquid(FluidStack resource) {
            if (this.liquid != null && resource != null) {
                return this.liquid.isFluidEqual(resource);
            }
            return false;
        }

        public boolean hasBox(ItemStack resource) {
            if (this.box == null && resource == null) {
                return true;
            }
            if (this.box == null) {
                return true;
            }
            if (this.box.func_77960_j() > 0) {
                return this.box.func_77969_a(resource);
            }
            return this.box.field_77993_c == resource.field_77993_c;
        }

        public boolean isIngredient(ItemStack resource) {
            return this.internal.isIngredient(resource);
        }

        public ItemStack getBox() {
            return this.box;
        }

        public FluidStack getLiquid() {
            return this.liquid;
        }

        public IRecipe asIRecipe() {
            return this.internal;
        }
    }
}

