/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.config.Config;
import forestry.core.utils.Vect;

public class Schemata {
    private final String uid;
    private EnumStructureBlock[][][] structure;
    private int width;
    private int height;
    private int depth;
    private int xOffset;
    private int yOffset;
    private int zOffset = -1;

    public Schemata(String uid, int width, int height, int depth, String ... patterns) {
        this(uid, width, height, depth);
        this.setStructure(patterns);
    }

    public Schemata(String uid, int width, int height, int depth) {
        this.uid = uid;
        this.structure = new EnumStructureBlock[width][height][depth];
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    private void setStructure(String ... patterns) {
        String fullpattern = "";
        for (String pattern : patterns) {
            fullpattern = fullpattern + pattern;
        }
        if (fullpattern.length() != this.getWidth() * this.getHeight() * this.getDepth()) {
            throw new RuntimeException("Incorrect pattern " + fullpattern + " (" + fullpattern.length() + ") for (" + this.getWidth() + "/" + this.getHeight() + "/" + this.getDepth() + ")");
        }
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                block3: for (int k = 0; k < this.getDepth(); ++k) {
                    for (EnumStructureBlock type : EnumStructureBlock.values()) {
                        if (type.getKey() != fullpattern.charAt(i * this.getHeight() * this.getDepth() + j * this.getDepth() + k)) continue;
                        this.structure[i][j][k] = type;
                        continue block3;
                    }
                }
            }
        }
    }

    public Schemata setOffsets(int xOffset, int yOffset, int zOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        return this;
    }

    public EnumStructureBlock getAt(int x, int y, int z, boolean rotate) {
        if (rotate) {
            return this.structure[z][y][x];
        }
        return this.structure[x][y][z];
    }

    public Vect getDimensions(boolean rotate) {
        if (rotate) {
            return new Vect(this.getDepth(), this.getHeight(), this.getWidth());
        }
        return new Vect(this.getWidth(), this.getHeight(), this.getDepth());
    }

    public boolean isEnabled() {
        return !Config.disabledStructures.contains(this.uid);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getxOffset() {
        return this.xOffset;
    }

    public int getyOffset() {
        return this.yOffset;
    }

    public int getzOffset() {
        return this.zOffset;
    }

    public static enum EnumStructureBlock {
        ANY('X'),
        FOREIGN('F'),
        AIR('O'),
        MASTER('M'),
        GLASS('G'),
        BLOCK_A('A'),
        BLOCK_B('B'),
        BLOCK_C('C'),
        BLOCK_D('D'),
        BLOCK_E('E');

        private char key;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private EnumStructureBlock() {
            void key;
            this.key = key;
        }

        public char getKey() {
            return this.key;
        }
    }
}

