/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.circuits.ISolderingIron;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.gui.ContainerSocketed;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.Widget;
import forestry.core.gui.WidgetManager;
import forestry.core.interfaces.ISocketable;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class SocketSlot
extends Widget {
    ISocketable tile;
    int slot = 0;

    public SocketSlot(WidgetManager manager, int xPos, int yPos, ISocketable tile, int slot) {
        super(manager, xPos, yPos);
        this.tile = tile;
        this.slot = slot;
    }

    @Override
    public void draw(int startX, int startY) {
        ItemStack socketStack = this.tile.getSocket(this.slot);
        if (socketStack != null) {
            GuiForestry.getItemRenderer().func_77015_a(this.manager.minecraft.field_71466_p, this.manager.minecraft.field_71446_o, socketStack, startX + this.xPos, startY + this.yPos);
        }
    }

    @Override
    protected String getTooltip(EntityPlayer player) {
        ItemStack stack = this.tile.getSocket(this.slot);
        if (stack != null) {
            return (String)stack.func_82840_a(player, false).get(0);
        }
        return StringUtil.localize("gui.emptysocket");
    }

    @Override
    protected void addInformation(ArrayList list, EntityPlayer player) {
        if (this.tile.getSocket(this.slot) != null) {
            this.tile.getSocket(this.slot).func_77973_b().func_77624_a(this.tile.getSocket(this.slot), player, (List)list, false);
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        ItemStack itemstack = this.manager.minecraft.field_71439_g.field_71071_by.func_70445_o();
        if (itemstack == null) {
            return;
        }
        Item held = itemstack.func_77973_b();
        if (held instanceof ItemCircuitBoard) {
            ((ContainerSocketed)this.manager.gui.field_74193_d).handleChipsetClick(this.slot, (EntityPlayer)this.manager.minecraft.field_71439_g, itemstack);
        } else if (held instanceof ISolderingIron) {
            ((ContainerSocketed)this.manager.gui.field_74193_d).handleSolderingIronClick(this.slot, (EntityPlayer)this.manager.minecraft.field_71439_g, itemstack);
        }
    }
}

