/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gadgets.NaturalistGame;
import forestry.core.gadgets.TileEscritoire;
import forestry.core.gui.ContainerEscritoire;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.Widget;
import forestry.core.gui.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.core.render.TextureManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiEscritoire
extends GuiForestry {
    private static String[][] researchNotes = new String[][]{{"I have found a curious specimen on my travels.", "This strange fellow needs further investigation.", "Elated, I wanted to start at once with my research."}, {"I was amazed at the wondrous nature of it.", "The specimen twitched, while I inspected it more closely.", "Strange markings on the underside made me curious.", "This will be the talk of the society when I am done investigating."}, {"After some prodding I discovered an interesting new lead.", "I scratched my head at this discovery and questioned everything.", "I thought my eyes deceived me, but there it was.", "A previously unseen dot led me to question the specimen's classification."}, {"My screams of frustration had the housekeeper look into my study in worry.", "In a frenzy and on the verge of despair, I ripped up all the notes!", "This... just doesn't make any sense!", "It just cannot be. It didn't do that before!", "The sledgehammer barely made a dent, so I sent for the chainsaw.", "I swear it was looking at me, with its beady, cruel, little eyes.", "Is that laughter? Do I hear laughter? Who is laughing here?"}, {"EUREKA!", "Wondrous! My name will go down in history!", "My colleagues will be impressed!", "I will be the envy of everyone at the society!", "Woot!"}, {"All is lost.", "I consign my notes to the fire.", "Why? I had made such great strides at first...", "Failed. Again.", "Oh my..."}};
    private final ItemStack LEVEL_ITEM = new ItemStack(Item.field_77759_aK);
    protected ContainerEscritoire container;
    private TileEscritoire tile;
    private String researchNote = "";
    private long lastUpdate;

    public GuiEscritoire(EntityPlayer player, TileEscritoire tile) {
        super("textures/gui/escritoire.png", (ContainerForestry)new ContainerEscritoire(player, tile));
        this.field_74194_b = 228;
        this.field_74195_c = 235;
        this.container = (ContainerEscritoire)this.field_74193_d;
        this.tile = tile;
        this.widgetManager.add(new TokenSlot(this.widgetManager, 115, 51, tile, 0));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 115, 77, tile, 1));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 94, 90, tile, 2));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 73, 77, tile, 3));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 73, 51, tile, 4));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 94, 38, tile, 5));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 115, 25, tile, 6));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 136, 38, tile, 7));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 136, 64, tile, 8));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 136, 90, tile, 9));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 115, 103, tile, 10));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 94, 116, tile, 11));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 73, 103, tile, 12));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 52, 90, tile, 13));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 52, 64, tile, 14));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 52, 38, tile, 15));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 73, 25, tile, 16));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 94, 12, tile, 17));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 52, 12, tile, 18));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 136, 12, tile, 19));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 52, 116, tile, 20));
        this.widgetManager.add(new TokenSlot(this.widgetManager, 136, 116, tile, 21));
    }

    @Override
    protected void func_74185_a(float var1, int mouseX, int mouseY) {
        super.func_74185_a(var1, mouseX, mouseY);
        for (int i = 0; i <= this.tile.getGame().getBountyLevel() / 4; ++i) {
            RenderHelper.func_74520_c();
            GuiForestry.field_74196_a.func_82406_b(this.field_73882_e.field_71466_p, this.field_73882_e.field_71446_o, this.LEVEL_ITEM, this.field_74198_m + 170 + i * 8, this.field_74197_n + 7);
            RenderHelper.func_74518_a();
        }
        this.startPage();
        this.setFactor(0.5f);
        this.newLine();
        this.newLine();
        this.drawLine("\u00a7n\u00a7oAttempt No. " + (16 - this.tile.getGame().getBountyLevel()), 171, this.fontColor.get("gui.mail.lettertext"));
        this.newLine();
        this.drawSplitLine(this.getResearchNote(), 171, 46, this.fontColor.get("gui.mail.lettertext"));
        this.endPage();
    }

    private String getResearchNote() {
        int bounty;
        if (this.lastUpdate == this.tile.getGame().getLastUpdate()) {
            return this.researchNote;
        }
        this.researchNote = !this.tile.getGame().isInited() ? "" : (this.tile.getGame().isWon() ? this.getRandomNote(researchNotes[4]) : (this.tile.getGame().isEnded() ? this.getRandomNote(researchNotes[5]) : ((bounty = this.tile.getGame().getBountyLevel()) >= 16 ? this.getRandomNote(researchNotes[0]) : (bounty > 8 ? this.getRandomNote(researchNotes[1]) : (bounty > 4 ? this.getRandomNote(researchNotes[2]) : this.getRandomNote(researchNotes[3]))))));
        this.lastUpdate = this.tile.getGame().getLastUpdate();
        return this.researchNote;
    }

    private String getRandomNote(String[] candidates) {
        return candidates[this.field_73882_e.field_71441_e.field_73012_v.nextInt(candidates.length)];
    }

    private static class TokenSlot
    extends Widget {
        private final ItemStack HIDDEN_TOKEN;
        private TileEscritoire tile;
        private int index;

        public TokenSlot(WidgetManager manager, int xPos, int yPos, TileEscritoire tile, int index) {
            super(manager, xPos, yPos);
            this.tile = tile;
            this.index = index;
            this.HIDDEN_TOKEN = new ItemStack(Item.field_77760_aL);
        }

        private boolean hasToken() {
            return this.tile.getGame().getToken(this.index) != null;
        }

        private NaturalistGame.GameToken getToken() {
            return this.tile.getGame().getToken(this.index);
        }

        @Override
        public void draw(int startX, int startY) {
            if (!this.hasToken()) {
                return;
            }
            int tokenColour = this.getToken().getTokenColour();
            float colorR = (float)(tokenColour >> 16 & 0xFF) / 255.0f;
            float colorG = (float)(tokenColour >> 8 & 0xFF) / 255.0f;
            float colorB = (float)(tokenColour & 0xFF) / 255.0f;
            this.manager.gui.bindTexture(this.manager.gui.textureFile);
            GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
            this.manager.gui.func_73729_b(startX + this.xPos, startY + this.yPos, 228, 0, 22, 22);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ItemStack tokenStack = this.HIDDEN_TOKEN;
            if (this.getToken().isVisible()) {
                tokenStack = this.getToken().tokenStack;
            }
            RenderHelper.func_74520_c();
            this.manager.gui.drawItemStack(tokenStack, startX + this.xPos + 3, startY + this.yPos + 3);
            RenderHelper.func_74518_a();
            this.manager.gui.setZLevel(150.0f);
            for (String ident : this.getToken().getOverlayIcons()) {
                RenderHelper.func_74520_c();
                Proxies.common.bindTexture(SpriteSheet.ITEMS);
                this.manager.gui.func_94065_a(startX + this.xPos + 3, startY + this.yPos + 3, TextureManager.getInstance().getDefault(ident), 16, 16);
                RenderHelper.func_74518_a();
            }
            this.manager.gui.setZLevel(0.0f);
        }

        @Override
        protected String getTooltip(EntityPlayer player) {
            return this.hasToken() && this.getToken().isVisible() ? this.getToken().getTooltip() : null;
        }

        @Override
        public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            ((GuiEscritoire)this.manager.gui).container.sendTokenClick(this.index);
        }
    }
}

