/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.gadgets.TileForestry;
import forestry.core.interfaces.IBlockRenderer;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class MachineDefinition {
    public final Class teClass;
    public final String teIdent;
    public final int blockID;
    public final int meta;
    public final IBlockRenderer renderer;
    public IRecipe[] recipes;
    private int[] faceMap;
    @SideOnly(value=Side.CLIENT)
    private Icon[] icons;

    public MachineDefinition(int blockID, int meta, String teIdent, Class teClass, IRecipe ... recipes) {
        this(blockID, meta, teIdent, teClass, (IBlockRenderer)null, recipes);
    }

    public MachineDefinition(int blockID, int meta, String teIdent, Class teClass, IBlockRenderer renderer, IRecipe ... recipes) {
        this.blockID = blockID;
        this.meta = meta;
        this.teIdent = teIdent;
        this.teClass = teClass;
        this.renderer = renderer;
        this.recipes = recipes;
        this.faceMap = new int[8];
        for (int i = 0; i < 8; ++i) {
            this.faceMap[i] = 0;
        }
    }

    public void register() {
        this.registerTileEntity();
        this.registerCrafting();
        if (this.renderer != null) {
            Proxies.render.registerTESR(this);
        }
    }

    private void registerCrafting() {
        for (IRecipe recipe : this.recipes) {
            if (recipe == null) continue;
            CraftingManager.func_77594_a().func_77592_b().add(recipe);
        }
    }

    private void registerTileEntity() {
        GameRegistry.registerTileEntity((Class)this.teClass, (String)this.teIdent);
    }

    public TileEntity createMachine() {
        try {
            return (TileEntity)this.teClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to instantiate tile entity of class " + this.teClass.getName());
        }
    }

    public void getSubBlocks(int id, CreativeTabs tab, List list) {
        list.add(new ItemStack(this.blockID, 1, this.meta));
    }

    public boolean handlesDrops() {
        return false;
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList();
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float fXplayerClick, float fY, float fZ) {
        return false;
    }

    public void onBlockAdded(World world, int x, int y, int z) {
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        return false;
    }

    public MachineDefinition setFaces(int ... faces) {
        if (faces.length > 6) {
            for (int i = 0; i < faces.length; ++i) {
                this.faceMap[i] = faces[i];
            }
        } else {
            for (int i = 0; i < 6; ++i) {
                this.faceMap[i] = faces[i];
            }
            this.faceMap[6] = faces[0];
            this.faceMap[7] = faces[1];
        }
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister register) {
        this.icons = new Icon[8];
        for (int i = 0; i < 8; ++i) {
            this.icons[i] = TextureManager.getInstance().registerTex(register, this.teIdent.replace("forestry.", "").toLowerCase(Locale.ENGLISH) + "." + this.faceMap[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getBlockTextureFromSideAndMetadata(int side, int metadata) {
        return this.icons[side];
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getBlockTexture(IBlockAccess world, int x, int y, int z, int side, int metadata) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileForestry)) {
            return this.getBlockTextureFromSideAndMetadata(side, metadata);
        }
        ForgeDirection dir = ((TileForestry)tile).getOrientation();
        switch (dir) {
            case WEST: {
                side = side == 2 ? 4 : (side == 3 ? 5 : (side == 4 ? 3 : (side == 5 ? 2 : (side == 0 ? 6 : 7))));
                break;
            }
            case EAST: {
                side = side == 2 ? 5 : (side == 3 ? 4 : (side == 4 ? 2 : (side == 5 ? 3 : (side == 0 ? 6 : 7))));
                break;
            }
            case SOUTH: {
                break;
            }
            case NORTH: {
                side = side == 2 ? 3 : (side == 3 ? 2 : (side == 4 ? 5 : (side == 5 ? 4 : side)));
                break;
            }
        }
        return this.getBlockTextureFromSideAndMetadata(side, metadata);
    }
}

