/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.api.core.ITileStructure;
import forestry.core.gadgets.BlockForestry;
import forestry.core.gadgets.TileForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class BlockStructure
extends BlockForestry {
    public BlockStructure(int i, Material material) {
        super(i, material);
        this.func_71848_c(1.0f);
    }

    public boolean func_71906_q_() {
        return false;
    }

    @Override
    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        ITileStructure central;
        ITileStructure tile = (ITileStructure)world.func_72796_p(x, y, z);
        super.func_71852_a(world, x, y, z, par5, par6);
        if (tile.isIntegratedIntoStructure() && !tile.isMaster() && (central = tile.getCentralTE()) != null) {
            central.validateStructure();
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (player.func_70093_af()) {
            return false;
        }
        TileForestry tile = (TileForestry)world.func_72796_p(x, y, z);
        if (!tile.func_70300_a(player)) {
            return false;
        }
        if (!Proxies.common.isSimulating(world)) {
            return false;
        }
        if (tile instanceof ITileStructure && !((ITileStructure)((Object)tile)).isIntegratedIntoStructure()) {
            return false;
        }
        if (tile.allowsInteraction(player)) {
            tile.openGui(player);
        } else {
            player.func_71035_c("\u00a7c" + tile.getOwnerName() + " " + StringUtil.localize("chat.accesslocked"));
        }
        return true;
    }

    public void func_71863_a(World world, int x, int y, int z, int neighbourBlockId) {
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof ITileStructure)) {
            return;
        }
        ((ITileStructure)tile).validateStructure();
    }

    public static enum EnumStructureState {
        VALID,
        INVALID,
        INDETERMINATE;

    }
}

