/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.CreativeTabForestry;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;

public class BlockSoil
extends Block {
    private int degradeDelimiter = 3;
    @SideOnly(value=Side.CLIENT)
    private Icon iconHumus;
    @SideOnly(value=Side.CLIENT)
    private Icon iconBogEarth;
    @SideOnly(value=Side.CLIENT)
    private Icon iconPeat;

    public BlockSoil(int i) {
        super(i, Material.field_76251_o);
        this.func_71907_b(true);
        this.func_71848_c(0.5f);
        this.func_71884_a(field_71965_g);
        this.func_71849_a(CreativeTabForestry.tabForestry);
    }

    public int func_71859_p_(World world) {
        return 500;
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int type = metadata & 3;
        int maturity = metadata >> 2;
        if (maturity >= this.degradeDelimiter && type == 1) {
            ret.add(new ItemStack(ForestryItem.peat));
            ret.add(new ItemStack(Block.field_71979_v));
        } else if (type == 0) {
            ret.add(new ItemStack(Block.field_71979_v));
        } else {
            ret.add(new ItemStack((Block)this, 1, type));
        }
        return ret;
    }

    public int func_71873_h(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) & 3;
    }

    public void func_71847_b(World world, int i, int j, int k, Random random) {
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        int meta = world.func_72805_g(i, j, k);
        int type = meta & 3;
        if (type == 0) {
            this.updateTickHumus(world, i, j, k, random);
        } else if (type == 1) {
            this.updateTickBogEarth(world, i, j, k, random);
        } else {
            Proxies.log.warning(((Object)((Object)this)).getClass() + " with unknown type " + type + " encountered.");
        }
    }

    private void updateTickHumus(World world, int i, int j, int k, Random random) {
        if (this.isEnrooted(world, i, j, k)) {
            this.degradeSoil(world, i, j, k);
        }
    }

    private void updateTickBogEarth(World world, int i, int j, int k, Random random) {
        if (BlockSoil.isMoistened(world, i, j, k)) {
            this.matureBog(world, i, j, k);
        }
    }

    private boolean isEnrooted(World world, int x, int y, int z) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                int blockid = world.func_72798_a(x + i, y + 1, z + j);
                if (blockid != Block.field_71951_J.field_71990_ca && blockid != Block.field_71987_y.field_71990_ca && blockid != ForestryBlock.saplingGE.field_71990_ca) continue;
                return i != 0 || j != 0;
            }
        }
        return false;
    }

    private void degradeSoil(World world, int i, int j, int k) {
        if (world.field_73012_v.nextInt(140) != 0) {
            return;
        }
        int meta = world.func_72805_g(i, j, k);
        int type = meta & 3;
        int grade = meta >> 2;
        meta = ++grade << 2 | type;
        if (grade >= this.degradeDelimiter) {
            world.func_72832_d(i, j, k, Block.field_71939_E.field_71990_ca, 0, 2);
        } else {
            world.func_72921_c(i, j, k, meta, 2);
        }
        world.func_72845_h(i, j, k);
    }

    public static boolean isMoistened(World world, int x, int y, int z) {
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                int blockid = world.func_72798_a(x + i, y, z + j);
                if (blockid != Block.field_71943_B.field_71990_ca && blockid != Block.field_71942_A.field_71990_ca) continue;
                return true;
            }
        }
        return false;
    }

    private void matureBog(World world, int i, int j, int k) {
        if (world.field_73012_v.nextInt(13) != 0) {
            return;
        }
        int meta = world.func_72805_g(i, j, k);
        int type = meta & 3;
        int maturity = meta >> 2;
        if (maturity >= this.degradeDelimiter) {
            return;
        }
        meta = ++maturity << 2 | type;
        world.func_72921_c(i, j, k, meta, 2);
        world.func_72845_h(i, j, k);
    }

    public boolean canSustainPlant(World world, int x, int y, int z, ForgeDirection direction, IPlantable plant) {
        EnumPlantType plantType = plant.getPlantType(world, x, y, z);
        if (plantType != EnumPlantType.Crop && plantType != EnumPlantType.Plains) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        return (meta & 3) == 0;
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(new ItemStack((Block)this, 1, 0));
        itemList.add(new ItemStack((Block)this, 1, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        this.iconHumus = TextureManager.getInstance().registerTex(register, "soil/humus");
        this.iconBogEarth = TextureManager.getInstance().registerTex(register, "soil/bog");
        this.iconPeat = TextureManager.getInstance().registerTex(register, "soil/peat");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int i, int j) {
        int meta = j;
        int type = meta & 3;
        int maturity = meta >> 2;
        if (type == 1) {
            if (maturity < this.degradeDelimiter) {
                return this.iconBogEarth;
            }
            return this.iconPeat;
        }
        return this.iconHumus;
    }
}

