/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.FlowerManager;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IPlugin;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.fuels.RainSubstrate;
import forestry.core.EventHandlerCore;
import forestry.core.GameMode;
import forestry.core.GuiHandler;
import forestry.core.WorldGenerator;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.config.Version;
import forestry.core.gadgets.TileEngine;
import forestry.core.gadgets.TileMachine;
import forestry.core.gadgets.TileMill;
import forestry.core.proxy.Proxies;
import forestry.core.utils.LiquidHelper;
import forestry.plugins.NativePlugin;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginManager;
import java.io.File;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;

public class ForestryCore {
    public void preInit(File modLocation, Object basemod) {
        ForestryAPI.instance = basemod;
        PluginManager.loadPlugins(modLocation);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerCore());
        Config.load();
        if (!Config.disableVersionCheck) {
            Version.versionCheck();
        }
        for (IPlugin plugin : PluginManager.plugins) {
            if (!(plugin instanceof PluginCore)) continue;
            plugin.preInit();
        }
        for (IPlugin plugin : PluginManager.plugins) {
            if (plugin instanceof PluginCore) continue;
            if (plugin.isAvailable()) {
                plugin.preInit();
                continue;
            }
            Proxies.log.fine("Skipped plugin " + plugin.getClass() + " because preconditions were not met.");
        }
    }

    public void init(Object basemod) {
        this.registerLiquidContainers();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenerator());
        FuelManager.fermenterFuel.put(new ItemStack(ForestryItem.fertilizerCompound), new FermenterFuel(new ItemStack(ForestryItem.fertilizerCompound), GameMode.getGameMode().getIntegerSetting("fermenter.value.fertilizer"), GameMode.getGameMode().getIntegerSetting("fermenter.cycles.fertilizer")));
        FuelManager.fermenterFuel.put(new ItemStack(ForestryItem.fertilizerBio), new FermenterFuel(new ItemStack(ForestryItem.fertilizerBio), GameMode.getGameMode().getIntegerSetting("fermenter.value.compost"), GameMode.getGameMode().getIntegerSetting("fermenter.cycles.compost")));
        FuelManager.fermenterFuel.put(new ItemStack(ForestryItem.mulch), new FermenterFuel(new ItemStack(ForestryItem.mulch), GameMode.getGameMode().getIntegerSetting("fermenter.value.compost"), GameMode.getGameMode().getIntegerSetting("fermenter.cycles.compost")));
        FuelManager.moistenerResource.put(new ItemStack(Item.field_77685_T), new MoistenerFuel(new ItemStack(Item.field_77685_T), new ItemStack(ForestryItem.mouldyWheat), 0, 300));
        FuelManager.moistenerResource.put(new ItemStack(ForestryItem.mouldyWheat), new MoistenerFuel(new ItemStack(ForestryItem.mouldyWheat), new ItemStack(ForestryItem.decayingWheat), 1, 600));
        FuelManager.moistenerResource.put(new ItemStack(ForestryItem.decayingWheat), new MoistenerFuel(new ItemStack(ForestryItem.decayingWheat), new ItemStack(ForestryItem.mulch), 2, 900));
        FuelManager.copperEngineFuel.put(new ItemStack(ForestryItem.peat), new EngineCopperFuel(new ItemStack(ForestryItem.peat), 1, 5000));
        FuelManager.copperEngineFuel.put(new ItemStack(ForestryItem.bituminousPeat), new EngineCopperFuel(new ItemStack(ForestryItem.bituminousPeat), 2, 6000));
        FuelManager.bronzeEngineFuel.put(LiquidHelper.getFluid("biomass"), new EngineBronzeFuel(LiquidHelper.getFluid("biomass"), 5, (int)(2500.0f * GameMode.getGameMode().getFloatSetting("fuel.biomass.biogas")), 1));
        FuelManager.bronzeEngineFuel.put(LiquidHelper.getFluid("water"), new EngineBronzeFuel(LiquidHelper.getFluid("water"), 1, 1000, 3));
        FuelManager.bronzeEngineFuel.put(LiquidHelper.getFluid("milk"), new EngineBronzeFuel(LiquidHelper.getFluid("milk"), 1, 10000, 3));
        FuelManager.bronzeEngineFuel.put(LiquidHelper.getFluid("seedoil"), new EngineBronzeFuel(LiquidHelper.getFluid("seedoil"), 3, 2500, 1));
        FuelManager.bronzeEngineFuel.put(LiquidHelper.getFluid("honey"), new EngineBronzeFuel(LiquidHelper.getFluid("honey"), 2, 2500, 1));
        FuelManager.bronzeEngineFuel.put(LiquidHelper.getFluid("juice"), new EngineBronzeFuel(LiquidHelper.getFluid("juice"), 1, 2500, 1));
        FuelManager.rainSubstrate.put(new ItemStack(ForestryItem.iodineCharge), new RainSubstrate(new ItemStack(ForestryItem.iodineCharge), 10000, 0.01f));
        FuelManager.rainSubstrate.put(new ItemStack(ForestryItem.craftingMaterial, 1, 4), new RainSubstrate(new ItemStack(ForestryItem.craftingMaterial, 1, 4), 0.075f));
        FlowerManager.plainFlowers.add(new ItemStack((Block)Block.field_72107_ae));
        FlowerManager.plainFlowers.add(new ItemStack((Block)Block.field_72097_ad));
        NetworkRegistry.instance().registerGuiHandler(basemod, (IGuiHandler)new GuiHandler());
        GameRegistry.registerTileEntity(TileMill.class, (String)"forestry.Grower");
        GameRegistry.registerTileEntity(TileEngine.class, (String)"forestry.Engine");
        GameRegistry.registerTileEntity(TileMachine.class, (String)"forestry.Machine");
    }

    public void postInit() {
        for (IPlugin plugin : PluginManager.plugins) {
            if (!plugin.isAvailable()) continue;
            plugin.doInit();
        }
        for (IPlugin plugin : PluginManager.plugins) {
            if (!plugin.isAvailable()) continue;
            plugin.postInit();
        }
        Proxies.common.registerTickHandlers();
        this.processIMCMessages(FMLInterModComms.fetchRuntimeMessages((Object)ForestryAPI.instance));
    }

    public void serverStarting(MinecraftServer server) {
        CommandHandler commandManager = (CommandHandler)server.func_71187_D();
        for (IPlugin plugin : PluginManager.plugins) {
            ICommand[] commands;
            if (!plugin.isAvailable() || !(plugin instanceof NativePlugin) || (commands = ((NativePlugin)plugin).getConsoleCommands()) == null) continue;
            for (ICommand command : commands) {
                commandManager.func_71560_a(command);
            }
        }
    }

    public void processIMCMessages(ImmutableList messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            IPlugin plugin;
            Iterator i$ = PluginManager.plugins.iterator();
            while (!(!i$.hasNext() || (plugin = (IPlugin)i$.next()) instanceof NativePlugin && ((NativePlugin)plugin).processIMCMessage(message))) {
            }
        }
    }

    public String getPriorities() {
        return "after:mod_IC2;after:mod_BuildCraftCore;after:mod_BuildCraftEnergy;after:mod_BuildCraftFactory;after:mod_BuildCraftSilicon;after:mod_BuildCraftTransport;after:mod_RedPowerWorld";
    }

    private void registerLiquidContainers() {
        if (LiquidHelper.isEmptyLiquidData()) {
            LiquidHelper.injectLiquidContainer("lava", 1000, new ItemStack(Item.field_77775_ay), new ItemStack(Item.field_77788_aw));
            LiquidHelper.injectLiquidContainer("water", 1000, new ItemStack(Item.field_77786_ax), new ItemStack(Item.field_77788_aw));
        }
        LiquidHelper.getOrCreateLiquid("glass");
        LiquidHelper.getOrCreateLiquid("milk");
        LiquidHelper.injectLiquidContainer("milk", 1000, new ItemStack(Item.field_77771_aG), new ItemStack(Item.field_77788_aw));
        LiquidHelper.injectTinContainer("lava", 1000, new ItemStack(ForestryItem.canLava), new ItemStack(ForestryItem.canEmpty));
        LiquidHelper.injectRefractoryContainer("lava", 1000, new ItemStack(ForestryItem.refractoryLava), new ItemStack(ForestryItem.refractoryEmpty));
        LiquidHelper.injectLiquidContainer("water", 1000, new ItemStack((Item)Item.field_77726_bs, 1, 0), new ItemStack(Item.field_77729_bt));
        LiquidHelper.injectTinContainer("water", 1000, new ItemStack(ForestryItem.canWater), new ItemStack(ForestryItem.canEmpty));
        LiquidHelper.injectWaxContainer("water", 1000, new ItemStack(ForestryItem.waxCapsuleWater), new ItemStack(ForestryItem.waxCapsule));
        LiquidHelper.injectRefractoryContainer("water", 1000, new ItemStack(ForestryItem.refractoryWater), new ItemStack(ForestryItem.refractoryEmpty));
        LiquidHelper.getOrCreateLiquid("biomass");
        LiquidHelper.injectLiquidContainer("biomass", 1000, new ItemStack(ForestryItem.bucketBiomass), new ItemStack(Item.field_77788_aw));
        LiquidHelper.injectTinContainer("biomass", 1000, new ItemStack(ForestryItem.canBiomass), new ItemStack(ForestryItem.canEmpty));
        LiquidHelper.injectWaxContainer("biomass", 1000, new ItemStack(ForestryItem.waxCapsuleBiomass), new ItemStack(ForestryItem.waxCapsule));
        LiquidHelper.injectRefractoryContainer("biomass", 1000, new ItemStack(ForestryItem.refractoryBiomass), new ItemStack(ForestryItem.refractoryEmpty));
        LiquidHelper.getOrCreateLiquid("bioethanol");
        LiquidHelper.injectLiquidContainer("bioethanol", 1000, new ItemStack(ForestryItem.bucketBiofuel), new ItemStack(Item.field_77788_aw));
        LiquidHelper.injectTinContainer("bioethanol", 1000, new ItemStack(ForestryItem.canBiofuel), new ItemStack(ForestryItem.canEmpty));
        LiquidHelper.injectWaxContainer("bioethanol", 1000, new ItemStack(ForestryItem.waxCapsuleBiofuel), new ItemStack(ForestryItem.waxCapsule));
        LiquidHelper.injectRefractoryContainer("bioethanol", 1000, new ItemStack(ForestryItem.refractoryBiofuel), new ItemStack(ForestryItem.refractoryEmpty));
        FMLInterModComms.sendMessage((String)"Railcraft", (String)"boiler-fuel-liquid", (String)("bioethanol@" + (int)(8000.0f * GameMode.getGameMode().getFloatSetting("fuel.ethanol.boiler"))));
        LiquidHelper.getOrCreateLiquid("seedoil");
        LiquidHelper.injectTinContainer("seedoil", 1000, new ItemStack(ForestryItem.canSeedOil), new ItemStack(ForestryItem.canEmpty));
        LiquidHelper.injectWaxContainer("seedoil", 1000, new ItemStack(ForestryItem.waxCapsuleSeedOil), new ItemStack(ForestryItem.waxCapsule));
        LiquidHelper.injectRefractoryContainer("seedoil", 1000, new ItemStack(ForestryItem.refractorySeedOil), new ItemStack(ForestryItem.refractoryEmpty));
        LiquidHelper.getOrCreateLiquid("honey");
        LiquidHelper.injectTinContainer("honey", 1000, new ItemStack(ForestryItem.canHoney), new ItemStack(ForestryItem.canEmpty));
        LiquidHelper.injectWaxContainer("honey", 1000, new ItemStack(ForestryItem.waxCapsuleHoney), new ItemStack(ForestryItem.waxCapsule));
        LiquidHelper.injectRefractoryContainer("honey", 1000, new ItemStack(ForestryItem.refractoryHoney), new ItemStack(ForestryItem.refractoryEmpty));
        LiquidHelper.getOrCreateLiquid("juice");
        LiquidHelper.injectTinContainer("juice", 1000, new ItemStack(ForestryItem.canJuice), new ItemStack(ForestryItem.canEmpty));
        LiquidHelper.injectWaxContainer("juice", 1000, new ItemStack(ForestryItem.waxCapsuleJuice), new ItemStack(ForestryItem.waxCapsule));
        LiquidHelper.injectRefractoryContainer("juice", 1000, new ItemStack(ForestryItem.refractoryJuice), new ItemStack(ForestryItem.refractoryEmpty));
        LiquidHelper.getOrCreateLiquid("ice");
        LiquidHelper.injectTinContainer("ice", 1000, new ItemStack(ForestryItem.canIce), new ItemStack(ForestryItem.canEmpty));
        LiquidHelper.injectWaxContainer("ice", 1000, new ItemStack(ForestryItem.waxCapsuleIce), new ItemStack(ForestryItem.waxCapsule));
        LiquidHelper.injectRefractoryContainer("ice", 1000, new ItemStack(ForestryItem.refractoryIce), new ItemStack(ForestryItem.refractoryEmpty));
    }
}

