/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import forestry.api.arboriculture.ITree;
import forestry.arboriculture.genetics.Tree;
import forestry.core.interfaces.IOwnable;
import forestry.core.network.ForestryPacket;
import forestry.core.network.INetworkedEntity;
import forestry.core.network.PacketTileNBT;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumAccess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;

public abstract class TileTreeContainer
extends TileEntity
implements INetworkedEntity,
IOwnable {
    private ITree containedTree;
    public String owner = null;

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("ContainedTree")) {
            this.containedTree = new Tree(nbttagcompound.func_74775_l("ContainedTree"));
        }
        if (nbttagcompound.func_74764_b("Owner")) {
            this.owner = nbttagcompound.func_74779_i("Owner");
        }
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        if (this.containedTree != null) {
            NBTTagCompound subcompound = new NBTTagCompound();
            this.containedTree.writeToNBT(subcompound);
            nbttagcompound.func_74766_a("ContainedTree", subcompound);
        }
        if (this.owner != null) {
            nbttagcompound.func_74778_a("Owner", this.owner);
        }
    }

    public void setTree(ITree tree) {
        this.containedTree = tree;
        if (tree != null) {
            this.sendNetworkUpdate();
        }
    }

    public ITree getTree() {
        return this.containedTree;
    }

    public boolean canUpdate() {
        return false;
    }

    public abstract void onBlockTick();

    public Packet func_70319_e() {
        return new PacketTileNBT(5, this).getPacket();
    }

    @Override
    public void sendNetworkUpdate() {
        Proxies.net.sendNetworkPacket(new PacketTileNBT(5, this), this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void fromPacket(ForestryPacket packetRaw) {
        PacketTileNBT packet = (PacketTileNBT)packetRaw;
        this.func_70307_a(packet.getTagCompound());
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public boolean allowsRemoval(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean allowsInteraction(EntityPlayer player) {
        return true;
    }

    @Override
    public EnumAccess getAccess() {
        return EnumAccess.SHARED;
    }

    @Override
    public boolean isOwnable() {
        return false;
    }

    @Override
    public boolean isOwned() {
        return this.owner != null && !this.owner.isEmpty();
    }

    @Override
    public String getOwnerName() {
        return this.owner;
    }

    @Override
    public void setOwner(EntityPlayer player) {
        this.owner = player.field_71092_bJ;
    }

    public void setOwner(String playername) {
        this.owner = playername;
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        if (this.owner != null) {
            return this.owner.equals(player.field_71092_bJ);
        }
        return false;
    }

    @Override
    public boolean switchAccessRule(EntityPlayer player) {
        return false;
    }
}

