/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IApiaristTracker;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.core.genetics.BreedingTracker;
import forestry.plugins.PluginApiculture;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class ApiaristTracker
extends BreedingTracker
implements IApiaristTracker {
    private int queensTotal = 0;
    private int dronesTotal = 0;
    private int princessesTotal = 0;

    public ApiaristTracker(String s) {
        this(s, "");
    }

    public ApiaristTracker(String s, String player) {
        super(s, player);
    }

    @Override
    public void func_76184_a(NBTTagCompound nbttagcompound) {
        this.queensTotal = nbttagcompound.func_74762_e("QueensTotal");
        this.princessesTotal = nbttagcompound.func_74762_e("PrincessesTotal");
        this.dronesTotal = nbttagcompound.func_74762_e("DronesTotal");
        super.func_76184_a(nbttagcompound);
    }

    @Override
    public void func_76187_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("QueensTotal", this.queensTotal);
        nbttagcompound.func_74768_a("PrincessesTotal", this.princessesTotal);
        nbttagcompound.func_74768_a("DronesTotal", this.dronesTotal);
        super.func_76187_b(nbttagcompound);
    }

    @Override
    public void registerPickup(IIndividual individual) {
        if (!individual.getGenome().getPrimary().getRoot().getUID().equals("rootBees")) {
            return;
        }
        if (!individual.isPureBred(0)) {
            return;
        }
        if (PluginApiculture.beeInterface.getCombinations(individual.getGenome().getPrimary()).size() > 0) {
            return;
        }
        this.registerSpecies(individual.getGenome().getPrimary());
    }

    @Override
    public void registerQueen(IIndividual bee) {
        ++this.queensTotal;
    }

    @Override
    public int getQueenCount() {
        return this.queensTotal;
    }

    @Override
    public void registerPrincess(IIndividual bee) {
        ++this.princessesTotal;
        this.registerBirth(bee);
    }

    @Override
    public int getPrincessCount() {
        return this.princessesTotal;
    }

    @Override
    public void registerDrone(IIndividual bee) {
        ++this.dronesTotal;
        this.registerBirth(bee);
    }

    @Override
    public int getDroneCount() {
        return this.dronesTotal;
    }

    @Override
    protected IBreedingTracker getCommonTracker(EntityPlayer player) {
        return PluginApiculture.beeInterface.getBreedingTracker(player.field_70170_p, "__COMMON_");
    }

    @Override
    protected String getPacketTag() {
        return "rootBees";
    }
}

