/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IHiveFrame;
import forestry.api.core.ForestryAPI;
import forestry.apiculture.gadgets.TileBeehouse;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.TileBase;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.StackUtils;
import forestry.plugins.PluginApiculture;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;

public class TileApiary
extends TileBeehouse
implements ISidedInventory,
ISpecialInventory {
    @Override
    public String func_70303_b() {
        return "apiculture.0";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.ApiaryGUI.ordinal(), this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        for (int i = 9; i < 12; ++i) {
            if (this.inventory.func_70301_a(i) == null || !(this.inventory.func_70301_a(i).func_77973_b() instanceof IHiveFrame)) continue;
            mod *= ((IHiveFrame)this.inventory.func_70301_a(i).func_77973_b()).getTerritoryModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        float mod = 0.1f;
        for (int i = 9; i < 12; ++i) {
            if (this.inventory.func_70301_a(i) == null || !(this.inventory.func_70301_a(i).func_77973_b() instanceof IHiveFrame)) continue;
            mod *= ((IHiveFrame)this.inventory.func_70301_a(i).func_77973_b()).getProductionModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        float mod = 1.0f;
        for (int i = 9; i < 12; ++i) {
            if (this.inventory.func_70301_a(i) == null || !(this.inventory.func_70301_a(i).func_77973_b() instanceof IHiveFrame)) continue;
            mod *= ((IHiveFrame)this.inventory.func_70301_a(i).func_77973_b()).getMutationModifier(genome, mate, mod);
        }
        return mod;
    }

    @Override
    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        float mod = 1.0f;
        for (int i = 9; i < 12; ++i) {
            if (this.inventory.func_70301_a(i) == null || !(this.inventory.func_70301_a(i).func_77973_b() instanceof IHiveFrame)) continue;
            mod *= ((IHiveFrame)this.inventory.func_70301_a(i).func_77973_b()).getLifespanModifier(genome, mate, mod);
        }
        return mod;
    }

    @Override
    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        for (int i = 9; i < 12; ++i) {
            if (this.inventory.func_70301_a(i) == null || !(this.inventory.func_70301_a(i).func_77973_b() instanceof IHiveFrame)) continue;
            mod *= ((IHiveFrame)this.inventory.func_70301_a(i).func_77973_b()).getFloweringModifier(genome, mod);
        }
        return mod;
    }

    @Override
    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        float mod = 1.0f;
        for (int i = 9; i < 12; ++i) {
            if (this.inventory.func_70301_a(i) == null || !(this.inventory.func_70301_a(i).func_77973_b() instanceof IHiveFrame)) continue;
            mod *= ((IHiveFrame)this.inventory.func_70301_a(i).func_77973_b()).getGeneticDecay(genome, mod);
        }
        return mod;
    }

    @Override
    public void wearOutEquipment(int amount) {
        int wear = Math.round((float)amount * PluginApiculture.beeInterface.getBeekeepingMode(this.field_70331_k).getWearModifier());
        for (int i = 9; i < 12; ++i) {
            if (this.inventory.func_70301_a(i) == null || !(this.inventory.func_70301_a(i).func_77973_b() instanceof IHiveFrame)) continue;
            this.inventory.func_70299_a(i, ((IHiveFrame)this.inventory.func_70301_a(i).func_77973_b()).frameUsed(this, this.inventory.func_70301_a(i), PluginApiculture.beeInterface.getMember(this.inventory.func_70301_a(0)), wear));
        }
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex != 0 && slotIndex != 1 && (slotIndex < 9 || slotIndex >= 12);
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        if (slotIndex == 0 && PluginApiculture.beeInterface.isMember(itemstack) && !PluginApiculture.beeInterface.isDrone(itemstack)) {
            return true;
        }
        return slotIndex == 1 && PluginApiculture.beeInterface.isDrone(itemstack);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        super.setSlotContents(i, itemstack);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ItemStack product = null;
        for (int i = SLOT_PRODUCT_1; i < SLOT_PRODUCT_1 + SLOT_PRODUCT_COUNT; ++i) {
            if (this.inventory.func_70301_a(i) == null) continue;
            if (this.inventory.func_70301_a((int)i).field_77993_c == ForestryItem.beePrincessGE.field_77779_bT) {
                if (PluginApiculture.apiarySideSensitive && from != ForgeDirection.UP) continue;
                product = this.inventory.func_70301_a(i).func_77946_l();
                if (!doRemove) break;
                this.inventory.func_70301_a((int)i).field_77994_a = 0;
                this.inventory.func_70299_a(i, null);
                break;
            }
            if (this.inventory.func_70301_a((int)i).field_77993_c == ForestryItem.beeDroneGE.field_77779_bT) {
                if (PluginApiculture.apiarySideSensitive && from != ForgeDirection.DOWN) continue;
                product = StackUtils.createSplitStack(this.inventory.func_70301_a(i), 1);
                product.field_77994_a = 1;
                if (!doRemove) break;
                --this.inventory.func_70301_a((int)i).field_77994_a;
                if (this.inventory.func_70301_a((int)i).field_77994_a > 0) break;
                this.inventory.func_70299_a(i, null);
                break;
            }
            if (PluginApiculture.apiarySideSensitive && (from == ForgeDirection.UP || from == ForgeDirection.DOWN)) continue;
            product = StackUtils.createSplitStack(this.inventory.func_70301_a(i), 1);
            if (!doRemove) break;
            --this.inventory.func_70301_a((int)i).field_77994_a;
            if (this.inventory.func_70301_a((int)i).field_77994_a > 0) break;
            this.inventory.func_70299_a(i, null);
            break;
        }
        return new ItemStack[]{product};
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if ((stack.field_77993_c == ForestryItem.beePrincessGE.field_77779_bT || stack.field_77993_c == ForestryItem.beeQueenGE.field_77779_bT) && this.inventory.func_70301_a(0) == null) {
            if (doAdd) {
                this.inventory.func_70299_a(0, stack.func_77946_l());
                this.inventory.func_70301_a((int)0).field_77994_a = 1;
            }
            return 1;
        }
        if (stack.field_77993_c == ForestryItem.beeDroneGE.field_77779_bT) {
            int added;
            ItemStack droneStack = this.inventory.func_70301_a(1);
            if (droneStack == null) {
                if (doAdd) {
                    this.inventory.func_70299_a(1, stack.func_77946_l());
                }
                return stack.field_77994_a;
            }
            if (!droneStack.func_77969_a(stack)) {
                return 0;
            }
            if (!ItemStack.func_77970_a((ItemStack)droneStack, (ItemStack)stack)) {
                return 0;
            }
            int space = droneStack.func_77976_d() - droneStack.field_77994_a;
            if (space <= 0) {
                return 0;
            }
            int n = added = space > stack.field_77994_a ? stack.field_77994_a : space;
            if (doAdd) {
                droneStack.field_77994_a += added;
            }
            return added;
        }
        return 0;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.missingQueen);
        res.add(ForestryTrigger.missingDrone);
        res.add(PluginApiculture.triggerNoFrames);
        return res;
    }
}

