/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.FlowerManager;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.core.utils.StringUtil;
import java.util.Collections;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class FlowerProviderVanilla
implements IFlowerProvider {
    @Override
    public boolean isAcceptedFlower(World world, IIndividual individual, int x, int y, int z) {
        int blockid = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (blockid == Block.field_82516_cf.field_71990_ca) {
            return this.checkFlowerPot(meta);
        }
        ItemStack flower = new ItemStack(blockid, 1, meta);
        for (ItemStack stack : FlowerManager.plainFlowers) {
            if (!flower.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptedPollinatable(World world, IPollinatable pollinatable) {
        EnumSet types = pollinatable.getPlantType();
        return types.size() > 1 || !types.contains(EnumPlantType.Nether);
    }

    private boolean checkFlowerPot(int meta) {
        return meta == 1 || meta == 2;
    }

    @Override
    public boolean growFlower(World world, IIndividual individual, int x, int y, int z) {
        int blockid = world.func_72798_a(x, y, z);
        if (blockid != 0) {
            if (blockid == Block.field_82516_cf.field_71990_ca && world.func_72805_g(x, y, z) == 0) {
                return this.growInPot(world, x, y, z);
            }
            return false;
        }
        int groundid = world.func_72798_a(x, y - 1, z);
        if (groundid != Block.field_71979_v.field_71990_ca && groundid != Block.field_71980_u.field_71990_ca) {
            return false;
        }
        Collections.shuffle(FlowerManager.plainFlowers);
        ItemStack flower = (ItemStack)FlowerManager.plainFlowers.get(world.field_73012_v.nextInt(FlowerManager.plainFlowers.size() - 1));
        world.func_72832_d(x, y, z, flower.field_77993_c, flower.func_77960_j(), 2);
        return true;
    }

    private boolean growInPot(World world, int x, int y, int z) {
        if (world.field_73012_v.nextBoolean()) {
            world.func_72832_d(x, y, z, Block.field_82516_cf.field_71990_ca, 1, 2);
        } else {
            world.func_72832_d(x, y, z, Block.field_82516_cf.field_71990_ca, 2, 2);
        }
        return true;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("flowers.vanilla");
    }

    @Override
    public ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
        return products;
    }

    @Override
    public ItemStack[] getItemStacks() {
        return FlowerManager.plainFlowers.toArray(new ItemStack[0]);
    }
}

