/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.genetics;

import forestry.api.genetics.IAllele;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public interface ISpeciesRoot {
    public String getUID();

    public Class getMemberClass();

    public int getSpeciesCount();

    public boolean isMember(ItemStack var1);

    public boolean isMember(ItemStack var1, int var2);

    public boolean isMember(IIndividual var1);

    public IIndividual getMember(ItemStack var1);

    public IIndividual getMember(NBTTagCompound var1);

    public ItemStack getMemberStack(IIndividual var1, int var2);

    public IBreedingTracker getBreedingTracker(World var1, String var2);

    public IIndividual templateAsIndividual(IAllele[] var1);

    public IIndividual templateAsIndividual(IAllele[] var1, IAllele[] var2);

    public IChromosome[] templateAsChromosomes(IAllele[] var1);

    public IChromosome[] templateAsChromosomes(IAllele[] var1, IAllele[] var2);

    public IGenome templateAsGenome(IAllele[] var1);

    public IGenome templateAsGenome(IAllele[] var1, IAllele[] var2);

    public void registerTemplate(IAllele[] var1);

    public void registerTemplate(String var1, IAllele[] var2);

    public IAllele[] getTemplate(String var1);

    public IAllele[] getDefaultTemplate();

    public IAllele[] getRandomTemplate(Random var1);

    public Map getGenomeTemplates();

    public ArrayList getIndividualTemplates();

    public void registerMutation(IMutation var1);

    public Collection getMutations(boolean var1);

    public Collection getCombinations(IAllele var1);

    public Collection getPaths(IAllele var1, int var2);

    public Map getResearchCatalysts();

    public void setResearchSuitability(ItemStack var1, float var2);

    public IChromosomeType[] getKaryotype();

    public IChromosomeType getKaryotypeKey();
}

