/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.core;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ForestryAPI;
import java.util.ArrayList;
import net.minecraft.util.Icon;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public enum EnumTemperature {
    NONE("None", "habitats/ocean"),
    ICY("Icy", "habitats/snow"),
    COLD("Cold", "habitats/taiga"),
    NORMAL("Normal", "habitats/plains"),
    WARM("Warm", "habitats/jungle"),
    HOT("Hot", "habitats/desert"),
    HELLISH("Hellish", "habitats/nether");

    @Deprecated
    public static ArrayList icyBiomeIds;
    @Deprecated
    public static ArrayList coldBiomeIds;
    @Deprecated
    public static ArrayList normalBiomeIds;
    @Deprecated
    public static ArrayList warmBiomeIds;
    @Deprecated
    public static ArrayList hotBiomeIds;
    @Deprecated
    public static ArrayList hellishBiomeIds;
    public final String name;
    public final String iconIndex;

    /*
     * WARNING - void declaration
     */
    private EnumTemperature() {
        void iconIndex;
        void name;
        this.name = name;
        this.iconIndex = iconIndex;
    }

    public String getName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        return ForestryAPI.textureManager.getDefault(this.iconIndex);
    }

    public static ArrayList getBiomeIds(EnumTemperature temperature) {
        switch (temperature) {
            case ICY: {
                return icyBiomeIds;
            }
            case COLD: {
                return coldBiomeIds;
            }
            case WARM: {
                return warmBiomeIds;
            }
            case HOT: {
                return hotBiomeIds;
            }
            case HELLISH: {
                return hellishBiomeIds;
            }
        }
        return normalBiomeIds;
    }

    public static boolean isBiomeHellish(BiomeGenBase biomeGen) {
        return BiomeDictionary.isBiomeOfType((BiomeGenBase)biomeGen, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER);
    }

    public static boolean isBiomeHellish(int biomeID) {
        return BiomeDictionary.isBiomeRegistered((int)biomeID) && BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.field_76773_a[biomeID], (BiomeDictionary.Type)BiomeDictionary.Type.NETHER);
    }

    public static EnumTemperature getFromValue(float rawTemp) {
        EnumTemperature value = ICY;
        if (rawTemp >= 2.0f) {
            value = HOT;
        } else if (rawTemp >= 1.2f) {
            value = WARM;
        } else if (rawTemp >= 0.2f) {
            value = NORMAL;
        } else if (rawTemp >= 0.05f) {
            value = COLD;
        }
        return value;
    }

    static {
        icyBiomeIds = new ArrayList();
        coldBiomeIds = new ArrayList();
        normalBiomeIds = new ArrayList();
        warmBiomeIds = new ArrayList();
        hotBiomeIds = new ArrayList();
        hellishBiomeIds = new ArrayList();
    }
}

