/*
 * Decompiled with CFR 0.152.
 */
package chunkster;

import chunkster.NBTBase;
import chunkster.NBTTagCompound;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class NBTCompressionUtility {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NBTTagCompound readGzippedCompoundFromInputStream(InputStream inputstream) throws IOException {
        DataInputStream datainputstream = new DataInputStream(new GZIPInputStream(inputstream));
        try {
            NBTTagCompound nbttagcompound;
            NBTTagCompound nBTTagCompound = nbttagcompound = NBTCompressionUtility.readRootTagCompound(datainputstream);
            return nBTTagCompound;
        }
        finally {
            datainputstream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeGzippedCompoundToOutputStream(NBTTagCompound nbttagcompound, OutputStream outputstream) throws IOException {
        DataOutputStream dataoutputstream = new DataOutputStream(new GZIPOutputStream(outputstream));
        try {
            NBTCompressionUtility.writeRootTagCompound(nbttagcompound, dataoutputstream);
        }
        finally {
            dataoutputstream.close();
        }
    }

    public static NBTTagCompound readRootTagCompound(DataInput datainput) throws IOException {
        NBTBase nbtbase = NBTBase.readTag(datainput);
        if (nbtbase instanceof NBTTagCompound) {
            return (NBTTagCompound)nbtbase;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void writeRootTagCompound(NBTTagCompound nbttagcompound, DataOutput dataoutput) throws IOException {
        NBTBase.writeTag(nbttagcompound, dataoutput);
    }
}

