/*
 * Decompiled with CFR 0.152.
 */
package chunkster;

import chunkster.NBTCompressionUtility;
import chunkster.NBTTagCompound;
import chunkster.RegionFile;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Chunkster {
    private static boolean removeMobs = false;
    private static boolean removeProjectiles = false;
    private static boolean removeDroppedItems = false;
    private static boolean removeExperienceOrbs = false;
    private static boolean removeVehicles = false;
    private static boolean removeBrokenPistons = false;
    private static boolean removeTNT = false;

    public static void main(String[] args) throws IOException {
        File worldDir;
        String worldPath = "";
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        Chunkster.printUsage();
        for (String s : args) {
            if (s.equalsIgnoreCase("--remove-mobs")) {
                removeMobs = true;
                continue;
            }
            if (s.equalsIgnoreCase("--remove-projectiles")) {
                removeProjectiles = true;
                continue;
            }
            if (s.equalsIgnoreCase("--remove-dropped-items")) {
                removeDroppedItems = true;
                continue;
            }
            if (s.equalsIgnoreCase("--remove-experience-orbs")) {
                removeExperienceOrbs = true;
                continue;
            }
            if (s.equalsIgnoreCase("--remove-vehicles")) {
                removeVehicles = true;
                continue;
            }
            if (s.equalsIgnoreCase("Chunkster.jar")) continue;
            worldPath = s;
        }
        if (worldPath.isEmpty()) {
            Chunkster.debug("You forgot to provide a path, would you like to Chunkster to search the current directory? (Y/N)");
            String response = in.readLine();
            if (response.equalsIgnoreCase("y") || response.equalsIgnoreCase("yes")) {
                File currentDir = new File(".").getCanonicalFile();
                for (File worldDir2 : currentDir.listFiles()) {
                    File levelFile;
                    if (!worldDir2.isDirectory() || !(levelFile = new File(worldDir2, "level.dat")).exists()) continue;
                    Chunkster.debug("World found! " + levelFile.getAbsolutePath());
                    Chunkster.debug("Would you like to use repair this one? (Y/N)");
                    response = in.readLine();
                    if (!response.equalsIgnoreCase("y") && !response.equalsIgnoreCase("yes")) continue;
                    worldPath = worldDir2.getAbsolutePath();
                    break;
                }
            }
        }
        if (worldPath.isEmpty()) {
            Chunkster.exit("no world directory found.");
        }
        if (!(worldDir = new File(worldPath)).exists() || !worldDir.isDirectory()) {
            Chunkster.exit("error: " + worldDir.getPath() + " is not a directory");
        }
        Chunkster.scan(worldDir);
    }

    public static void scan(File worldDir) {
        File regionDir = new File(worldDir, "region");
        if (!regionDir.exists()) {
            Chunkster.exit("error: region directory not found");
        }
        Chunkster.debug("Starting scan...");
        Pattern regionFilePattern = Pattern.compile("r\\.(-?[0-9]+)\\.(-?[0-9]+).mcr");
        for (File file : regionDir.listFiles()) {
            Matcher match;
            if (!file.isFile() || !(match = regionFilePattern.matcher(file.getName())).matches()) continue;
            Chunkster.rebuildRegionFile(file, match);
        }
    }

    private static void rebuildRegionFile(File file, Matcher match) {
        RegionFile region = new RegionFile(file);
        Chunkster.debug("Pre-build file length: " + file.length());
        File rebuiltFile = new File(file.getPath() + ".rebuild");
        RegionFile rebuiltRegion = new RegionFile(rebuiltFile);
        String name = file.getName();
        int regionX = Integer.parseInt(match.group(1));
        int regionZ = Integer.parseInt(match.group(2));
        Chunkster.debug("Rebuilding region file x=" + regionX + " z=" + regionZ + " file=" + name);
        int entitiesRemovedCount = 0;
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                DataInputStream chunkInputStream;
                int chunkX = x + (regionX << 5);
                int chunkZ = z + (regionZ << 5);
                if (region.getOffset(x, z) == 0 || (chunkInputStream = region.getChunkDataInputStream(x, z)) == null || chunkInputStream == null) continue;
                try {
                    NBTTagCompound rootTag = NBTCompressionUtility.readRootTagCompound(chunkInputStream);
                    if (!rootTag.hasKey("Level")) {
                        Chunkster.debug("Chunk file at " + chunkX + "," + chunkZ + " is missing level data, skipping");
                        continue;
                    }
                    NBTTagCompound levelTag = rootTag.getCompoundTag("Level");
                    int xPos = levelTag.getInteger("xPos");
                    int zPos = levelTag.getInteger("zPos");
                    if (xPos != chunkX || zPos != chunkZ) continue;
                    entitiesRemovedCount += Chunkster.removeEntities(levelTag);
                    DataOutputStream chunkOutputStream = rebuiltRegion.getChunkDataOutputStream(x, z);
                    NBTCompressionUtility.writeRootTagCompound(rootTag, chunkOutputStream);
                    chunkOutputStream.close();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Chunkster.debug("Removed " + entitiesRemovedCount + " entities from region.");
        try {
            region.close();
            rebuiltRegion.close();
            Chunkster.debug("Rebuilt file length: " + rebuiltFile.length());
            if (file.delete()) {
                Chunkster.debug("Deleted original region file.");
            }
            if (rebuiltFile.renameTo(file)) {
                Chunkster.debug("Renamed rebuilt region file to original.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static int removeEntities(NBTTagCompound levelTag) {
        int removedCount = 0;
        List<String> mobIdList = Arrays.asList("Mob", "Monster", "Creeper", "Skeleton", "Spider", "Giant", "Zombie", "Slime", "PigZombie", "Ghast", "Pig", "Sheep", "Cow", "Chicken", "Wolf", "Squid", "Enderman", "Silverfish", "CaveSpider");
        List<String> projectileIdList = Arrays.asList("Arrow", "Snowball", "Egg", "Fireball", "SmallFireball", "ThrownEnderpearl");
        if (levelTag.hasKey("Entities")) {
            List entityList = levelTag.getTagList("Entities").getList();
            Iterator i = entityList.iterator();
            while (i.hasNext()) {
                NBTTagCompound entity = (NBTTagCompound)i.next();
                String entityId = entity.getString("id");
                if (removeMobs && mobIdList.contains(entityId)) {
                    ++removedCount;
                    i.remove();
                }
                if (removeProjectiles && projectileIdList.contains(entityId)) {
                    ++removedCount;
                    i.remove();
                }
                if (removeDroppedItems && entityId.equals("Item")) {
                    ++removedCount;
                    i.remove();
                }
                if (removeExperienceOrbs && entityId.equals("XPOrb")) {
                    ++removedCount;
                    i.remove();
                }
                if (!removeVehicles || !entityId.equals("Minecart") && !entityId.equals("Boat")) continue;
                ++removedCount;
                i.remove();
            }
        }
        return removedCount;
    }

    private static void debug(String in) {
        System.out.println("[Chunkster] " + in);
    }

    private static void printUsage() {
        System.out.println("Chunkster Region Map Repair Utility v0.2 (now with electrolytes!)\nAuthor: Xeon Productions\nUsage: java -jar Chunkster.jar [options ..] <world directory>\nOptions:\n  --remove-mobs: removes mobs, monsters, creepers, skeletons, spiders, etc.\n  --remove-projectiles: removes arrows, snowballs, eggs, etc.\n  --remove-dropped-items: removes dropped items.\n  --remove-experience-orbs: removes experience orbs.\n  --remove-vehicles: removes boats and minecarts\n");
    }

    private static void exit(String message) {
        System.err.println("[Chunkster] " + message);
        System.exit(1);
    }
}

