/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.schematica.renderer;

import java.nio.FloatBuffer;
import lunatrius.schematica.Settings;
import org.lwjgl.BufferUtils;
import org.lwjgl.util.vector.Vector3f;

public class RenderHelper {
    public static final int QUAD_DOWN = 1;
    public static final int QUAD_UP = 2;
    public static final int QUAD_NORTH = 4;
    public static final int QUAD_SOUTH = 8;
    public static final int QUAD_WEST = 16;
    public static final int QUAD_EAST = 32;
    public static final int QUAD_ALL = 63;
    public static final int LINE_DOWN_WEST = 17;
    public static final int LINE_UP_WEST = 18;
    public static final int LINE_DOWN_EAST = 33;
    public static final int LINE_UP_EAST = 34;
    public static final int LINE_DOWN_NORTH = 5;
    public static final int LINE_UP_NORTH = 6;
    public static final int LINE_DOWN_SOUTH = 9;
    public static final int LINE_UP_SOUTH = 10;
    public static final int LINE_NORTH_WEST = 20;
    public static final int LINE_NORTH_EAST = 36;
    public static final int LINE_SOUTH_WEST = 24;
    public static final int LINE_SOUTH_EAST = 40;
    public static final int LINE_ALL = 63;
    public static final Vector3f VEC_ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Settings settings = Settings.instance();
    private static int quadSize = 0;
    private static float[] quadVertexBuffer = null;
    private static float[] quadColorBuffer = null;
    private static int quadVertexIndex = 0;
    private static int quadColorIndex = 0;
    private static int quadCount = 0;
    private static int lineSize = 0;
    private static float[] lineVertexBuffer = null;
    private static float[] lineColorBuffer = null;
    private static int lineVertexIndex = 0;
    private static int lineColorIndex = 0;
    private static int lineCount = 0;
    private static final Vector3f vecZero = new Vector3f();
    private static final Vector3f vecSize = new Vector3f();

    public static void createBuffers() {
        quadSize = 240;
        quadVertexBuffer = new float[quadSize * 3];
        quadColorBuffer = new float[quadSize * 4];
        lineSize = 240;
        lineVertexBuffer = new float[lineSize * 3];
        lineColorBuffer = new float[lineSize * 4];
        RenderHelper.initBuffers();
    }

    public static void initBuffers() {
        quadVertexIndex = 0;
        quadColorIndex = 0;
        quadCount = 0;
        lineVertexIndex = 0;
        lineColorIndex = 0;
        lineCount = 0;
    }

    public static void destroyBuffers() {
        quadSize = 0;
        quadVertexBuffer = null;
        quadColorBuffer = null;
        lineSize = 0;
        lineVertexBuffer = null;
        lineColorBuffer = null;
    }

    public static FloatBuffer getQuadVertexBuffer() {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)quadVertexBuffer.length).put(quadVertexBuffer);
        buffer.flip();
        return buffer;
    }

    public static FloatBuffer getQuadColorBuffer() {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)quadColorBuffer.length).put(quadColorBuffer);
        buffer.flip();
        return buffer;
    }

    public static int getQuadCount() {
        return quadCount;
    }

    public static FloatBuffer getLineVertexBuffer() {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)lineVertexBuffer.length).put(lineVertexBuffer);
        buffer.flip();
        return buffer;
    }

    public static FloatBuffer getLineColorBuffer() {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)lineColorBuffer.length).put(lineColorBuffer);
        buffer.flip();
        return buffer;
    }

    public static int getLineCount() {
        return lineCount;
    }

    private static float[] createAndCopyBuffer(int newSize, float[] oldBuffer) {
        float[] tempBuffer = new float[newSize];
        System.arraycopy(oldBuffer, 0, tempBuffer, 0, oldBuffer.length);
        return tempBuffer;
    }

    public static void drawCuboidSurface(Vector3f zero, Vector3f size, int sides, float red, float green, float blue, float alpha) {
        vecZero.set(zero.x - RenderHelper.settings.blockDelta, zero.y - RenderHelper.settings.blockDelta, zero.z - RenderHelper.settings.blockDelta);
        vecSize.set(size.x + RenderHelper.settings.blockDelta, size.y + RenderHelper.settings.blockDelta, size.z + RenderHelper.settings.blockDelta);
        if (quadCount + 24 >= quadSize) {
            quadVertexBuffer = RenderHelper.createAndCopyBuffer((quadSize *= 2) * 3, quadVertexBuffer);
            quadColorBuffer = RenderHelper.createAndCopyBuffer(quadSize * 4, quadColorBuffer);
        }
        int total = 0;
        if ((sides & 1) != 0) {
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.z;
            ++quadCount;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.z;
            ++quadCount;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.z;
            ++quadCount;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.z;
            ++quadCount;
            total += 4;
        }
        if ((sides & 2) != 0) {
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.z;
            ++quadCount;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.z;
            ++quadCount;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.z;
            ++quadCount;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.z;
            ++quadCount;
            total += 4;
        }
        if ((sides & 4) != 0) {
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.z;
            ++quadCount;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.z;
            ++quadCount;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.z;
            ++quadCount;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.z;
            ++quadCount;
            total += 4;
        }
        if ((sides & 8) != 0) {
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.z;
            ++quadCount;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.z;
            ++quadCount;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.z;
            ++quadCount;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.z;
            ++quadCount;
            total += 4;
        }
        if ((sides & 0x10) != 0) {
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.z;
            ++quadCount;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.z;
            ++quadCount;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.z;
            ++quadCount;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.z;
            ++quadCount;
            total += 4;
        }
        if ((sides & 0x20) != 0) {
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.z;
            ++quadCount;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.z;
            ++quadCount;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecZero.z;
            ++quadCount;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.quadVertexBuffer[RenderHelper.quadVertexIndex++] = RenderHelper.vecSize.z;
            ++quadCount;
            total += 4;
        }
        for (int i = 0; i < total; ++i) {
            RenderHelper.quadColorBuffer[RenderHelper.quadColorIndex++] = red;
            RenderHelper.quadColorBuffer[RenderHelper.quadColorIndex++] = green;
            RenderHelper.quadColorBuffer[RenderHelper.quadColorIndex++] = blue;
            RenderHelper.quadColorBuffer[RenderHelper.quadColorIndex++] = alpha;
        }
    }

    public static void drawCuboidOutline(Vector3f zero, Vector3f size, int sides, float red, float green, float blue, float alpha) {
        vecZero.set(zero.x - RenderHelper.settings.blockDelta, zero.y - RenderHelper.settings.blockDelta, zero.z - RenderHelper.settings.blockDelta);
        vecSize.set(size.x + RenderHelper.settings.blockDelta, size.y + RenderHelper.settings.blockDelta, size.z + RenderHelper.settings.blockDelta);
        if (lineCount + 24 >= lineSize) {
            lineVertexBuffer = RenderHelper.createAndCopyBuffer((lineSize *= 2) * 3, lineVertexBuffer);
            lineColorBuffer = RenderHelper.createAndCopyBuffer(lineSize * 4, lineColorBuffer);
        }
        int total = 0;
        if ((sides & 0x11) != 0) {
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.z;
            ++lineCount;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.z;
            ++lineCount;
            total += 2;
        }
        if ((sides & 0x12) != 0) {
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.z;
            ++lineCount;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.z;
            ++lineCount;
            total += 2;
        }
        if ((sides & 0x21) != 0) {
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.z;
            ++lineCount;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.z;
            ++lineCount;
            total += 2;
        }
        if ((sides & 0x22) != 0) {
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.z;
            ++lineCount;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.z;
            ++lineCount;
            total += 2;
        }
        if ((sides & 5) != 0) {
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.z;
            ++lineCount;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.z;
            ++lineCount;
            total += 2;
        }
        if ((sides & 6) != 0) {
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.z;
            ++lineCount;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.z;
            ++lineCount;
            total += 2;
        }
        if ((sides & 9) != 0) {
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.z;
            ++lineCount;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.z;
            ++lineCount;
            total += 2;
        }
        if ((sides & 0xA) != 0) {
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.z;
            ++lineCount;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.z;
            ++lineCount;
            total += 2;
        }
        if ((sides & 0x14) != 0) {
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.z;
            ++lineCount;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.z;
            ++lineCount;
            total += 2;
        }
        if ((sides & 0x24) != 0) {
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.z;
            ++lineCount;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.z;
            ++lineCount;
            total += 2;
        }
        if ((sides & 0x18) != 0) {
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.z;
            ++lineCount;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.z;
            ++lineCount;
            total += 2;
        }
        if ((sides & 0x28) != 0) {
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecZero.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.z;
            ++lineCount;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.x;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.y;
            RenderHelper.lineVertexBuffer[RenderHelper.lineVertexIndex++] = RenderHelper.vecSize.z;
            ++lineCount;
            total += 2;
        }
        for (int i = 0; i < total; ++i) {
            RenderHelper.lineColorBuffer[RenderHelper.lineColorIndex++] = red;
            RenderHelper.lineColorBuffer[RenderHelper.lineColorIndex++] = green;
            RenderHelper.lineColorBuffer[RenderHelper.lineColorIndex++] = blue;
            RenderHelper.lineColorBuffer[RenderHelper.lineColorIndex++] = alpha;
        }
    }
}

