/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.schematica;

import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import lunatrius.schematica.BlockInfo;
import lunatrius.schematica.ChatEventHandler;
import lunatrius.schematica.FileFilterConfiguration;
import lunatrius.schematica.KeyBindingHandler;
import lunatrius.schematica.SchematicPrinter;
import lunatrius.schematica.SchematicWorld;
import lunatrius.schematica.Settings;
import lunatrius.schematica.Ticker;
import lunatrius.schematica.renderer.RendererSchematicChunk;
import lunatrius.schematica.renderer.RendererSchematicGlobal;
import lunatrius.schematica.util.Config;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="Schematica")
public class Schematica {
    private static final FileFilterConfiguration FILE_FILTER_CONFIGURATION = new FileFilterConfiguration();
    private static final String DIR_ASSETS = "lunatrius/schematica/assets/";
    private final Settings settings = Settings.instance();
    private final lv profiler;
    private final SchematicPrinter printer;
    private int ticks;
    @Mod.Instance(value="Schematica")
    public static Schematica instance;
    private Field sortedWorldRenderers;
    private File configurationFolder;

    public Schematica() {
        this.profiler = this.settings.minecraft.C;
        this.printer = new SchematicPrinter();
        this.ticks = -1;
        this.sortedWorldRenderers = null;
        this.configurationFolder = null;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File suggestedConfigurationFile = event.getSuggestedConfigurationFile();
        Configuration config = new Configuration(suggestedConfigurationFile);
        this.configurationFolder = suggestedConfigurationFile.getParentFile();
        config.load();
        this.settings.enableAlpha = Config.getBoolean(config, "general", "alphaEnabled", this.settings.enableAlpha, "Enable transparent textures.");
        this.settings.alpha = (float)Config.getInt(config, "general", "alpha", (int)(this.settings.alpha * 255.0f), 0, 255, "Alpha value used when rendering the schematic.") / 255.0f;
        this.settings.highlight = Config.getBoolean(config, "general", "highlight", this.settings.highlight, "Highlight invalid placed blocks and to be placed blocks.");
        this.settings.highlightAir = Config.getBoolean(config, "general", "highlightAir", this.settings.highlightAir, "Highlight invalid placed blocks (where there should be no block).");
        this.settings.blockDelta = (float)Config.getDouble(config, "general", "blockDelta", this.settings.blockDelta, 0.0, 0.5, "Delta value used for highlighting (if you're having issue with overlapping textures try setting this value higher).");
        this.settings.placeDelay = Config.getInt(config, "general", "placeDelay", this.settings.placeDelay, 0, 20, "Delay in ticks between placement attempts.");
        this.settings.placeInstantly = Config.getBoolean(config, "general", "placeInstantly", this.settings.placeInstantly, "Place all blocks that can be placed in one tick.");
        this.settings.placeAdjacent = Config.getBoolean(config, "general", "placeAdjacent", this.settings.placeAdjacent, "Place blocks only if there is an adjacent block next to it.");
        this.settings.drawQuads = Config.getBoolean(config, "general", "drawQuads", this.settings.drawQuads, "Draw surface areas.");
        this.settings.drawLines = Config.getBoolean(config, "general", "drawLines", this.settings.drawLines, "Draw outlines.");
        config.save();
        List<Integer> blockListIgnoreID = SchematicWorld.blockListIgnoreID;
        blockListIgnoreID.add(aqz.af.cF);
        blockListIgnoreID.add(aqz.ah.cF);
        blockListIgnoreID.add(aqz.bj.cF);
        blockListIgnoreID.add(aqz.bM.cF);
        List<Integer> blockListIgnoreMetadata = SchematicWorld.blockListIgnoreMetadata;
        blockListIgnoreMetadata.add(aqz.F.cF);
        blockListIgnoreMetadata.add(aqz.G.cF);
        blockListIgnoreMetadata.add(aqz.H.cF);
        blockListIgnoreMetadata.add(aqz.I.cF);
        blockListIgnoreMetadata.add(aqz.U.cF);
        blockListIgnoreMetadata.add(aqz.X.cF);
        blockListIgnoreMetadata.add(aqz.Y.cF);
        blockListIgnoreMetadata.add(aqz.Z.cF);
        blockListIgnoreMetadata.add(aqz.aa.cF);
        blockListIgnoreMetadata.add(aqz.ae.cF);
        blockListIgnoreMetadata.add(aqz.ap.cF);
        blockListIgnoreMetadata.add(aqz.av.cF);
        blockListIgnoreMetadata.add(aqz.ay.cF);
        blockListIgnoreMetadata.add(aqz.az.cF);
        blockListIgnoreMetadata.add(aqz.aA.cF);
        blockListIgnoreMetadata.add(aqz.aE.cF);
        blockListIgnoreMetadata.add(aqz.aF.cF);
        blockListIgnoreMetadata.add(aqz.aG.cF);
        blockListIgnoreMetadata.add(aqz.aH.cF);
        blockListIgnoreMetadata.add(aqz.aI.cF);
        blockListIgnoreMetadata.add(aqz.aJ.cF);
        blockListIgnoreMetadata.add(aqz.aK.cF);
        blockListIgnoreMetadata.add(aqz.aL.cF);
        blockListIgnoreMetadata.add(aqz.aM.cF);
        blockListIgnoreMetadata.add(aqz.aN.cF);
        blockListIgnoreMetadata.add(aqz.aO.cF);
        blockListIgnoreMetadata.add(aqz.aP.cF);
        blockListIgnoreMetadata.add(aqz.aQ.cF);
        blockListIgnoreMetadata.add(aqz.aR.cF);
        blockListIgnoreMetadata.add(aqz.aU.cF);
        blockListIgnoreMetadata.add(aqz.aV.cF);
        blockListIgnoreMetadata.add(aqz.aW.cF);
        blockListIgnoreMetadata.add(aqz.bf.cF);
        blockListIgnoreMetadata.add(aqz.bj.cF);
        blockListIgnoreMetadata.add(aqz.bk.cF);
        blockListIgnoreMetadata.add(aqz.bl.cF);
        blockListIgnoreMetadata.add(aqz.bm.cF);
        blockListIgnoreMetadata.add(aqz.bn.cF);
        blockListIgnoreMetadata.add(aqz.bp.cF);
        blockListIgnoreMetadata.add(aqz.bz.cF);
        blockListIgnoreMetadata.add(aqz.bA.cF);
        blockListIgnoreMetadata.add(aqz.bB.cF);
        blockListIgnoreMetadata.add(aqz.bC.cF);
        blockListIgnoreMetadata.add(aqz.bE.cF);
        blockListIgnoreMetadata.add(aqz.bH.cF);
        blockListIgnoreMetadata.add(aqz.bI.cF);
        blockListIgnoreMetadata.add(aqz.bN.cF);
        blockListIgnoreMetadata.add(aqz.bQ.cF);
        blockListIgnoreMetadata.add(aqz.bR.cF);
        blockListIgnoreMetadata.add(aqz.bT.cF);
        blockListIgnoreMetadata.add(aqz.bV.cF);
        blockListIgnoreMetadata.add(aqz.bX.cF);
        blockListIgnoreMetadata.add(aqz.bY.cF);
        blockListIgnoreMetadata.add(aqz.bZ.cF);
        blockListIgnoreMetadata.add(aqz.cb.cF);
        blockListIgnoreMetadata.add(aqz.cc.cF);
        blockListIgnoreMetadata.add(aqz.cd.cF);
        blockListIgnoreMetadata.add(aqz.ch.cF);
        blockListIgnoreMetadata.add(aqz.ci.cF);
        blockListIgnoreMetadata.add(aqz.cj.cF);
        blockListIgnoreMetadata.add(aqz.ck.cF);
        blockListIgnoreMetadata.add(aqz.cm.cF);
        Map<Integer, Integer> blockListMapping = SchematicWorld.blockListMapping;
        blockListMapping.put(aqz.F.cF, yc.az.cv);
        blockListMapping.put(aqz.G.cF, yc.az.cv);
        blockListMapping.put(aqz.H.cF, yc.aA.cv);
        blockListMapping.put(aqz.I.cF, yc.aA.cv);
        blockListMapping.put(aqz.X.cF, yc.bc.cv);
        blockListMapping.put(aqz.aA.cF, yc.aE.cv);
        blockListMapping.put(aqz.aE.cF, yc.U.cv);
        blockListMapping.put(aqz.aH.cF, aqz.aG.cF);
        blockListMapping.put(aqz.aI.cF, yc.aw.cv);
        blockListMapping.put(aqz.aJ.cF, yc.ax.cv);
        blockListMapping.put(aqz.aQ.cF, yc.aD.cv);
        blockListMapping.put(aqz.aN.cF, yc.aw.cv);
        blockListMapping.put(aqz.aU.cF, aqz.aV.cF);
        blockListMapping.put(aqz.bm.cF, yc.bd.cv);
        blockListMapping.put(aqz.bn.cF, yc.bd.cv);
        blockListMapping.put(aqz.bx.cF, yc.bi.cv);
        blockListMapping.put(aqz.by.cF, yc.bj.cv);
        blockListMapping.put(aqz.bI.cF, yc.bt.cv);
        blockListMapping.put(aqz.bK.cF, yc.bA.cv);
        blockListMapping.put(aqz.bL.cF, yc.bB.cv);
        blockListMapping.put(aqz.bR.cF, aqz.bQ.cF);
        blockListMapping.put(aqz.bU.cF, yc.aY.cv);
        blockListMapping.put(aqz.bZ.cF, yc.M.cv);
        blockListMapping.put(aqz.ch.cF, yc.bL.cv);
        blockListMapping.put(aqz.ci.cF, yc.bM.cv);
        blockListMapping.put(aqz.cj.cF, yc.bN.cv);
        blockListMapping.put(aqz.cl.cF, yc.bS.cv);
        if (!Settings.schematicDirectory.exists() && !Settings.schematicDirectory.mkdirs()) {
            Settings.logger.a("Could not create schematic directory!");
        }
        if (!Settings.textureDirectory.exists() && !Settings.textureDirectory.mkdirs()) {
            Settings.logger.a("Could not create texture directory!");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        try {
            MinecraftForge.EVENT_BUS.register((Object)new RendererSchematicGlobal());
            MinecraftForge.EVENT_BUS.register((Object)new ChatEventHandler());
            KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)new KeyBindingHandler(this.settings.keyBindings, new boolean[this.settings.keyBindings.length]));
            TickRegistry.registerTickHandler((ITickHandler)new Ticker(EnumSet.of(TickType.CLIENT)), (Side)Side.CLIENT);
            this.sortedWorldRenderers = ReflectionHelper.findField(bfl.class, (String[])new String[]{"n", "field_72768_k", "sortedWorldRenderers"});
        }
        catch (Exception e) {
            Settings.logger.c("Could not initialize the mod!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        File[] configurationFiles;
        String[] files = new String[]{"aliasVanilla", "flipVanilla", "rotationVanilla"};
        String mappingDir = "lunatrius/schematica/assets/mapping/";
        ClassLoader classLoader = this.getClass().getClassLoader();
        for (String filename : files) {
            this.loadConfigurationFile(classLoader.getResource(mappingDir + filename + ".properties"), filename + ".properties");
        }
        for (File configurationFile : configurationFiles = this.configurationFolder.listFiles(FILE_FILTER_CONFIGURATION)) {
            try {
                this.loadConfigurationFile(configurationFile.toURI().toURL(), configurationFile.getName());
            }
            catch (MalformedURLException e) {
                Settings.logger.c("Could not load properties file.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigurationFile(URL configurationFile, String configurationFilename) {
        if (configurationFile == null) {
            Settings.logger.a("Skipping " + configurationFilename + "...");
            return;
        }
        Properties properties = new Properties();
        InputStream inputStream = null;
        Settings.logger.a("Reading " + configurationFilename + "...");
        try {
            inputStream = configurationFile.openStream();
            properties.load(inputStream);
        }
        catch (IOException e) {
            Settings.logger.c("Could not load properties file.", (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                Settings.logger.c("Could not close properties file.", (Throwable)e);
            }
        }
        String filename = configurationFilename.toLowerCase();
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (filename.startsWith("alias")) {
                if (BlockInfo.addMappingAlias(key, value)) continue;
                Settings.logger.b("Failed alias: " + key + " => " + value);
                continue;
            }
            if (filename.startsWith("flip")) {
                if (BlockInfo.addMappingFlip(key, value)) continue;
                Settings.logger.b("Failed flip: " + key + " => " + value);
                continue;
            }
            if (!filename.startsWith("rotation") || BlockInfo.addMappingRotation(key, value)) continue;
            Settings.logger.b("Failed rotation: " + key + " => " + value);
        }
    }

    public void keyboardEvent(ats keyBinding, boolean down) {
        if (down) {
            this.settings.keyboardEvent(keyBinding);
        }
    }

    public boolean onTick(TickType tick, boolean start) {
        if (start) {
            return true;
        }
        this.profiler.a("schematica");
        if (tick == TickType.CLIENT && this.settings.minecraft.h != null && this.settings.isRenderingSchematic && this.settings.schematic != null) {
            this.profiler.a("printer");
            if (this.settings.isPrinterEnabled && this.settings.isPrinting && this.ticks-- < 0) {
                this.ticks = this.settings.placeDelay;
                this.printer.print();
            }
            this.profiler.c("checkDirty");
            this.checkDirty();
            this.profiler.c("canUpdate");
            RendererSchematicChunk.setCanUpdate(true);
            this.profiler.b();
        } else if (tick == TickType.CLIENT && this.settings.minecraft.h == null) {
            this.settings.chatLines = 0;
            this.settings.isPrinterEnabled = true;
            this.settings.isRenderingSchematic = false;
            this.settings.isRenderingGuide = false;
            this.settings.schematic = null;
            this.settings.mcWorldCache = null;
        }
        this.profiler.b();
        return true;
    }

    private void checkDirty() {
        if (this.sortedWorldRenderers != null) {
            try {
                bfa[] renderers = (bfa[])this.sortedWorldRenderers.get(this.settings.minecraft.g);
                if (renderers != null) {
                    int count = 0;
                    for (bfa worldRenderer : renderers) {
                        if (!worldRenderer.q || count++ >= 125) continue;
                        asx worldRendererBoundingBox = worldRenderer.r.c((double)(-this.settings.offset.x), (double)(-this.settings.offset.y), (double)(-this.settings.offset.z));
                        for (RendererSchematicChunk renderer : this.settings.sortedRendererSchematicChunk) {
                            if (renderer.getDirty() || !renderer.getBoundingBox().b(worldRendererBoundingBox)) continue;
                            renderer.setDirty();
                        }
                    }
                }
            }
            catch (Exception e) {
                Settings.logger.c("Dirty check failed!", (Throwable)e);
            }
        }
    }
}

